/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBudgetNotificationsForAccountResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeBudgetNotificationsForAccountResponse.Builder, DescribeBudgetNotificationsForAccountResponse> {
    private static final SdkField<List<BudgetNotificationsForAccount>> BUDGET_NOTIFICATIONS_FOR_ACCOUNT_FIELD = SdkField
            .<List<BudgetNotificationsForAccount>> builder(MarshallingType.LIST)
            .memberName("BudgetNotificationsForAccount")
            .getter(getter(DescribeBudgetNotificationsForAccountResponse::budgetNotificationsForAccount))
            .setter(setter(Builder::budgetNotificationsForAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetNotificationsForAccount")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetNotificationsForAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetNotificationsForAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeBudgetNotificationsForAccountResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUDGET_NOTIFICATIONS_FOR_ACCOUNT_FIELD, NEXT_TOKEN_FIELD));

    private final List<BudgetNotificationsForAccount> budgetNotificationsForAccount;

    private final String nextToken;

    private DescribeBudgetNotificationsForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.budgetNotificationsForAccount = builder.budgetNotificationsForAccount;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BudgetNotificationsForAccount property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBudgetNotificationsForAccount() {
        return budgetNotificationsForAccount != null && !(budgetNotificationsForAccount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of budget names and associated notifications for an account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBudgetNotificationsForAccount} method.
     * </p>
     * 
     * @return A list of budget names and associated notifications for an account.
     */
    public final List<BudgetNotificationsForAccount> budgetNotificationsForAccount() {
        return budgetNotificationsForAccount;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBudgetNotificationsForAccount() ? budgetNotificationsForAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetNotificationsForAccountResponse)) {
            return false;
        }
        DescribeBudgetNotificationsForAccountResponse other = (DescribeBudgetNotificationsForAccountResponse) obj;
        return hasBudgetNotificationsForAccount() == other.hasBudgetNotificationsForAccount()
                && Objects.equals(budgetNotificationsForAccount(), other.budgetNotificationsForAccount())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeBudgetNotificationsForAccountResponse")
                .add("BudgetNotificationsForAccount", hasBudgetNotificationsForAccount() ? budgetNotificationsForAccount() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetNotificationsForAccount":
            return Optional.ofNullable(clazz.cast(budgetNotificationsForAccount()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetNotificationsForAccountResponse, T> g) {
        return obj -> g.apply((DescribeBudgetNotificationsForAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBudgetNotificationsForAccountResponse> {
        /**
         * <p>
         * A list of budget names and associated notifications for an account.
         * </p>
         * 
         * @param budgetNotificationsForAccount
         *        A list of budget names and associated notifications for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetNotificationsForAccount(Collection<BudgetNotificationsForAccount> budgetNotificationsForAccount);

        /**
         * <p>
         * A list of budget names and associated notifications for an account.
         * </p>
         * 
         * @param budgetNotificationsForAccount
         *        A list of budget names and associated notifications for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetNotificationsForAccount(BudgetNotificationsForAccount... budgetNotificationsForAccount);

        /**
         * <p>
         * A list of budget names and associated notifications for an account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #budgetNotificationsForAccount(List<BudgetNotificationsForAccount>)}.
         * 
         * @param budgetNotificationsForAccount
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetNotificationsForAccount(java.util.Collection<BudgetNotificationsForAccount>)
         */
        Builder budgetNotificationsForAccount(Consumer<BudgetNotificationsForAccount.Builder>... budgetNotificationsForAccount);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<BudgetNotificationsForAccount> budgetNotificationsForAccount = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetNotificationsForAccountResponse model) {
            super(model);
            budgetNotificationsForAccount(model.budgetNotificationsForAccount);
            nextToken(model.nextToken);
        }

        public final List<BudgetNotificationsForAccount.Builder> getBudgetNotificationsForAccount() {
            List<BudgetNotificationsForAccount.Builder> result = BudgetNotificationsForAccountListCopier
                    .copyToBuilder(this.budgetNotificationsForAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgetNotificationsForAccount(
                Collection<BudgetNotificationsForAccount.BuilderImpl> budgetNotificationsForAccount) {
            this.budgetNotificationsForAccount = BudgetNotificationsForAccountListCopier
                    .copyFromBuilder(budgetNotificationsForAccount);
        }

        @Override
        public final Builder budgetNotificationsForAccount(Collection<BudgetNotificationsForAccount> budgetNotificationsForAccount) {
            this.budgetNotificationsForAccount = BudgetNotificationsForAccountListCopier.copy(budgetNotificationsForAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetNotificationsForAccount(BudgetNotificationsForAccount... budgetNotificationsForAccount) {
            budgetNotificationsForAccount(Arrays.asList(budgetNotificationsForAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgetNotificationsForAccount(
                Consumer<BudgetNotificationsForAccount.Builder>... budgetNotificationsForAccount) {
            budgetNotificationsForAccount(Stream.of(budgetNotificationsForAccount)
                    .map(c -> BudgetNotificationsForAccount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeBudgetNotificationsForAccountResponse build() {
            return new DescribeBudgetNotificationsForAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
