/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata for notebook, including the notebook name, ID, workgroup, and time created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotebookMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<NotebookMetadata.Builder, NotebookMetadata> {
    private static final SdkField<String> NOTEBOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookId").getter(getter(NotebookMetadata::notebookId)).setter(setter(Builder::notebookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NotebookMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(NotebookMetadata::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(NotebookMetadata::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(NotebookMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(NotebookMetadata::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_ID_FIELD, NAME_FIELD,
            WORK_GROUP_FIELD, CREATION_TIME_FIELD, TYPE_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String notebookId;

    private final String name;

    private final String workGroup;

    private final Instant creationTime;

    private final String type;

    private final Instant lastModifiedTime;

    private NotebookMetadata(BuilderImpl builder) {
        this.notebookId = builder.notebookId;
        this.name = builder.name;
        this.workGroup = builder.workGroup;
        this.creationTime = builder.creationTime;
        this.type = builder.type;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The notebook ID.
     * </p>
     * 
     * @return The notebook ID.
     */
    public final String notebookId() {
        return notebookId;
    }

    /**
     * <p>
     * The name of the notebook.
     * </p>
     * 
     * @return The name of the notebook.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to which the notebook belongs.
     * </p>
     * 
     * @return The name of the Spark enabled workgroup to which the notebook belongs.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The time when the notebook was created.
     * </p>
     * 
     * @return The time when the notebook was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotebookType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */
    public final NotebookType type() {
        return NotebookType.fromValue(type);
    }

    /**
     * <p>
     * The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotebookType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time when the notebook was last modified.
     * </p>
     * 
     * @return The time when the notebook was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notebookId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookMetadata)) {
            return false;
        }
        NotebookMetadata other = (NotebookMetadata) obj;
        return Objects.equals(notebookId(), other.notebookId()) && Objects.equals(name(), other.name())
                && Objects.equals(workGroup(), other.workGroup()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotebookMetadata").add("NotebookId", notebookId()).add("Name", name())
                .add("WorkGroup", workGroup()).add("CreationTime", creationTime()).add("Type", typeAsString())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookId":
            return Optional.ofNullable(clazz.cast(notebookId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotebookMetadata, T> g) {
        return obj -> g.apply((NotebookMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotebookMetadata> {
        /**
         * <p>
         * The notebook ID.
         * </p>
         * 
         * @param notebookId
         *        The notebook ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookId(String notebookId);

        /**
         * <p>
         * The name of the notebook.
         * </p>
         * 
         * @param name
         *        The name of the notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the Spark enabled workgroup to which the notebook belongs.
         * </p>
         * 
         * @param workGroup
         *        The name of the Spark enabled workgroup to which the notebook belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The time when the notebook was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the notebook was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
         * </p>
         * 
         * @param type
         *        The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
         * @see NotebookType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
         * </p>
         * 
         * @param type
         *        The type of notebook. Currently, the only valid type is <code>IPYNB</code>.
         * @see NotebookType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookType
         */
        Builder type(NotebookType type);

        /**
         * <p>
         * The time when the notebook was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the notebook was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String notebookId;

        private String name;

        private String workGroup;

        private Instant creationTime;

        private String type;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookMetadata model) {
            notebookId(model.notebookId);
            name(model.name);
            workGroup(model.workGroup);
            creationTime(model.creationTime);
            type(model.type);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNotebookId() {
            return notebookId;
        }

        public final void setNotebookId(String notebookId) {
            this.notebookId = notebookId;
        }

        @Override
        public final Builder notebookId(String notebookId) {
            this.notebookId = notebookId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotebookType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public NotebookMetadata build() {
            return new NotebookMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
