/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the submission time of a single allocation request for a capacity reservation and the most recent status of
 * the attempted allocation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityAllocation implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityAllocation.Builder, CapacityAllocation> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CapacityAllocation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(CapacityAllocation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTime").getter(getter(CapacityAllocation::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()).build();

    private static final SdkField<Instant> REQUEST_COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestCompletionTime").getter(getter(CapacityAllocation::requestCompletionTime))
            .setter(setter(Builder::requestCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCompletionTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_MESSAGE_FIELD, REQUEST_TIME_FIELD, REQUEST_COMPLETION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusMessage;

    private final Instant requestTime;

    private final Instant requestCompletionTime;

    private CapacityAllocation(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.requestTime = builder.requestTime;
        this.requestCompletionTime = builder.requestCompletionTime;
    }

    /**
     * <p>
     * The status of the capacity allocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the capacity allocation.
     * @see CapacityAllocationStatus
     */
    public final CapacityAllocationStatus status() {
        return CapacityAllocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the capacity allocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityAllocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the capacity allocation.
     * @see CapacityAllocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the capacity allocation.
     * </p>
     * 
     * @return The status message of the capacity allocation.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time when the capacity allocation was requested.
     * </p>
     * 
     * @return The time when the capacity allocation was requested.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * The time when the capacity allocation request was completed.
     * </p>
     * 
     * @return The time when the capacity allocation request was completed.
     */
    public final Instant requestCompletionTime() {
        return requestCompletionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(requestCompletionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAllocation)) {
            return false;
        }
        CapacityAllocation other = (CapacityAllocation) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(requestTime(), other.requestTime())
                && Objects.equals(requestCompletionTime(), other.requestCompletionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityAllocation").add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("RequestTime", requestTime()).add("RequestCompletionTime", requestCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "RequestCompletionTime":
            return Optional.ofNullable(clazz.cast(requestCompletionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityAllocation, T> g) {
        return obj -> g.apply((CapacityAllocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityAllocation> {
        /**
         * <p>
         * The status of the capacity allocation.
         * </p>
         * 
         * @param status
         *        The status of the capacity allocation.
         * @see CapacityAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityAllocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the capacity allocation.
         * </p>
         * 
         * @param status
         *        The status of the capacity allocation.
         * @see CapacityAllocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityAllocationStatus
         */
        Builder status(CapacityAllocationStatus status);

        /**
         * <p>
         * The status message of the capacity allocation.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the capacity allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time when the capacity allocation was requested.
         * </p>
         * 
         * @param requestTime
         *        The time when the capacity allocation was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * The time when the capacity allocation request was completed.
         * </p>
         * 
         * @param requestCompletionTime
         *        The time when the capacity allocation request was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCompletionTime(Instant requestCompletionTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private Instant requestTime;

        private Instant requestCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAllocation model) {
            status(model.status);
            statusMessage(model.statusMessage);
            requestTime(model.requestTime);
            requestCompletionTime(model.requestCompletionTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getRequestCompletionTime() {
            return requestCompletionTime;
        }

        public final void setRequestCompletionTime(Instant requestCompletionTime) {
            this.requestCompletionTime = requestCompletionTime;
        }

        @Override
        public final Builder requestCompletionTime(Instant requestCompletionTime) {
            this.requestCompletionTime = requestCompletionTime;
            return this;
        }

        @Override
        public CapacityAllocation build() {
            return new CapacityAllocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
