/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results. When Athena stores
 * query results in Amazon S3, the canned ACL is set with the <code>x-amz-acl</code> request header. For more
 * information about S3 Object Ownership, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview"
 * >Object Ownership settings</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AclConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AclConfiguration.Builder, AclConfiguration> {
    private static final SdkField<String> S3_ACL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3AclOption").getter(getter(AclConfiguration::s3AclOptionAsString)).setter(setter(Builder::s3AclOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AclOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACL_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3AclOption;

    private AclConfiguration(BuilderImpl builder) {
        this.s3AclOption = builder.s3AclOption;
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported
     * canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the workgroup overrides
     * client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries
     * that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3AclOption} will
     * return {@link S3AclOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AclOptionAsString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only
     *         supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the
     *         workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's
     *         settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned
     *         ACLs, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a>
     *         in the <i>Amazon S3 User Guide</i>.
     * @see S3AclOption
     */
    public final S3AclOption s3AclOption() {
        return S3AclOption.fromValue(s3AclOption);
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported
     * canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the workgroup overrides
     * client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries
     * that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3AclOption} will
     * return {@link S3AclOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AclOptionAsString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only
     *         supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the
     *         workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's
     *         settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned
     *         ACLs, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a>
     *         in the <i>Amazon S3 User Guide</i>.
     * @see S3AclOption
     */
    public final String s3AclOptionAsString() {
        return s3AclOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3AclOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AclConfiguration)) {
            return false;
        }
        AclConfiguration other = (AclConfiguration) obj;
        return Objects.equals(s3AclOptionAsString(), other.s3AclOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AclConfiguration").add("S3AclOption", s3AclOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3AclOption":
            return Optional.ofNullable(clazz.cast(s3AclOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AclConfiguration, T> g) {
        return obj -> g.apply((AclConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AclConfiguration> {
        /**
         * <p>
         * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported
         * canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the workgroup
         * overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used
         * for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in
         * the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param s3AclOption
         *        The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only
         *        supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the
         *        workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's
         *        settings is used for all queries that run in the workgroup. For more information about Amazon S3
         *        canned ACLs, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned
         *        ACL</a> in the <i>Amazon S3 User Guide</i>.
         * @see S3AclOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AclOption
         */
        Builder s3AclOption(String s3AclOption);

        /**
         * <p>
         * The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only supported
         * canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the workgroup
         * overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used
         * for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in
         * the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param s3AclOption
         *        The Amazon S3 canned ACL that Athena should specify when storing query results. Currently the only
         *        supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code>. If a query runs in a workgroup and the
         *        workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's
         *        settings is used for all queries that run in the workgroup. For more information about Amazon S3
         *        canned ACLs, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned
         *        ACL</a> in the <i>Amazon S3 User Guide</i>.
         * @see S3AclOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3AclOption
         */
        Builder s3AclOption(S3AclOption s3AclOption);
    }

    static final class BuilderImpl implements Builder {
        private String s3AclOption;

        private BuilderImpl() {
        }

        private BuilderImpl(AclConfiguration model) {
            s3AclOption(model.s3AclOption);
        }

        public final String getS3AclOption() {
            return s3AclOption;
        }

        public final void setS3AclOption(String s3AclOption) {
            this.s3AclOption = s3AclOption;
        }

        @Override
        public final Builder s3AclOption(String s3AclOption) {
            this.s3AclOption = s3AclOption;
            return this;
        }

        @Override
        public final Builder s3AclOption(S3AclOption s3AclOption) {
            this.s3AclOption(s3AclOption == null ? null : s3AclOption.toString());
            return this;
        }

        @Override
        public AclConfiguration build() {
            return new AclConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
