/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates an existing documentation version of an API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDocumentationVersionRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<UpdateDocumentationVersionRequest.Builder, UpdateDocumentationVersionRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(UpdateDocumentationVersionRequest::restApiId))
            .setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentationVersion").getter(getter(UpdateDocumentationVersionRequest::documentationVersion))
            .setter(setter(Builder::documentationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("doc_version").build()).build();

    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField
            .<List<PatchOperation>> builder(MarshallingType.LIST)
            .memberName("patchOperations")
            .getter(getter(UpdateDocumentationVersionRequest::patchOperations))
            .setter(setter(Builder::patchOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            DOCUMENTATION_VERSION_FIELD, PATCH_OPERATIONS_FIELD));

    private final String restApiId;

    private final String documentationVersion;

    private final List<PatchOperation> patchOperations;

    private UpdateDocumentationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.documentationVersion = builder.documentationVersion;
        this.patchOperations = builder.patchOperations;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The version identifier of the to-be-updated documentation version.
     * </p>
     * 
     * @return The version identifier of the to-be-updated documentation version.
     */
    public final String documentationVersion() {
        return documentationVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the PatchOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPatchOperations() {
        return patchOperations != null && !(patchOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For more information about supported patch operations, see <a
     * href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatchOperations} method.
     * </p>
     * 
     * @return For more information about supported patch operations, see <a
     *         href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
     */
    public final List<PatchOperation> patchOperations() {
        return patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchOperations() ? patchOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentationVersionRequest)) {
            return false;
        }
        UpdateDocumentationVersionRequest other = (UpdateDocumentationVersionRequest) obj;
        return Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(documentationVersion(), other.documentationVersion())
                && hasPatchOperations() == other.hasPatchOperations()
                && Objects.equals(patchOperations(), other.patchOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDocumentationVersionRequest").add("RestApiId", restApiId())
                .add("DocumentationVersion", documentationVersion())
                .add("PatchOperations", hasPatchOperations() ? patchOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "documentationVersion":
            return Optional.ofNullable(clazz.cast(documentationVersion()));
        case "patchOperations":
            return Optional.ofNullable(clazz.cast(patchOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDocumentationVersionRequest, T> g) {
        return obj -> g.apply((UpdateDocumentationVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDocumentationVersionRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The version identifier of the to-be-updated documentation version.
         * </p>
         * 
         * @param documentationVersion
         *        The version identifier of the to-be-updated documentation version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationVersion(String documentationVersion);

        /**
         * <p>
         * For more information about supported patch operations, see <a
         * href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
         * </p>
         * 
         * @param patchOperations
         *        For more information about supported patch operations, see <a
         *        href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(Collection<PatchOperation> patchOperations);

        /**
         * <p>
         * For more information about supported patch operations, see <a
         * href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
         * </p>
         * 
         * @param patchOperations
         *        For more information about supported patch operations, see <a
         *        href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(PatchOperation... patchOperations);

        /**
         * <p>
         * For more information about supported patch operations, see <a
         * href="https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html">Patch Operations</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigateway.model.PatchOperation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.apigateway.model.PatchOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigateway.model.PatchOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #patchOperations(List<PatchOperation>)}.
         * 
         * @param patchOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigateway.model.PatchOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchOperations(java.util.Collection<PatchOperation>)
         */
        Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String documentationVersion;

        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentationVersionRequest model) {
            super(model);
            restApiId(model.restApiId);
            documentationVersion(model.documentationVersion);
            patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getDocumentationVersion() {
            return documentationVersion;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final List<PatchOperation.Builder> getPatchOperations() {
            List<PatchOperation.Builder> result = ListOfPatchOperationCopier.copyToBuilder(this.patchOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation... patchOperations) {
            patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations) {
            patchOperations(Stream.of(patchOperations).map(c -> PatchOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentationVersionRequest build() {
            return new UpdateDocumentationVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
