/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for the list branches request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBranchesResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListBranchesResponse.Builder, ListBranchesResponse> {
    private static final SdkField<List<Branch>> BRANCHES_FIELD = SdkField
            .<List<Branch>> builder(MarshallingType.LIST)
            .memberName("branches")
            .getter(getter(ListBranchesResponse::branches))
            .setter(setter(Builder::branches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Branch> builder(MarshallingType.SDK_POJO)
                                            .constructor(Branch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBranchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Branch> branches;

    private final String nextToken;

    private ListBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.branches = builder.branches;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Branches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBranches() {
        return branches != null && !(branches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of branches for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBranches} method.
     * </p>
     * 
     * @return A list of branches for an Amplify app.
     */
    public final List<Branch> branches() {
        return branches;
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBranches() ? branches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBranchesResponse)) {
            return false;
        }
        ListBranchesResponse other = (ListBranchesResponse) obj;
        return hasBranches() == other.hasBranches() && Objects.equals(branches(), other.branches())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBranchesResponse").add("Branches", hasBranches() ? branches() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBranchesResponse, T> g) {
        return obj -> g.apply((ListBranchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBranchesResponse> {
        /**
         * <p>
         * A list of branches for an Amplify app.
         * </p>
         * 
         * @param branches
         *        A list of branches for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Collection<Branch> branches);

        /**
         * <p>
         * A list of branches for an Amplify app.
         * </p>
         * 
         * @param branches
         *        A list of branches for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Branch... branches);

        /**
         * <p>
         * A list of branches for an Amplify app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplify.model.Branch.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.amplify.model.Branch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplify.model.Branch.Builder#build()} is called immediately and its
         * result is passed to {@link #branches(List<Branch>)}.
         * 
         * @param branches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplify.model.Branch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branches(java.util.Collection<Branch>)
         */
        Builder branches(Consumer<Branch.Builder>... branches);

        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<Branch> branches = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBranchesResponse model) {
            super(model);
            branches(model.branches);
            nextToken(model.nextToken);
        }

        public final List<Branch.Builder> getBranches() {
            List<Branch.Builder> result = BranchesCopier.copyToBuilder(this.branches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBranches(Collection<Branch.BuilderImpl> branches) {
            this.branches = BranchesCopier.copyFromBuilder(branches);
        }

        @Override
        public final Builder branches(Collection<Branch> branches) {
            this.branches = BranchesCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Branch... branches) {
            branches(Arrays.asList(branches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Consumer<Branch.Builder>... branches) {
            branches(Stream.of(branches).map(c -> Branch.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBranchesResponse build() {
            return new ListBranchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
