/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProactiveJoin implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProactiveJoin.Builder, UpdateProactiveJoin> {
    private static final SdkField<Boolean> ENABLED_BY_MOTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnabledByMotion").getter(getter(UpdateProactiveJoin::enabledByMotion))
            .setter(setter(Builder::enabledByMotion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledByMotion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_BY_MOTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabledByMotion;

    private UpdateProactiveJoin(BuilderImpl builder) {
        this.enabledByMotion = builder.enabledByMotion;
    }

    /**
     * Returns the value of the EnabledByMotion property for this object.
     * 
     * @return The value of the EnabledByMotion property for this object.
     */
    public final Boolean enabledByMotion() {
        return enabledByMotion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabledByMotion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProactiveJoin)) {
            return false;
        }
        UpdateProactiveJoin other = (UpdateProactiveJoin) obj;
        return Objects.equals(enabledByMotion(), other.enabledByMotion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProactiveJoin").add("EnabledByMotion", enabledByMotion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledByMotion":
            return Optional.ofNullable(clazz.cast(enabledByMotion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProactiveJoin, T> g) {
        return obj -> g.apply((UpdateProactiveJoin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProactiveJoin> {
        /**
         * Sets the value of the EnabledByMotion property for this object.
         *
         * @param enabledByMotion
         *        The new value for the EnabledByMotion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledByMotion(Boolean enabledByMotion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabledByMotion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProactiveJoin model) {
            enabledByMotion(model.enabledByMotion);
        }

        public final Boolean getEnabledByMotion() {
            return enabledByMotion;
        }

        public final void setEnabledByMotion(Boolean enabledByMotion) {
            this.enabledByMotion = enabledByMotion;
        }

        @Override
        public final Builder enabledByMotion(Boolean enabledByMotion) {
            this.enabledByMotion = enabledByMotion;
            return this;
        }

        @Override
        public UpdateProactiveJoin build() {
            return new UpdateProactiveJoin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
