/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultContentBlocksCopier;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolResultBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolResultBlock> {
    private static final SdkField<String> TOOL_USE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toolUseId").getter(ToolResultBlock.getter(ToolResultBlock::toolUseId)).setter(ToolResultBlock.setter(Builder::toolUseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseId").build()}).build();
    private static final SdkField<List<ToolResultContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(ToolResultBlock.getter(ToolResultBlock::content)).setter(ToolResultBlock.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolResultContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ToolResultBlock.getter(ToolResultBlock::statusAsString)).setter(ToolResultBlock.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_USE_ID_FIELD, CONTENT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolResultBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String toolUseId;
    private final List<ToolResultContentBlock> content;
    private final String status;

    private ToolResultBlock(BuilderImpl builder) {
        this.toolUseId = builder.toolUseId;
        this.content = builder.content;
        this.status = builder.status;
    }

    public final String toolUseId() {
        return this.toolUseId;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<ToolResultContentBlock> content() {
        return this.content;
    }

    public final ToolResultStatus status() {
        return ToolResultStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultBlock)) {
            return false;
        }
        ToolResultBlock other = (ToolResultBlock)obj;
        return Objects.equals(this.toolUseId(), other.toolUseId()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ToolResultBlock").add("ToolUseId", (Object)this.toolUseId()).add("Content", this.hasContent() ? this.content() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toolUseId": {
                return Optional.ofNullable(clazz.cast(this.toolUseId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("toolUseId", TOOL_USE_ID_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolResultBlock, T> g) {
        return obj -> g.apply((ToolResultBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String toolUseId;
        private List<ToolResultContentBlock> content = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultBlock model) {
            this.toolUseId(model.toolUseId);
            this.content(model.content);
            this.status(model.status);
        }

        public final String getToolUseId() {
            return this.toolUseId;
        }

        public final void setToolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
        }

        @Override
        public final Builder toolUseId(String toolUseId) {
            this.toolUseId = toolUseId;
            return this;
        }

        public final List<ToolResultContentBlock.Builder> getContent() {
            List<ToolResultContentBlock.Builder> result = ToolResultContentBlocksCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<ToolResultContentBlock.BuilderImpl> content) {
            this.content = ToolResultContentBlocksCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<ToolResultContentBlock> content) {
            this.content = ToolResultContentBlocksCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(ToolResultContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<ToolResultContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (ToolResultContentBlock)((ToolResultContentBlock.Builder)ToolResultContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ToolResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ToolResultBlock build() {
            return new ToolResultBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolResultBlock> {
        public Builder toolUseId(String var1);

        public Builder content(Collection<ToolResultContentBlock> var1);

        public Builder content(ToolResultContentBlock ... var1);

        public Builder content(Consumer<ToolResultContentBlock.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ToolResultStatus var1);
    }
}

