/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content block delta event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ContentBlockDeltaEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentBlockDeltaEvent.Builder, ContentBlockDeltaEvent>, ConverseStreamOutput {
    private static final SdkField<ContentBlockDelta> DELTA_FIELD = SdkField.<ContentBlockDelta> builder(MarshallingType.SDK_POJO)
            .memberName("delta").getter(getter(ContentBlockDeltaEvent::delta)).setter(setter(Builder::delta))
            .constructor(ContentBlockDelta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delta").build()).build();

    private static final SdkField<Integer> CONTENT_BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("contentBlockIndex").getter(getter(ContentBlockDeltaEvent::contentBlockIndex))
            .setter(setter(Builder::contentBlockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlockIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELTA_FIELD,
            CONTENT_BLOCK_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContentBlockDelta delta;

    private final Integer contentBlockIndex;

    protected ContentBlockDeltaEvent(BuilderImpl builder) {
        this.delta = builder.delta;
        this.contentBlockIndex = builder.contentBlockIndex;
    }

    /**
     * <p>
     * The delta for a content block delta event.
     * </p>
     * 
     * @return The delta for a content block delta event.
     */
    public final ContentBlockDelta delta() {
        return delta;
    }

    /**
     * <p>
     * The block index for a content block delta event.
     * </p>
     * 
     * @return The block index for a content block delta event.
     */
    public final Integer contentBlockIndex() {
        return contentBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delta());
        hashCode = 31 * hashCode + Objects.hashCode(contentBlockIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockDeltaEvent)) {
            return false;
        }
        ContentBlockDeltaEvent other = (ContentBlockDeltaEvent) obj;
        return Objects.equals(delta(), other.delta()) && Objects.equals(contentBlockIndex(), other.contentBlockIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlockDeltaEvent").add("Delta", delta()).add("ContentBlockIndex", contentBlockIndex())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delta":
            return Optional.ofNullable(clazz.cast(delta()));
        case "contentBlockIndex":
            return Optional.ofNullable(clazz.cast(contentBlockIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ContentBlockDeltaEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockDeltaEvent, T> g) {
        return obj -> g.apply((ContentBlockDeltaEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link ContentBlockDeltaEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlockDeltaEvent> {
        /**
         * <p>
         * The delta for a content block delta event.
         * </p>
         * 
         * @param delta
         *        The delta for a content block delta event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delta(ContentBlockDelta delta);

        /**
         * <p>
         * The delta for a content block delta event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentBlockDelta.Builder} avoiding the
         * need to create one manually via {@link ContentBlockDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentBlockDelta.Builder#build()} is called immediately and its
         * result is passed to {@link #delta(ContentBlockDelta)}.
         * 
         * @param delta
         *        a consumer that will call methods on {@link ContentBlockDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delta(ContentBlockDelta)
         */
        default Builder delta(Consumer<ContentBlockDelta.Builder> delta) {
            return delta(ContentBlockDelta.builder().applyMutation(delta).build());
        }

        /**
         * <p>
         * The block index for a content block delta event.
         * </p>
         * 
         * @param contentBlockIndex
         *        The block index for a content block delta event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentBlockIndex(Integer contentBlockIndex);
    }

    protected static class BuilderImpl implements Builder {
        private ContentBlockDelta delta;

        private Integer contentBlockIndex;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ContentBlockDeltaEvent model) {
            delta(model.delta);
            contentBlockIndex(model.contentBlockIndex);
        }

        public final ContentBlockDelta.Builder getDelta() {
            return delta != null ? delta.toBuilder() : null;
        }

        public final void setDelta(ContentBlockDelta.BuilderImpl delta) {
            this.delta = delta != null ? delta.build() : null;
        }

        @Override
        public final Builder delta(ContentBlockDelta delta) {
            this.delta = delta;
            return this;
        }

        public final Integer getContentBlockIndex() {
            return contentBlockIndex;
        }

        public final void setContentBlockIndex(Integer contentBlockIndex) {
            this.contentBlockIndex = contentBlockIndex;
        }

        @Override
        public final Builder contentBlockIndex(Integer contentBlockIndex) {
            this.contentBlockIndex = contentBlockIndex;
            return this;
        }

        @Override
        public ContentBlockDeltaEvent build() {
            return new ContentBlockDeltaEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
