/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.CalculatedLifecycle;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.services.backup.model.RecoveryPointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryPointByBackupVault
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryPointByBackupVault> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::recoveryPointArn)).setter(RecoveryPointByBackupVault.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::backupVaultName)).setter(RecoveryPointByBackupVault.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::backupVaultArn)).setter(RecoveryPointByBackupVault.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::resourceArn)).setter(RecoveryPointByBackupVault.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::resourceType)).setter(RecoveryPointByBackupVault.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::createdBy)).setter(RecoveryPointByBackupVault.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::iamRoleArn)).setter(RecoveryPointByBackupVault.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::statusAsString)).setter(RecoveryPointByBackupVault.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::creationDate)).setter(RecoveryPointByBackupVault.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::completionDate)).setter(RecoveryPointByBackupVault.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::backupSizeInBytes)).setter(RecoveryPointByBackupVault.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::calculatedLifecycle)).setter(RecoveryPointByBackupVault.setter(Builder::calculatedLifecycle)).constructor(CalculatedLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::lifecycle)).setter(RecoveryPointByBackupVault.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::encryptionKeyArn)).setter(RecoveryPointByBackupVault.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::isEncrypted)).setter(RecoveryPointByBackupVault.setter(Builder::isEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEncrypted").build()}).build();
    private static final SdkField<Instant> LAST_RESTORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RecoveryPointByBackupVault.getter(RecoveryPointByBackupVault::lastRestoreTime)).setter(RecoveryPointByBackupVault.setter(Builder::lastRestoreTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRestoreTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, CREATED_BY_FIELD, IAM_ROLE_ARN_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, CALCULATED_LIFECYCLE_FIELD, LIFECYCLE_FIELD, ENCRYPTION_KEY_ARN_FIELD, IS_ENCRYPTED_FIELD, LAST_RESTORE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recoveryPointArn;
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String resourceArn;
    private final String resourceType;
    private final RecoveryPointCreator createdBy;
    private final String iamRoleArn;
    private final String status;
    private final Instant creationDate;
    private final Instant completionDate;
    private final Long backupSizeInBytes;
    private final CalculatedLifecycle calculatedLifecycle;
    private final Lifecycle lifecycle;
    private final String encryptionKeyArn;
    private final Boolean isEncrypted;
    private final Instant lastRestoreTime;

    private RecoveryPointByBackupVault(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.createdBy = builder.createdBy;
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.calculatedLifecycle = builder.calculatedLifecycle;
        this.lifecycle = builder.lifecycle;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.isEncrypted = builder.isEncrypted;
        this.lastRestoreTime = builder.lastRestoreTime;
    }

    public String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant completionDate() {
        return this.completionDate;
    }

    public Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public CalculatedLifecycle calculatedLifecycle() {
        return this.calculatedLifecycle;
    }

    public Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public Instant lastRestoreTime() {
        return this.lastRestoreTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRestoreTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByBackupVault)) {
            return false;
        }
        RecoveryPointByBackupVault other = (RecoveryPointByBackupVault)obj;
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.calculatedLifecycle(), other.calculatedLifecycle()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.isEncrypted(), other.isEncrypted()) && Objects.equals(this.lastRestoreTime(), other.lastRestoreTime());
    }

    public String toString() {
        return ToString.builder((String)"RecoveryPointByBackupVault").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceType()).add("CreatedBy", (Object)this.createdBy()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("CalculatedLifecycle", (Object)this.calculatedLifecycle()).add("Lifecycle", (Object)this.lifecycle()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("IsEncrypted", (Object)this.isEncrypted()).add("LastRestoreTime", (Object)this.lastRestoreTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "CalculatedLifecycle": {
                return Optional.ofNullable(clazz.cast(this.calculatedLifecycle()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "IsEncrypted": {
                return Optional.ofNullable(clazz.cast(this.isEncrypted()));
            }
            case "LastRestoreTime": {
                return Optional.ofNullable(clazz.cast(this.lastRestoreTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByBackupVault, T> g) {
        return obj -> g.apply((RecoveryPointByBackupVault)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private String backupVaultName;
        private String backupVaultArn;
        private String resourceArn;
        private String resourceType;
        private RecoveryPointCreator createdBy;
        private String iamRoleArn;
        private String status;
        private Instant creationDate;
        private Instant completionDate;
        private Long backupSizeInBytes;
        private CalculatedLifecycle calculatedLifecycle;
        private Lifecycle lifecycle;
        private String encryptionKeyArn;
        private Boolean isEncrypted;
        private Instant lastRestoreTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByBackupVault model) {
            this.recoveryPointArn(model.recoveryPointArn);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.createdBy(model.createdBy);
            this.iamRoleArn(model.iamRoleArn);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.calculatedLifecycle(model.calculatedLifecycle);
            this.lifecycle(model.lifecycle);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.isEncrypted(model.isEncrypted);
            this.lastRestoreTime(model.lastRestoreTime);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return this.calculatedLifecycle != null ? this.calculatedLifecycle.toBuilder() : null;
        }

        @Override
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final Boolean getIsEncrypted() {
            return this.isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        public final Instant getLastRestoreTime() {
            return this.lastRestoreTime;
        }

        @Override
        public final Builder lastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
            return this;
        }

        public final void setLastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
        }

        public RecoveryPointByBackupVault build() {
            return new RecoveryPointByBackupVault(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryPointByBackupVault> {
        public Builder recoveryPointArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder iamRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(RecoveryPointStatus var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder calculatedLifecycle(CalculatedLifecycle var1);

        default public Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return this.calculatedLifecycle((CalculatedLifecycle)((CalculatedLifecycle.Builder)CalculatedLifecycle.builder().applyMutation(calculatedLifecycle)).build());
        }

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder encryptionKeyArn(String var1);

        public Builder isEncrypted(Boolean var1);

        public Builder lastRestoreTime(Instant var1);
    }
}

