/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.ReportDeliveryChannel;
import software.amazon.awssdk.services.backup.model.ReportSetting;
import software.amazon.awssdk.services.backup.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReportPlanRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateReportPlanRequest> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanName").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::reportPlanName)).setter(CreateReportPlanRequest.setter(Builder::reportPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()}).build();
    private static final SdkField<String> REPORT_PLAN_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanDescription").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::reportPlanDescription)).setter(CreateReportPlanRequest.setter(Builder::reportPlanDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanDescription").build()}).build();
    private static final SdkField<ReportDeliveryChannel> REPORT_DELIVERY_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportDeliveryChannel").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::reportDeliveryChannel)).setter(CreateReportPlanRequest.setter(Builder::reportDeliveryChannel)).constructor(ReportDeliveryChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDeliveryChannel").build()}).build();
    private static final SdkField<ReportSetting> REPORT_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportSetting").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::reportSetting)).setter(CreateReportPlanRequest.setter(Builder::reportSetting)).constructor(ReportSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSetting").build()}).build();
    private static final SdkField<Map<String, String>> REPORT_PLAN_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ReportPlanTags").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::reportPlanTags)).setter(CreateReportPlanRequest.setter(Builder::reportPlanTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateReportPlanRequest.getter(CreateReportPlanRequest::idempotencyToken)).setter(CreateReportPlanRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD, REPORT_PLAN_DESCRIPTION_FIELD, REPORT_DELIVERY_CHANNEL_FIELD, REPORT_SETTING_FIELD, REPORT_PLAN_TAGS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReportPlanRequest.memberNameToFieldInitializer();
    private final String reportPlanName;
    private final String reportPlanDescription;
    private final ReportDeliveryChannel reportDeliveryChannel;
    private final ReportSetting reportSetting;
    private final Map<String, String> reportPlanTags;
    private final String idempotencyToken;

    private CreateReportPlanRequest(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanDescription = builder.reportPlanDescription;
        this.reportDeliveryChannel = builder.reportDeliveryChannel;
        this.reportSetting = builder.reportSetting;
        this.reportPlanTags = builder.reportPlanTags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String reportPlanName() {
        return this.reportPlanName;
    }

    public final String reportPlanDescription() {
        return this.reportPlanDescription;
    }

    public final ReportDeliveryChannel reportDeliveryChannel() {
        return this.reportDeliveryChannel;
    }

    public final ReportSetting reportSetting() {
        return this.reportSetting;
    }

    public final boolean hasReportPlanTags() {
        return this.reportPlanTags != null && !(this.reportPlanTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> reportPlanTags() {
        return this.reportPlanTags;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDeliveryChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportPlanTags() ? this.reportPlanTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReportPlanRequest)) {
            return false;
        }
        CreateReportPlanRequest other = (CreateReportPlanRequest)((Object)obj);
        return Objects.equals(this.reportPlanName(), other.reportPlanName()) && Objects.equals(this.reportPlanDescription(), other.reportPlanDescription()) && Objects.equals(this.reportDeliveryChannel(), other.reportDeliveryChannel()) && Objects.equals(this.reportSetting(), other.reportSetting()) && this.hasReportPlanTags() == other.hasReportPlanTags() && Objects.equals(this.reportPlanTags(), other.reportPlanTags()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReportPlanRequest").add("ReportPlanName", (Object)this.reportPlanName()).add("ReportPlanDescription", (Object)this.reportPlanDescription()).add("ReportDeliveryChannel", (Object)this.reportDeliveryChannel()).add("ReportSetting", (Object)this.reportSetting()).add("ReportPlanTags", this.hasReportPlanTags() ? this.reportPlanTags() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportPlanName": {
                return Optional.ofNullable(clazz.cast(this.reportPlanName()));
            }
            case "ReportPlanDescription": {
                return Optional.ofNullable(clazz.cast(this.reportPlanDescription()));
            }
            case "ReportDeliveryChannel": {
                return Optional.ofNullable(clazz.cast(this.reportDeliveryChannel()));
            }
            case "ReportSetting": {
                return Optional.ofNullable(clazz.cast(this.reportSetting()));
            }
            case "ReportPlanTags": {
                return Optional.ofNullable(clazz.cast(this.reportPlanTags()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportPlanName", REPORT_PLAN_NAME_FIELD);
        map.put("ReportPlanDescription", REPORT_PLAN_DESCRIPTION_FIELD);
        map.put("ReportDeliveryChannel", REPORT_DELIVERY_CHANNEL_FIELD);
        map.put("ReportSetting", REPORT_SETTING_FIELD);
        map.put("ReportPlanTags", REPORT_PLAN_TAGS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReportPlanRequest, T> g) {
        return obj -> g.apply((CreateReportPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String reportPlanName;
        private String reportPlanDescription;
        private ReportDeliveryChannel reportDeliveryChannel;
        private ReportSetting reportSetting;
        private Map<String, String> reportPlanTags = DefaultSdkAutoConstructMap.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReportPlanRequest model) {
            super(model);
            this.reportPlanName(model.reportPlanName);
            this.reportPlanDescription(model.reportPlanDescription);
            this.reportDeliveryChannel(model.reportDeliveryChannel);
            this.reportSetting(model.reportSetting);
            this.reportPlanTags(model.reportPlanTags);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getReportPlanName() {
            return this.reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanDescription() {
            return this.reportPlanDescription;
        }

        public final void setReportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
        }

        @Override
        public final Builder reportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        public final ReportDeliveryChannel.Builder getReportDeliveryChannel() {
            return this.reportDeliveryChannel != null ? this.reportDeliveryChannel.toBuilder() : null;
        }

        public final void setReportDeliveryChannel(ReportDeliveryChannel.BuilderImpl reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel != null ? reportDeliveryChannel.build() : null;
        }

        @Override
        public final Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        public final ReportSetting.Builder getReportSetting() {
            return this.reportSetting != null ? this.reportSetting.toBuilder() : null;
        }

        public final void setReportSetting(ReportSetting.BuilderImpl reportSetting) {
            this.reportSetting = reportSetting != null ? reportSetting.build() : null;
        }

        @Override
        public final Builder reportSetting(ReportSetting reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        public final Map<String, String> getReportPlanTags() {
            if (this.reportPlanTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.reportPlanTags;
        }

        public final void setReportPlanTags(Map<String, String> reportPlanTags) {
            this.reportPlanTags = _stringMapCopier.copy(reportPlanTags);
        }

        @Override
        public final Builder reportPlanTags(Map<String, String> reportPlanTags) {
            this.reportPlanTags = _stringMapCopier.copy(reportPlanTags);
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReportPlanRequest build() {
            return new CreateReportPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReportPlanRequest> {
        public Builder reportPlanName(String var1);

        public Builder reportPlanDescription(String var1);

        public Builder reportDeliveryChannel(ReportDeliveryChannel var1);

        default public Builder reportDeliveryChannel(Consumer<ReportDeliveryChannel.Builder> reportDeliveryChannel) {
            return this.reportDeliveryChannel((ReportDeliveryChannel)((ReportDeliveryChannel.Builder)ReportDeliveryChannel.builder().applyMutation(reportDeliveryChannel)).build());
        }

        public Builder reportSetting(ReportSetting var1);

        default public Builder reportSetting(Consumer<ReportSetting.Builder> reportSetting) {
            return this.reportSetting((ReportSetting)((ReportSetting.Builder)ReportSetting.builder().applyMutation(reportSetting)).build());
        }

        public Builder reportPlanTags(Map<String, String> var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

