/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.ProtectedResourceConditions;
import software.amazon.awssdk.services.backup.model.SensitiveStringMapCopier;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTestingSelectionForGet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreTestingSelectionForGet> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::creationTime)).setter(RestoreTestingSelectionForGet.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::creatorRequestId)).setter(RestoreTestingSelectionForGet.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::iamRoleArn)).setter(RestoreTestingSelectionForGet.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<String>> PROTECTED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectedResourceArns").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::protectedResourceArns)).setter(RestoreTestingSelectionForGet.setter(Builder::protectedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProtectedResourceConditions> PROTECTED_RESOURCE_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtectedResourceConditions").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::protectedResourceConditions)).setter(RestoreTestingSelectionForGet.setter(Builder::protectedResourceConditions)).constructor(ProtectedResourceConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceConditions").build()}).build();
    private static final SdkField<String> PROTECTED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectedResourceType").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::protectedResourceType)).setter(RestoreTestingSelectionForGet.setter(Builder::protectedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceType").build()}).build();
    private static final SdkField<Map<String, String>> RESTORE_METADATA_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RestoreMetadataOverrides").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::restoreMetadataOverrides)).setter(RestoreTestingSelectionForGet.setter(Builder::restoreMetadataOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadataOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingPlanName").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::restoreTestingPlanName)).setter(RestoreTestingSelectionForGet.setter(Builder::restoreTestingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build()}).build();
    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingSelectionName").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::restoreTestingSelectionName)).setter(RestoreTestingSelectionForGet.setter(Builder::restoreTestingSelectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelectionName").build()}).build();
    private static final SdkField<Integer> VALIDATION_WINDOW_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValidationWindowHours").getter(RestoreTestingSelectionForGet.getter(RestoreTestingSelectionForGet::validationWindowHours)).setter(RestoreTestingSelectionForGet.setter(Builder::validationWindowHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationWindowHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, CREATOR_REQUEST_ID_FIELD, IAM_ROLE_ARN_FIELD, PROTECTED_RESOURCE_ARNS_FIELD, PROTECTED_RESOURCE_CONDITIONS_FIELD, PROTECTED_RESOURCE_TYPE_FIELD, RESTORE_METADATA_OVERRIDES_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD, VALIDATION_WINDOW_HOURS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreTestingSelectionForGet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String creatorRequestId;
    private final String iamRoleArn;
    private final List<String> protectedResourceArns;
    private final ProtectedResourceConditions protectedResourceConditions;
    private final String protectedResourceType;
    private final Map<String, String> restoreMetadataOverrides;
    private final String restoreTestingPlanName;
    private final String restoreTestingSelectionName;
    private final Integer validationWindowHours;

    private RestoreTestingSelectionForGet(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.creatorRequestId = builder.creatorRequestId;
        this.iamRoleArn = builder.iamRoleArn;
        this.protectedResourceArns = builder.protectedResourceArns;
        this.protectedResourceConditions = builder.protectedResourceConditions;
        this.protectedResourceType = builder.protectedResourceType;
        this.restoreMetadataOverrides = builder.restoreMetadataOverrides;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
        this.validationWindowHours = builder.validationWindowHours;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasProtectedResourceArns() {
        return this.protectedResourceArns != null && !(this.protectedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> protectedResourceArns() {
        return this.protectedResourceArns;
    }

    public final ProtectedResourceConditions protectedResourceConditions() {
        return this.protectedResourceConditions;
    }

    public final String protectedResourceType() {
        return this.protectedResourceType;
    }

    public final boolean hasRestoreMetadataOverrides() {
        return this.restoreMetadataOverrides != null && !(this.restoreMetadataOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> restoreMetadataOverrides() {
        return this.restoreMetadataOverrides;
    }

    public final String restoreTestingPlanName() {
        return this.restoreTestingPlanName;
    }

    public final String restoreTestingSelectionName() {
        return this.restoreTestingSelectionName;
    }

    public final Integer validationWindowHours() {
        return this.validationWindowHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectedResourceArns() ? this.protectedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreMetadataOverrides() ? this.restoreMetadataOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingSelectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationWindowHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingSelectionForGet)) {
            return false;
        }
        RestoreTestingSelectionForGet other = (RestoreTestingSelectionForGet)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasProtectedResourceArns() == other.hasProtectedResourceArns() && Objects.equals(this.protectedResourceArns(), other.protectedResourceArns()) && Objects.equals(this.protectedResourceConditions(), other.protectedResourceConditions()) && Objects.equals(this.protectedResourceType(), other.protectedResourceType()) && this.hasRestoreMetadataOverrides() == other.hasRestoreMetadataOverrides() && Objects.equals(this.restoreMetadataOverrides(), other.restoreMetadataOverrides()) && Objects.equals(this.restoreTestingPlanName(), other.restoreTestingPlanName()) && Objects.equals(this.restoreTestingSelectionName(), other.restoreTestingSelectionName()) && Objects.equals(this.validationWindowHours(), other.validationWindowHours());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTestingSelectionForGet").add("CreationTime", (Object)this.creationTime()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ProtectedResourceArns", this.hasProtectedResourceArns() ? this.protectedResourceArns() : null).add("ProtectedResourceConditions", (Object)this.protectedResourceConditions()).add("ProtectedResourceType", (Object)this.protectedResourceType()).add("RestoreMetadataOverrides", (Object)(this.restoreMetadataOverrides() == null ? null : "*** Sensitive Data Redacted ***")).add("RestoreTestingPlanName", (Object)this.restoreTestingPlanName()).add("RestoreTestingSelectionName", (Object)this.restoreTestingSelectionName()).add("ValidationWindowHours", (Object)this.validationWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ProtectedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceArns()));
            }
            case "ProtectedResourceConditions": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceConditions()));
            }
            case "ProtectedResourceType": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceType()));
            }
            case "RestoreMetadataOverrides": {
                return Optional.ofNullable(clazz.cast(this.restoreMetadataOverrides()));
            }
            case "RestoreTestingPlanName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingPlanName()));
            }
            case "RestoreTestingSelectionName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelectionName()));
            }
            case "ValidationWindowHours": {
                return Optional.ofNullable(clazz.cast(this.validationWindowHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ProtectedResourceArns", PROTECTED_RESOURCE_ARNS_FIELD);
        map.put("ProtectedResourceConditions", PROTECTED_RESOURCE_CONDITIONS_FIELD);
        map.put("ProtectedResourceType", PROTECTED_RESOURCE_TYPE_FIELD);
        map.put("RestoreMetadataOverrides", RESTORE_METADATA_OVERRIDES_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelectionName", RESTORE_TESTING_SELECTION_NAME_FIELD);
        map.put("ValidationWindowHours", VALIDATION_WINDOW_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingSelectionForGet, T> g) {
        return obj -> g.apply((RestoreTestingSelectionForGet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String creatorRequestId;
        private String iamRoleArn;
        private List<String> protectedResourceArns = DefaultSdkAutoConstructList.getInstance();
        private ProtectedResourceConditions protectedResourceConditions;
        private String protectedResourceType;
        private Map<String, String> restoreMetadataOverrides = DefaultSdkAutoConstructMap.getInstance();
        private String restoreTestingPlanName;
        private String restoreTestingSelectionName;
        private Integer validationWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingSelectionForGet model) {
            this.creationTime(model.creationTime);
            this.creatorRequestId(model.creatorRequestId);
            this.iamRoleArn(model.iamRoleArn);
            this.protectedResourceArns(model.protectedResourceArns);
            this.protectedResourceConditions(model.protectedResourceConditions);
            this.protectedResourceType(model.protectedResourceType);
            this.restoreMetadataOverrides(model.restoreMetadataOverrides);
            this.restoreTestingPlanName(model.restoreTestingPlanName);
            this.restoreTestingSelectionName(model.restoreTestingSelectionName);
            this.validationWindowHours(model.validationWindowHours);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getProtectedResourceArns() {
            if (this.protectedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectedResourceArns;
        }

        public final void setProtectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
        }

        @Override
        public final Builder protectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceArns(String ... protectedResourceArns) {
            this.protectedResourceArns(Arrays.asList(protectedResourceArns));
            return this;
        }

        public final ProtectedResourceConditions.Builder getProtectedResourceConditions() {
            return this.protectedResourceConditions != null ? this.protectedResourceConditions.toBuilder() : null;
        }

        public final void setProtectedResourceConditions(ProtectedResourceConditions.BuilderImpl protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions != null ? protectedResourceConditions.build() : null;
        }

        @Override
        public final Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        public final String getProtectedResourceType() {
            return this.protectedResourceType;
        }

        public final void setProtectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
        }

        @Override
        public final Builder protectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
            return this;
        }

        public final Map<String, String> getRestoreMetadataOverrides() {
            if (this.restoreMetadataOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.restoreMetadataOverrides;
        }

        public final void setRestoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
        }

        @Override
        public final Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return this.restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        public final Integer getValidationWindowHours() {
            return this.validationWindowHours;
        }

        public final void setValidationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
        }

        @Override
        public final Builder validationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        public RestoreTestingSelectionForGet build() {
            return new RestoreTestingSelectionForGet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreTestingSelectionForGet> {
        public Builder creationTime(Instant var1);

        public Builder creatorRequestId(String var1);

        public Builder iamRoleArn(String var1);

        public Builder protectedResourceArns(Collection<String> var1);

        public Builder protectedResourceArns(String ... var1);

        public Builder protectedResourceConditions(ProtectedResourceConditions var1);

        default public Builder protectedResourceConditions(Consumer<ProtectedResourceConditions.Builder> protectedResourceConditions) {
            return this.protectedResourceConditions((ProtectedResourceConditions)((ProtectedResourceConditions.Builder)ProtectedResourceConditions.builder().applyMutation(protectedResourceConditions)).build());
        }

        public Builder protectedResourceType(String var1);

        public Builder restoreMetadataOverrides(Map<String, String> var1);

        public Builder restoreTestingPlanName(String var1);

        public Builder restoreTestingSelectionName(String var1);

        public Builder validationWindowHours(Integer var1);
    }
}

