/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.CopyJob;
import software.amazon.awssdk.services.backup.model.CopyJobsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCopyJobsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListCopyJobsResponse> {
    private static final SdkField<List<CopyJob>> COPY_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CopyJobs").getter(ListCopyJobsResponse.getter(ListCopyJobsResponse::copyJobs)).setter(ListCopyJobsResponse.setter(Builder::copyJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CopyJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCopyJobsResponse.getter(ListCopyJobsResponse::nextToken)).setter(ListCopyJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CopyJobs", COPY_JOBS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CopyJob> copyJobs;
    private final String nextToken;

    private ListCopyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.copyJobs = builder.copyJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCopyJobs() {
        return this.copyJobs != null && !(this.copyJobs instanceof SdkAutoConstructList);
    }

    public final List<CopyJob> copyJobs() {
        return this.copyJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCopyJobs() ? this.copyJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCopyJobsResponse)) {
            return false;
        }
        ListCopyJobsResponse other = (ListCopyJobsResponse)((Object)obj);
        return this.hasCopyJobs() == other.hasCopyJobs() && Objects.equals(this.copyJobs(), other.copyJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCopyJobsResponse").add("CopyJobs", this.hasCopyJobs() ? this.copyJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyJobs": {
                return Optional.ofNullable(clazz.cast(this.copyJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCopyJobsResponse, T> g) {
        return obj -> g.apply((ListCopyJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<CopyJob> copyJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCopyJobsResponse model) {
            super(model);
            this.copyJobs(model.copyJobs);
            this.nextToken(model.nextToken);
        }

        public final List<CopyJob.Builder> getCopyJobs() {
            List<CopyJob.Builder> result = CopyJobsListCopier.copyToBuilder(this.copyJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCopyJobs(Collection<CopyJob.BuilderImpl> copyJobs) {
            this.copyJobs = CopyJobsListCopier.copyFromBuilder(copyJobs);
        }

        @Override
        public final Builder copyJobs(Collection<CopyJob> copyJobs) {
            this.copyJobs = CopyJobsListCopier.copy(copyJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobs(CopyJob ... copyJobs) {
            this.copyJobs(Arrays.asList(copyJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobs(Consumer<CopyJob.Builder> ... copyJobs) {
            this.copyJobs(Stream.of(copyJobs).map(c -> (CopyJob)((CopyJob.Builder)CopyJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCopyJobsResponse build() {
            return new ListCopyJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCopyJobsResponse> {
        public Builder copyJobs(Collection<CopyJob> var1);

        public Builder copyJobs(CopyJob ... var1);

        public Builder copyJobs(Consumer<CopyJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

