/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProtectedResourceResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeProtectedResourceResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::resourceArn)).setter(DescribeProtectedResourceResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::resourceType)).setter(DescribeProtectedResourceResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> LAST_BACKUP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastBackupTime").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::lastBackupTime)).setter(DescribeProtectedResourceResponse.setter(Builder::lastBackupTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupTime").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::resourceName)).setter(DescribeProtectedResourceResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> LAST_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastBackupVaultArn").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::lastBackupVaultArn)).setter(DescribeProtectedResourceResponse.setter(Builder::lastBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupVaultArn").build()}).build();
    private static final SdkField<String> LAST_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRecoveryPointArn").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::lastRecoveryPointArn)).setter(DescribeProtectedResourceResponse.setter(Builder::lastRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecoveryPointArn").build()}).build();
    private static final SdkField<Long> LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LatestRestoreExecutionTimeMinutes").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::latestRestoreExecutionTimeMinutes)).setter(DescribeProtectedResourceResponse.setter(Builder::latestRestoreExecutionTimeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestoreExecutionTimeMinutes").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORE_JOB_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestRestoreJobCreationDate").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::latestRestoreJobCreationDate)).setter(DescribeProtectedResourceResponse.setter(Builder::latestRestoreJobCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestoreJobCreationDate").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestRestoreRecoveryPointCreationDate").getter(DescribeProtectedResourceResponse.getter(DescribeProtectedResourceResponse::latestRestoreRecoveryPointCreationDate)).setter(DescribeProtectedResourceResponse.setter(Builder::latestRestoreRecoveryPointCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestoreRecoveryPointCreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, LAST_BACKUP_TIME_FIELD, RESOURCE_NAME_FIELD, LAST_BACKUP_VAULT_ARN_FIELD, LAST_RECOVERY_POINT_ARN_FIELD, LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD, LATEST_RESTORE_JOB_CREATION_DATE_FIELD, LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("LastBackupTime", LAST_BACKUP_TIME_FIELD);
            this.put("ResourceName", RESOURCE_NAME_FIELD);
            this.put("LastBackupVaultArn", LAST_BACKUP_VAULT_ARN_FIELD);
            this.put("LastRecoveryPointArn", LAST_RECOVERY_POINT_ARN_FIELD);
            this.put("LatestRestoreExecutionTimeMinutes", LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD);
            this.put("LatestRestoreJobCreationDate", LATEST_RESTORE_JOB_CREATION_DATE_FIELD);
            this.put("LatestRestoreRecoveryPointCreationDate", LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD);
        }
    });
    private final String resourceArn;
    private final String resourceType;
    private final Instant lastBackupTime;
    private final String resourceName;
    private final String lastBackupVaultArn;
    private final String lastRecoveryPointArn;
    private final Long latestRestoreExecutionTimeMinutes;
    private final Instant latestRestoreJobCreationDate;
    private final Instant latestRestoreRecoveryPointCreationDate;

    private DescribeProtectedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.lastBackupTime = builder.lastBackupTime;
        this.resourceName = builder.resourceName;
        this.lastBackupVaultArn = builder.lastBackupVaultArn;
        this.lastRecoveryPointArn = builder.lastRecoveryPointArn;
        this.latestRestoreExecutionTimeMinutes = builder.latestRestoreExecutionTimeMinutes;
        this.latestRestoreJobCreationDate = builder.latestRestoreJobCreationDate;
        this.latestRestoreRecoveryPointCreationDate = builder.latestRestoreRecoveryPointCreationDate;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant lastBackupTime() {
        return this.lastBackupTime;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String lastBackupVaultArn() {
        return this.lastBackupVaultArn;
    }

    public final String lastRecoveryPointArn() {
        return this.lastRecoveryPointArn;
    }

    public final Long latestRestoreExecutionTimeMinutes() {
        return this.latestRestoreExecutionTimeMinutes;
    }

    public final Instant latestRestoreJobCreationDate() {
        return this.latestRestoreJobCreationDate;
    }

    public final Instant latestRestoreRecoveryPointCreationDate() {
        return this.latestRestoreRecoveryPointCreationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBackupTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestoreExecutionTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestoreJobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestoreRecoveryPointCreationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectedResourceResponse)) {
            return false;
        }
        DescribeProtectedResourceResponse other = (DescribeProtectedResourceResponse)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.lastBackupTime(), other.lastBackupTime()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.lastBackupVaultArn(), other.lastBackupVaultArn()) && Objects.equals(this.lastRecoveryPointArn(), other.lastRecoveryPointArn()) && Objects.equals(this.latestRestoreExecutionTimeMinutes(), other.latestRestoreExecutionTimeMinutes()) && Objects.equals(this.latestRestoreJobCreationDate(), other.latestRestoreJobCreationDate()) && Objects.equals(this.latestRestoreRecoveryPointCreationDate(), other.latestRestoreRecoveryPointCreationDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProtectedResourceResponse").add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceType()).add("LastBackupTime", (Object)this.lastBackupTime()).add("ResourceName", (Object)this.resourceName()).add("LastBackupVaultArn", (Object)this.lastBackupVaultArn()).add("LastRecoveryPointArn", (Object)this.lastRecoveryPointArn()).add("LatestRestoreExecutionTimeMinutes", (Object)this.latestRestoreExecutionTimeMinutes()).add("LatestRestoreJobCreationDate", (Object)this.latestRestoreJobCreationDate()).add("LatestRestoreRecoveryPointCreationDate", (Object)this.latestRestoreRecoveryPointCreationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LastBackupTime": {
                return Optional.ofNullable(clazz.cast(this.lastBackupTime()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "LastBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.lastBackupVaultArn()));
            }
            case "LastRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.lastRecoveryPointArn()));
            }
            case "LatestRestoreExecutionTimeMinutes": {
                return Optional.ofNullable(clazz.cast(this.latestRestoreExecutionTimeMinutes()));
            }
            case "LatestRestoreJobCreationDate": {
                return Optional.ofNullable(clazz.cast(this.latestRestoreJobCreationDate()));
            }
            case "LatestRestoreRecoveryPointCreationDate": {
                return Optional.ofNullable(clazz.cast(this.latestRestoreRecoveryPointCreationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectedResourceResponse, T> g) {
        return obj -> g.apply((DescribeProtectedResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceType;
        private Instant lastBackupTime;
        private String resourceName;
        private String lastBackupVaultArn;
        private String lastRecoveryPointArn;
        private Long latestRestoreExecutionTimeMinutes;
        private Instant latestRestoreJobCreationDate;
        private Instant latestRestoreRecoveryPointCreationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectedResourceResponse model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.lastBackupTime(model.lastBackupTime);
            this.resourceName(model.resourceName);
            this.lastBackupVaultArn(model.lastBackupVaultArn);
            this.lastRecoveryPointArn(model.lastRecoveryPointArn);
            this.latestRestoreExecutionTimeMinutes(model.latestRestoreExecutionTimeMinutes);
            this.latestRestoreJobCreationDate(model.latestRestoreJobCreationDate);
            this.latestRestoreRecoveryPointCreationDate(model.latestRestoreRecoveryPointCreationDate);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getLastBackupTime() {
            return this.lastBackupTime;
        }

        public final void setLastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
        }

        @Override
        public final Builder lastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getLastBackupVaultArn() {
            return this.lastBackupVaultArn;
        }

        public final void setLastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
        }

        @Override
        public final Builder lastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
            return this;
        }

        public final String getLastRecoveryPointArn() {
            return this.lastRecoveryPointArn;
        }

        public final void setLastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
        }

        @Override
        public final Builder lastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
            return this;
        }

        public final Long getLatestRestoreExecutionTimeMinutes() {
            return this.latestRestoreExecutionTimeMinutes;
        }

        public final void setLatestRestoreExecutionTimeMinutes(Long latestRestoreExecutionTimeMinutes) {
            this.latestRestoreExecutionTimeMinutes = latestRestoreExecutionTimeMinutes;
        }

        @Override
        public final Builder latestRestoreExecutionTimeMinutes(Long latestRestoreExecutionTimeMinutes) {
            this.latestRestoreExecutionTimeMinutes = latestRestoreExecutionTimeMinutes;
            return this;
        }

        public final Instant getLatestRestoreJobCreationDate() {
            return this.latestRestoreJobCreationDate;
        }

        public final void setLatestRestoreJobCreationDate(Instant latestRestoreJobCreationDate) {
            this.latestRestoreJobCreationDate = latestRestoreJobCreationDate;
        }

        @Override
        public final Builder latestRestoreJobCreationDate(Instant latestRestoreJobCreationDate) {
            this.latestRestoreJobCreationDate = latestRestoreJobCreationDate;
            return this;
        }

        public final Instant getLatestRestoreRecoveryPointCreationDate() {
            return this.latestRestoreRecoveryPointCreationDate;
        }

        public final void setLatestRestoreRecoveryPointCreationDate(Instant latestRestoreRecoveryPointCreationDate) {
            this.latestRestoreRecoveryPointCreationDate = latestRestoreRecoveryPointCreationDate;
        }

        @Override
        public final Builder latestRestoreRecoveryPointCreationDate(Instant latestRestoreRecoveryPointCreationDate) {
            this.latestRestoreRecoveryPointCreationDate = latestRestoreRecoveryPointCreationDate;
            return this;
        }

        @Override
        public DescribeProtectedResourceResponse build() {
            return new DescribeProtectedResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProtectedResourceResponse> {
        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder lastBackupTime(Instant var1);

        public Builder resourceName(String var1);

        public Builder lastBackupVaultArn(String var1);

        public Builder lastRecoveryPointArn(String var1);

        public Builder latestRestoreExecutionTimeMinutes(Long var1);

        public Builder latestRestoreJobCreationDate(Instant var1);

        public Builder latestRestoreRecoveryPointCreationDate(Instant var1);
    }
}

