/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.ResourceTypeOptInPreferenceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegionSettingsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeRegionSettingsResponse> {
    private static final SdkField<Map<String, Boolean>> RESOURCE_TYPE_OPT_IN_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeRegionSettingsResponse.getter(DescribeRegionSettingsResponse::resourceTypeOptInPreference)).setter(DescribeRegionSettingsResponse.setter(Builder::resourceTypeOptInPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeOptInPreference").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_OPT_IN_PREFERENCE_FIELD));
    private final Map<String, Boolean> resourceTypeOptInPreference;

    private DescribeRegionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypeOptInPreference = builder.resourceTypeOptInPreference;
    }

    public boolean hasResourceTypeOptInPreference() {
        return this.resourceTypeOptInPreference != null && !(this.resourceTypeOptInPreference instanceof SdkAutoConstructMap);
    }

    public Map<String, Boolean> resourceTypeOptInPreference() {
        return this.resourceTypeOptInPreference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeOptInPreference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionSettingsResponse)) {
            return false;
        }
        DescribeRegionSettingsResponse other = (DescribeRegionSettingsResponse)((Object)obj);
        return Objects.equals(this.resourceTypeOptInPreference(), other.resourceTypeOptInPreference());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRegionSettingsResponse").add("ResourceTypeOptInPreference", this.resourceTypeOptInPreference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceTypeOptInPreference": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeOptInPreference()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegionSettingsResponse, T> g) {
        return obj -> g.apply((DescribeRegionSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private Map<String, Boolean> resourceTypeOptInPreference = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionSettingsResponse model) {
            super(model);
            this.resourceTypeOptInPreference(model.resourceTypeOptInPreference);
        }

        public final Map<String, Boolean> getResourceTypeOptInPreference() {
            return this.resourceTypeOptInPreference;
        }

        @Override
        public final Builder resourceTypeOptInPreference(Map<String, Boolean> resourceTypeOptInPreference) {
            this.resourceTypeOptInPreference = ResourceTypeOptInPreferenceCopier.copy(resourceTypeOptInPreference);
            return this;
        }

        public final void setResourceTypeOptInPreference(Map<String, Boolean> resourceTypeOptInPreference) {
            this.resourceTypeOptInPreference = ResourceTypeOptInPreferenceCopier.copy(resourceTypeOptInPreference);
        }

        @Override
        public DescribeRegionSettingsResponse build() {
            return new DescribeRegionSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegionSettingsResponse> {
        public Builder resourceTypeOptInPreference(Map<String, Boolean> var1);
    }
}

