/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.CopyJobState;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyJob> {
    private static final SdkField<String> COPY_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::copyJobId)).setter(CopyJob.setter(Builder::copyJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobId").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::sourceBackupVaultArn)).setter(CopyJob.setter(Builder::sourceBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build()}).build();
    private static final SdkField<String> SOURCE_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::sourceRecoveryPointArn)).setter(CopyJob.setter(Builder::sourceRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRecoveryPointArn").build()}).build();
    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::destinationBackupVaultArn)).setter(CopyJob.setter(Builder::destinationBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build()}).build();
    private static final SdkField<String> DESTINATION_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::destinationRecoveryPointArn)).setter(CopyJob.setter(Builder::destinationRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::resourceArn)).setter(CopyJob.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CopyJob.getter(CopyJob::creationDate)).setter(CopyJob.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CopyJob.getter(CopyJob::completionDate)).setter(CopyJob.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::stateAsString)).setter(CopyJob.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::statusMessage)).setter(CopyJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CopyJob.getter(CopyJob::backupSizeInBytes)).setter(CopyJob.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::iamRoleArn)).setter(CopyJob.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CopyJob.getter(CopyJob::createdBy)).setter(CopyJob.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CopyJob.getter(CopyJob::resourceType)).setter(CopyJob.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_ID_FIELD, SOURCE_BACKUP_VAULT_ARN_FIELD, SOURCE_RECOVERY_POINT_ARN_FIELD, DESTINATION_BACKUP_VAULT_ARN_FIELD, DESTINATION_RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, CREATED_BY_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String copyJobId;
    private final String sourceBackupVaultArn;
    private final String sourceRecoveryPointArn;
    private final String destinationBackupVaultArn;
    private final String destinationRecoveryPointArn;
    private final String resourceArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String state;
    private final String statusMessage;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final RecoveryPointCreator createdBy;
    private final String resourceType;

    private CopyJob(BuilderImpl builder) {
        this.copyJobId = builder.copyJobId;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.sourceRecoveryPointArn = builder.sourceRecoveryPointArn;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.destinationRecoveryPointArn = builder.destinationRecoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.createdBy = builder.createdBy;
        this.resourceType = builder.resourceType;
    }

    public String copyJobId() {
        return this.copyJobId;
    }

    public String sourceBackupVaultArn() {
        return this.sourceBackupVaultArn;
    }

    public String sourceRecoveryPointArn() {
        return this.sourceRecoveryPointArn;
    }

    public String destinationBackupVaultArn() {
        return this.destinationBackupVaultArn;
    }

    public String destinationRecoveryPointArn() {
        return this.destinationRecoveryPointArn;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant completionDate() {
        return this.completionDate;
    }

    public CopyJobState state() {
        return CopyJobState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.copyJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJob)) {
            return false;
        }
        CopyJob other = (CopyJob)obj;
        return Objects.equals(this.copyJobId(), other.copyJobId()) && Objects.equals(this.sourceBackupVaultArn(), other.sourceBackupVaultArn()) && Objects.equals(this.sourceRecoveryPointArn(), other.sourceRecoveryPointArn()) && Objects.equals(this.destinationBackupVaultArn(), other.destinationBackupVaultArn()) && Objects.equals(this.destinationRecoveryPointArn(), other.destinationRecoveryPointArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public String toString() {
        return ToString.builder((String)"CopyJob").add("CopyJobId", (Object)this.copyJobId()).add("SourceBackupVaultArn", (Object)this.sourceBackupVaultArn()).add("SourceRecoveryPointArn", (Object)this.sourceRecoveryPointArn()).add("DestinationBackupVaultArn", (Object)this.destinationBackupVaultArn()).add("DestinationRecoveryPointArn", (Object)this.destinationRecoveryPointArn()).add("ResourceArn", (Object)this.resourceArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("CreatedBy", (Object)this.createdBy()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyJobId": {
                return Optional.ofNullable(clazz.cast(this.copyJobId()));
            }
            case "SourceBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupVaultArn()));
            }
            case "SourceRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceRecoveryPointArn()));
            }
            case "DestinationBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.destinationBackupVaultArn()));
            }
            case "DestinationRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.destinationRecoveryPointArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyJob, T> g) {
        return obj -> g.apply((CopyJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String copyJobId;
        private String sourceBackupVaultArn;
        private String sourceRecoveryPointArn;
        private String destinationBackupVaultArn;
        private String destinationRecoveryPointArn;
        private String resourceArn;
        private Instant creationDate;
        private Instant completionDate;
        private String state;
        private String statusMessage;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private RecoveryPointCreator createdBy;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJob model) {
            this.copyJobId(model.copyJobId);
            this.sourceBackupVaultArn(model.sourceBackupVaultArn);
            this.sourceRecoveryPointArn(model.sourceRecoveryPointArn);
            this.destinationBackupVaultArn(model.destinationBackupVaultArn);
            this.destinationRecoveryPointArn(model.destinationRecoveryPointArn);
            this.resourceArn(model.resourceArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.createdBy(model.createdBy);
            this.resourceType(model.resourceType);
        }

        public final String getCopyJobId() {
            return this.copyJobId;
        }

        @Override
        public final Builder copyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
            return this;
        }

        public final void setCopyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
        }

        public final String getSourceBackupVaultArn() {
            return this.sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        public final String getSourceRecoveryPointArn() {
            return this.sourceRecoveryPointArn;
        }

        @Override
        public final Builder sourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
            return this;
        }

        public final void setSourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
        }

        public final String getDestinationBackupVaultArn() {
            return this.destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        public final String getDestinationRecoveryPointArn() {
            return this.destinationRecoveryPointArn;
        }

        @Override
        public final Builder destinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
            return this;
        }

        public final void setDestinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CopyJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public CopyJob build() {
            return new CopyJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyJob> {
        public Builder copyJobId(String var1);

        public Builder sourceBackupVaultArn(String var1);

        public Builder sourceRecoveryPointArn(String var1);

        public Builder destinationBackupVaultArn(String var1);

        public Builder destinationRecoveryPointArn(String var1);

        public Builder resourceArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder state(String var1);

        public Builder state(CopyJobState var1);

        public Builder statusMessage(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder resourceType(String var1);
    }
}

