/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryType {
    RESOURCE_GROUP_BASED("RESOURCE_GROUP_BASED"),
    ACCOUNT_BASED("ACCOUNT_BASED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryType> VALUE_MAP;
    private final String value;

    private DiscoveryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryType> knownValues() {
        EnumSet<DiscoveryType> knownValues = EnumSet.allOf(DiscoveryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryType.class, DiscoveryType::toString);
    }
}

