/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appfabric.model.AppFabricRequest;
import software.amazon.awssdk.services.appfabric.model.DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIngestionDestinationRequest
extends AppFabricRequest
implements ToCopyableBuilder<Builder, UpdateIngestionDestinationRequest> {
    private static final SdkField<String> APP_BUNDLE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appBundleIdentifier").getter(UpdateIngestionDestinationRequest.getter(UpdateIngestionDestinationRequest::appBundleIdentifier)).setter(UpdateIngestionDestinationRequest.setter(Builder::appBundleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appBundleIdentifier").build()}).build();
    private static final SdkField<String> INGESTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionIdentifier").getter(UpdateIngestionDestinationRequest.getter(UpdateIngestionDestinationRequest::ingestionIdentifier)).setter(UpdateIngestionDestinationRequest.setter(Builder::ingestionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionIdentifier").build()}).build();
    private static final SdkField<String> INGESTION_DESTINATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionDestinationIdentifier").getter(UpdateIngestionDestinationRequest.getter(UpdateIngestionDestinationRequest::ingestionDestinationIdentifier)).setter(UpdateIngestionDestinationRequest.setter(Builder::ingestionDestinationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionDestinationIdentifier").build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfiguration").getter(UpdateIngestionDestinationRequest.getter(UpdateIngestionDestinationRequest::destinationConfiguration)).setter(UpdateIngestionDestinationRequest.setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BUNDLE_IDENTIFIER_FIELD, INGESTION_IDENTIFIER_FIELD, INGESTION_DESTINATION_IDENTIFIER_FIELD, DESTINATION_CONFIGURATION_FIELD));
    private final String appBundleIdentifier;
    private final String ingestionIdentifier;
    private final String ingestionDestinationIdentifier;
    private final DestinationConfiguration destinationConfiguration;

    private UpdateIngestionDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.appBundleIdentifier = builder.appBundleIdentifier;
        this.ingestionIdentifier = builder.ingestionIdentifier;
        this.ingestionDestinationIdentifier = builder.ingestionDestinationIdentifier;
        this.destinationConfiguration = builder.destinationConfiguration;
    }

    public final String appBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public final String ingestionIdentifier() {
        return this.ingestionIdentifier;
    }

    public final String ingestionDestinationIdentifier() {
        return this.ingestionDestinationIdentifier;
    }

    public final DestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBundleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionDestinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIngestionDestinationRequest)) {
            return false;
        }
        UpdateIngestionDestinationRequest other = (UpdateIngestionDestinationRequest)((Object)obj);
        return Objects.equals(this.appBundleIdentifier(), other.appBundleIdentifier()) && Objects.equals(this.ingestionIdentifier(), other.ingestionIdentifier()) && Objects.equals(this.ingestionDestinationIdentifier(), other.ingestionDestinationIdentifier()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIngestionDestinationRequest").add("AppBundleIdentifier", (Object)this.appBundleIdentifier()).add("IngestionIdentifier", (Object)this.ingestionIdentifier()).add("IngestionDestinationIdentifier", (Object)this.ingestionDestinationIdentifier()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appBundleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.appBundleIdentifier()));
            }
            case "ingestionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ingestionIdentifier()));
            }
            case "ingestionDestinationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ingestionDestinationIdentifier()));
            }
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIngestionDestinationRequest, T> g) {
        return obj -> g.apply((UpdateIngestionDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppFabricRequest.BuilderImpl
    implements Builder {
        private String appBundleIdentifier;
        private String ingestionIdentifier;
        private String ingestionDestinationIdentifier;
        private DestinationConfiguration destinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIngestionDestinationRequest model) {
            super(model);
            this.appBundleIdentifier(model.appBundleIdentifier);
            this.ingestionIdentifier(model.ingestionIdentifier);
            this.ingestionDestinationIdentifier(model.ingestionDestinationIdentifier);
            this.destinationConfiguration(model.destinationConfiguration);
        }

        public final String getAppBundleIdentifier() {
            return this.appBundleIdentifier;
        }

        public final void setAppBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
        }

        @Override
        public final Builder appBundleIdentifier(String appBundleIdentifier) {
            this.appBundleIdentifier = appBundleIdentifier;
            return this;
        }

        public final String getIngestionIdentifier() {
            return this.ingestionIdentifier;
        }

        public final void setIngestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
        }

        @Override
        public final Builder ingestionIdentifier(String ingestionIdentifier) {
            this.ingestionIdentifier = ingestionIdentifier;
            return this;
        }

        public final String getIngestionDestinationIdentifier() {
            return this.ingestionDestinationIdentifier;
        }

        public final void setIngestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
        }

        @Override
        public final Builder ingestionDestinationIdentifier(String ingestionDestinationIdentifier) {
            this.ingestionDestinationIdentifier = ingestionDestinationIdentifier;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIngestionDestinationRequest build() {
            return new UpdateIngestionDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIngestionDestinationRequest> {
        public Builder appBundleIdentifier(String var1);

        public Builder ingestionIdentifier(String var1);

        public Builder ingestionDestinationIdentifier(String var1);

        public Builder destinationConfiguration(DestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

