/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.git;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.git.GitRepo;
import ru.yoomoney.gradle.plugins.release.git.GitRepoFactory;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\fJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitManager;", "Ljava/io/Closeable;", "projectDirectory", "Ljava/io/File;", "gitSettings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "(Ljava/io/File;Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "git", "Lru/yoomoney/gradle/plugins/release/git/GitRepo;", "addTag", "", "tag", "", "checkPush", "", "close", "commit", "message", "getCommitsFromLastTagToHead", "", "Lorg/eclipse/jgit/revwalk/RevCommit;", "getRemoteOriginUrl", "getUncommittedChanges", "", "isTagExists", "version", "newVersionCommit", "nextVersion", "preTagCommit", "push", "Companion", "artifact-release-plugin"})
public final class GitManager
implements Closeable {
    private final GitRepo git;
    private final File projectDirectory;
    private static final Logger log;
    private static final String NEW_VERSION_RELEASE_PREFIX = "[Gradle Release Plugin] - new version commit";
    private static final String PRE_TAG_COMMIT_PREFIX = "[Gradle Release Plugin] - pre tag commit";
    public static final Companion Companion;

    private final void commit(String message) {
        log.lifecycle("Commit: " + message);
        this.git.commit().setAll(true).setMessage(message).call();
    }

    private final void addTag(String tag) {
        log.lifecycle("Tag : " + tag);
        this.git.tag().setName(tag).call();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTagExists(@NotNull String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        List list = this.git.getRepository().getRefDatabase().getRefsByPrefix("refs/tags/");
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"git.repository.refDataba\u2026yPrefix(Constants.R_TAGS)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ref it = (Ref)element$iv$iv;
            boolean bl = false;
            Ref ref = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"it");
            if (!Intrinsics.areEqual((Object)ref.getName(), (Object)("refs/tags/" + version))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tag = (List)destination$iv$iv;
        return !tag.isEmpty();
    }

    public final void push() {
        this.git.push((Function1<? super PushCommand, Unit>)((Function1)new Function1<PushCommand, Unit>(this){
            final /* synthetic */ GitManager this$0;

            public final void invoke(@NotNull PushCommand pushCommand) {
                Intrinsics.checkParameterIsNotNull((Object)pushCommand, (String)"pushCommand");
                pushCommand.setPushTags().add(GitManager.access$getGit$p(this.this$0).getRepository().getFullBranch()).setRemote("origin");
            }
            {
                this.this$0 = gitManager;
                super(1);
            }
        }));
    }

    public final boolean checkPush() {
        this.git.commit().setMessage("[Gradle Release Plugin] Check push").setAllowEmpty(true).call();
        String resultMessage2 = this.git.push((Function1<? super PushCommand, Unit>)((Function1)new Function1<PushCommand, Unit>(this){
            final /* synthetic */ GitManager this$0;

            public final void invoke(@NotNull PushCommand pushCommand) {
                Intrinsics.checkParameterIsNotNull((Object)pushCommand, (String)"pushCommand");
                pushCommand.add(GitManager.access$getGit$p(this.this$0).getRepository().getFullBranch()).setRemote("origin");
            }
            {
                this.this$0 = gitManager;
                super(1);
            }
        }));
        return resultMessage2 == null;
    }

    @NotNull
    public final Set<String> getUncommittedChanges() {
        Status status;
        Status status2 = status = this.git.status().call();
        Intrinsics.checkExpressionValueIsNotNull((Object)status2, (String)"status");
        Set set = status2.getUncommittedChanges();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"status.uncommittedChanges");
        return set;
    }

    public final void preTagCommit(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Status status = this.git.status().call();
        Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"git.status().call()");
        Set newFiles = status.getUntracked();
        if (!newFiles.isEmpty()) {
            AddCommand add = this.git.add();
            log.lifecycle("Add new files for preTagCommit: files={}", new Object[]{newFiles});
            Set set = newFiles;
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"newFiles");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                add.addFilepattern(it);
            }
            add.call();
        }
        this.commit("[Gradle Release Plugin] - pre tag commit: '" + version + "'.");
        this.addTag(version);
    }

    public final void newVersionCommit(@NotNull String nextVersion) {
        Intrinsics.checkParameterIsNotNull((Object)nextVersion, (String)"nextVersion");
        this.commit("[Gradle Release Plugin] - new version commit: '" + nextVersion + "'.");
    }

    @NotNull
    public final String getRemoteOriginUrl() {
        return this.git.getRemoteOriginUrl();
    }

    @NotNull
    public final Iterable<RevCommit> getCommitsFromLastTagToHead() {
        Iterable iterable;
        List<Ref> tags = this.git.listTags();
        if (tags.isEmpty()) {
            Iterable iterable2 = this.git.log().add((AnyObjectId)this.git.getHeadCommit()).call();
            iterable = iterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"git.log().add(git.headCommit).call()");
        } else {
            RevCommit lastTaggedCommit = this.git.getRepository().parseCommit((AnyObjectId)((Ref)CollectionsKt.last(tags)).getObjectId());
            Iterable iterable3 = this.git.log().addRange((AnyObjectId)lastTaggedCommit, (AnyObjectId)this.git.getHeadCommit()).call();
            iterable = iterable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable3, (String)"git.log().addRange(lastT\u2026t, git.headCommit).call()");
        }
        return iterable;
    }

    @Override
    public void close() {
        this.git.close();
    }

    public GitManager(@NotNull File projectDirectory, @NotNull GitSettings gitSettings) {
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)gitSettings, (String)"gitSettings");
        this.projectDirectory = projectDirectory;
        this.git = new GitRepoFactory(gitSettings).createFromExistingDirectory(this.projectDirectory);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(GitManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(GitManager::class.java)");
        log = logger;
    }

    public static final /* synthetic */ GitRepo access$getGit$p(GitManager $this) {
        return $this.git;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitManager$Companion;", "", "()V", "NEW_VERSION_RELEASE_PREFIX", "", "PRE_TAG_COMMIT_PREFIX", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

