/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.changelog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import ru.yoomoney.gradle.plugins.release.PullRequestInfoProvider;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketClient;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketConnectionSettings;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestCommit;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestLink;
import ru.yoomoney.gradle.plugins.release.bitbucket.PullRequestState;
import ru.yoomoney.gradle.plugins.release.changelog.PullRequestLinkProvider;
import ru.yoomoney.gradle.plugins.release.changelog.PullRequestLinkProvider$WhenMappings;
import ru.yoomoney.gradle.plugins.release.git.GitManager;
import ru.yoomoney.gradle.plugins.release.github.GitHubClient;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u0004\u0018\u00010\fJ\b\u0010\u000e\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider;", "", "gitManager", "Lru/yoomoney/gradle/plugins/release/git/GitManager;", "pullRequestLinkSettings", "Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "(Lru/yoomoney/gradle/plugins/release/git/GitManager;Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "gitHubClient", "Lru/yoomoney/gradle/plugins/release/github/GitHubClient;", "settings", "(Lru/yoomoney/gradle/plugins/release/git/GitManager;Lru/yoomoney/gradle/plugins/release/github/GitHubClient;Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "getReleasePullRequestLink", "", "getReleasePullRequestLinkFromBitbucket", "getReleasePullRequestLinkFromGitHub", "isPullRequestValid", "", "commitsId", "", "parseArtifactLocation", "Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$ArtifactLocation;", "path", "parseHttpArtifactLocation", "url", "Ljava/net/URI;", "parseSshArtifactLocation", "ArtifactLocation", "Companion", "artifact-release-plugin"})
public final class PullRequestLinkProvider {
    private final GitManager gitManager;
    private final GitHubClient gitHubClient;
    private final PullRequestLinkSettings settings;
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    public final String getReleasePullRequestLink() {
        switch (PullRequestLinkProvider$WhenMappings.$EnumSwitchMapping$0[this.settings.getPullRequestInfoProvider().ordinal()]) {
            case 1: {
                return this.getReleasePullRequestLinkFromGitHub();
            }
            case 2: {
                return this.getReleasePullRequestLinkFromBitbucket();
            }
        }
        return null;
    }

    @Nullable
    public final String getReleasePullRequestLinkFromBitbucket() {
        try {
            ArtifactLocation artifactLocation = this.parseArtifactLocation(this.gitManager.getRemoteOriginUrl());
            String string = this.settings.getBitbucketUser();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("bitbucketUser is absent");
            }
            String string2 = this.settings.getBitbucketPassword();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("bitbucketPassword is absent");
            }
            BitbucketClient bitbucketClient = new BitbucketClient(BitbucketConnectionSettings.Companion.builder().withUri(URI.create(artifactLocation.getHost())).withUser(string).withPassword(string2).build());
            return bitbucketClient.getLatestPullRequestLink(artifactLocation.getProject(), artifactLocation.getRepository(), PullRequestState.MERGED).filter(new Predicate<BitbucketPullRequestLink>(this, bitbucketClient, artifactLocation){
                final /* synthetic */ PullRequestLinkProvider this$0;
                final /* synthetic */ BitbucketClient $bitbucketClient;
                final /* synthetic */ ArtifactLocation $artifactLocation;

                /*
                 * WARNING - void declaration
                 */
                public final boolean test(BitbucketPullRequestLink it) {
                    void $this$mapTo$iv$iv;
                    String string = this.$artifactLocation.getProject();
                    String string2 = this.$artifactLocation.getRepository();
                    Long l = it.getPullRequestId();
                    if (l == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable $this$map$iv = this.$bitbucketClient.getPullRequestCommits(string, string2, l);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        String string3;
                        void it2;
                        BitbucketPullRequestCommit bitbucketPullRequestCommit = (BitbucketPullRequestCommit)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if (it2.getId() == null) {
                            Intrinsics.throwNpe();
                        }
                        collection.add(string3);
                    }
                    List bitbucketPullRequestCommitMessages = (List)destination$iv$iv;
                    return PullRequestLinkProvider.access$isPullRequestValid(this.this$0, bitbucketPullRequestCommitMessages);
                }
                {
                    this.this$0 = pullRequestLinkProvider;
                    this.$bitbucketClient = bitbucketClient;
                    this.$artifactLocation = artifactLocation;
                }
            }).map(getReleasePullRequestLinkFromBitbucket.2.INSTANCE).orElse(null);
        }
        catch (Exception e) {
            log.warn("can't getPullRequestLink", (Throwable)e);
            Object var1_2 = null;
            return var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getReleasePullRequestLinkFromGitHub() {
        try {
            void $this$mapTo$iv$iv;
            ArtifactLocation location = this.parseArtifactLocation(this.gitManager.getRemoteOriginUrl());
            GHPullRequest gHPullRequest = this.gitHubClient.getLatestPullRequest(location.getProject(), location.getRepository(), GHIssueState.CLOSED);
            if (gHPullRequest == null) {
                return null;
            }
            GHPullRequest latestPullRequest = gHPullRequest;
            List list = latestPullRequest.listCommits().toList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"latestPullRequest\n      \u2026  .listCommits().toList()");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GHPullRequestCommitDetail gHPullRequestCommitDetail = (GHPullRequestCommitDetail)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                String string = v2.getSha();
                collection.add(string);
            }
            List githubPullRequestCommitMessages = (List)destination$iv$iv;
            if (!this.isPullRequestValid(githubPullRequestCommitMessages)) {
                return null;
            }
            return latestPullRequest.getHtmlUrl().toString();
        }
        catch (Exception e) {
            log.warn("can't getPullRequestLink", (Throwable)e);
            Object var1_2 = null;
            return var1_2;
        }
    }

    private final ArtifactLocation parseArtifactLocation(String path) {
        ArtifactLocation artifactLocation = null;
        artifactLocation = StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null) ? this.parseHttpArtifactLocation(new URI(path)) : this.parseSshArtifactLocation(path);
        log.info("Got artifact location for pull-request's link: artifactLocation{}", (Object)artifactLocation);
        return artifactLocation;
    }

    private final ArtifactLocation parseHttpArtifactLocation(URI url) {
        String string = url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
        List pathFragments = StringsKt.split$default((CharSequence)string, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        String string2 = url.getScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.scheme");
        String scheme = StringsKt.startsWith$default((String)string2, (String)"http", (boolean)false, (int)2, null) ? url.getScheme() + "://" : "";
        return new ArtifactLocation(scheme + url.getHost() + ':' + url.getPort(), (String)pathFragments.get(1), StringsKt.removeSuffix((String)((String)pathFragments.get(2)), (CharSequence)".git"));
    }

    private final ArtifactLocation parseSshArtifactLocation(String path) {
        String pathWithousScheme = (String)StringsKt.split$default((CharSequence)path, (String[])new String[]{"git@"}, (boolean)false, (int)0, (int)6, null).get(1);
        List pathFragments = StringsKt.split$default((CharSequence)pathWithousScheme, (String[])new String[]{"/", ":"}, (boolean)false, (int)0, (int)6, null);
        return new ArtifactLocation("https://" + (String)pathFragments.get(0), (String)pathFragments.get(1), StringsKt.removeSuffix((String)((String)pathFragments.get(2)), (CharSequence)".git"));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPullRequestValid(List<String> commitsId) {
        boolean bl;
        String string;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.gitManager.getCommitsFromLastTagToHead();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RevCommit revCommit = (RevCommit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            string = it.toObjectId().name();
            collection.add(string);
        }
        List gitCommitMessagesFromLastTag = (List)destination$iv$iv;
        if (gitCommitMessagesFromLastTag.containsAll((Collection)commitsId)) {
            bl = true;
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            $this$map$iv = commitsId;
            string = "unknown pull request commits: messages={}";
            collection = log;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!gitCommitMessagesFromLastTag.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            collection.warn(string, list);
            bl = false;
        }
        return bl;
    }

    public PullRequestLinkProvider(@NotNull GitManager gitManager, @NotNull GitHubClient gitHubClient, @NotNull PullRequestLinkSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)gitManager, (String)"gitManager");
        Intrinsics.checkParameterIsNotNull((Object)gitHubClient, (String)"gitHubClient");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.gitManager = gitManager;
        this.gitHubClient = gitHubClient;
        this.settings = settings;
    }

    public PullRequestLinkProvider(@NotNull GitManager gitManager, @NotNull PullRequestLinkSettings pullRequestLinkSettings) {
        Intrinsics.checkParameterIsNotNull((Object)gitManager, (String)"gitManager");
        Intrinsics.checkParameterIsNotNull((Object)pullRequestLinkSettings, (String)"pullRequestLinkSettings");
        this(gitManager, new GitHubClient(pullRequestLinkSettings), pullRequestLinkSettings);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(PullRequestInfoProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(PullRe\u2026InfoProvider::class.java)");
        log = logger;
    }

    public static final /* synthetic */ boolean access$isPullRequestValid(PullRequestLinkProvider $this, List commitsId) {
        return $this.isPullRequestValid(commitsId);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$ArtifactLocation;", "", "host", "", "project", "repository", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getProject", "getRepository", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "artifact-release-plugin"})
    private static final class ArtifactLocation {
        @NotNull
        private final String host;
        @NotNull
        private final String project;
        @NotNull
        private final String repository;

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getProject() {
            return this.project;
        }

        @NotNull
        public final String getRepository() {
            return this.repository;
        }

        public ArtifactLocation(@NotNull String host, @NotNull String project, @NotNull String repository) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            this.host = host;
            this.project = project;
            this.repository = repository;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final String component2() {
            return this.project;
        }

        @NotNull
        public final String component3() {
            return this.repository;
        }

        @NotNull
        public final ArtifactLocation copy(@NotNull String host, @NotNull String project, @NotNull String repository) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            return new ArtifactLocation(host, project, repository);
        }

        public static /* synthetic */ ArtifactLocation copy$default(ArtifactLocation artifactLocation, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactLocation.host;
            }
            if ((n & 2) != 0) {
                string2 = artifactLocation.project;
            }
            if ((n & 4) != 0) {
                string3 = artifactLocation.repository;
            }
            return artifactLocation.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ArtifactLocation(host=" + this.host + ", project=" + this.project + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            String string = this.host;
            String string2 = this.project;
            String string3 = this.repository;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArtifactLocation)) break block3;
                    ArtifactLocation artifactLocation = (ArtifactLocation)object;
                    if (!Intrinsics.areEqual((Object)this.host, (Object)artifactLocation.host) || !Intrinsics.areEqual((Object)this.project, (Object)artifactLocation.project) || !Intrinsics.areEqual((Object)this.repository, (Object)artifactLocation.repository)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

