/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.changelog.ChangelogManager;
import ru.yoomoney.gradle.plugins.release.changelog.PullRequestLinkProvider;
import ru.yoomoney.gradle.plugins.release.git.GitManager;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;
import ru.yoomoney.gradle.plugins.release.version.GradlePropertyVersionManager;
import ru.yoomoney.gradle.plugins.release.version.ReleaseInfoStorage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lru/yoomoney/gradle/plugins/release/PreReleaseRotateVersionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "gitSettings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "getGitSettings", "()Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "setGitSettings", "(Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "pullRequestLinkSettings", "Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "getPullRequestLinkSettings", "()Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "setPullRequestLinkSettings", "(Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "preReleaseByChangelog", "", "changelog", "Ljava/io/File;", "gradlePropertyVersionManager", "Lru/yoomoney/gradle/plugins/release/version/GradlePropertyVersionManager;", "releaseInfoStorage", "Lru/yoomoney/gradle/plugins/release/version/ReleaseInfoStorage;", "gitManager", "Lru/yoomoney/gradle/plugins/release/git/GitManager;", "rotateVersion", "", "Companion", "artifact-release-plugin"})
public class PreReleaseRotateVersionTask
extends DefaultTask {
    @NotNull
    public GitSettings gitSettings;
    @NotNull
    public PullRequestLinkSettings pullRequestLinkSettings;
    private static final Logger log;
    public static final Companion Companion;

    @Input
    @NotNull
    public final GitSettings getGitSettings() {
        GitSettings gitSettings = this.gitSettings;
        if (gitSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitSettings");
        }
        return gitSettings;
    }

    public final void setGitSettings(@NotNull GitSettings gitSettings) {
        Intrinsics.checkParameterIsNotNull((Object)gitSettings, (String)"<set-?>");
        this.gitSettings = gitSettings;
    }

    @Input
    @NotNull
    public final PullRequestLinkSettings getPullRequestLinkSettings() {
        PullRequestLinkSettings pullRequestLinkSettings = this.pullRequestLinkSettings;
        if (pullRequestLinkSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pullRequestLinkSettings");
        }
        return pullRequestLinkSettings;
    }

    public final void setPullRequestLinkSettings(@NotNull PullRequestLinkSettings pullRequestLinkSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pullRequestLinkSettings, (String)"<set-?>");
        this.pullRequestLinkSettings = pullRequestLinkSettings;
    }

    private final String preReleaseByChangelog(File changelog, GradlePropertyVersionManager gradlePropertyVersionManager, ReleaseInfoStorage releaseInfoStorage, GitManager gitManager) {
        String string;
        ChangelogManager changelogManager = new ChangelogManager(changelog);
        PullRequestLinkSettings pullRequestLinkSettings = this.pullRequestLinkSettings;
        if (pullRequestLinkSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pullRequestLinkSettings");
        }
        if (pullRequestLinkSettings.getPullRequestLinkInChangelogEnabled()) {
            PullRequestLinkSettings pullRequestLinkSettings2 = this.pullRequestLinkSettings;
            if (pullRequestLinkSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pullRequestLinkSettings");
            }
            string = new PullRequestLinkProvider(gitManager, pullRequestLinkSettings2).getReleasePullRequestLink();
        } else {
            string = null;
        }
        String githubPullRequestLink = string;
        ChangelogManager.ChangelogReleaseInfo nextVersion = changelogManager.updateToNextVersion(githubPullRequestLink);
        gradlePropertyVersionManager.updateVersion(nextVersion.getReleaseVersion());
        releaseInfoStorage.storeChangelog(nextVersion.getReleaseDescriptionMd());
        return nextVersion.getReleaseVersion();
    }

    @TaskAction
    public final void rotateVersion() {
        String string;
        GitManager gitManager;
        Set<String> uncommittedChanges;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootDir");
        GitSettings gitSettings = this.gitSettings;
        if (gitSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitSettings");
        }
        if (!(uncommittedChanges = (gitManager = new GitManager(file, gitSettings)).getUncommittedChanges()).isEmpty()) {
            throw (Throwable)new GradleException("There are uncommitted changes \n" + CollectionsKt.joinToString$default((Iterable)uncommittedChanges, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        Object[] objectArray = new Object[1];
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        objectArray[0] = project2.getVersion();
        log.lifecycle("Start pre release: currentVersion = {}", objectArray);
        File file2 = this.getProject().file((Object)"gradle.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.file(GradlePrope\u2026anager.DEFAULT_FILE_NAME)");
        GradlePropertyVersionManager projectVersionManager = new GradlePropertyVersionManager(file2);
        File changelogFile = this.getProject().file((Object)"CHANGELOG.md");
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        File file3 = project3.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.buildDir");
        ReleaseInfoStorage releaseInfoStorage = new ReleaseInfoStorage(file3);
        if (changelogFile.exists()) {
            File file4 = changelogFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"changelogFile");
            string = this.preReleaseByChangelog(file4, projectVersionManager, releaseInfoStorage, gitManager);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Changelog rotate skip, ");
            File file5 = changelogFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"changelogFile");
            log.lifecycle(stringBuilder.append(file5.getName()).append(" not found").toString());
            string = projectVersionManager.removeSnapshotFromVersion();
        }
        String releaseVersion = string;
        log.lifecycle("Update " + projectVersionManager.getGradleProperty().getName() + ": releaseVersion={}", new Object[]{releaseVersion});
        releaseInfoStorage.storeVersion(releaseVersion);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(PreReleaseRotateVersionTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(PreRel\u2026eVersionTask::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/release/PreReleaseRotateVersionTask$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

