/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release;

import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.changelog.ChangelogManager;
import ru.yoomoney.gradle.plugins.release.git.GitManager;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;
import ru.yoomoney.gradle.plugins.release.version.GradlePropertyVersionManager;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lru/yoomoney/gradle/plugins/release/PostReleaseTask;", "Lorg/gradle/api/DefaultTask;", "()V", "gitSettings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "getGitSettings", "()Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "setGitSettings", "(Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "doAction", "", "artifact-release-plugin"})
public class PostReleaseTask
extends DefaultTask {
    @NotNull
    public GitSettings gitSettings;

    @Input
    @NotNull
    public final GitSettings getGitSettings() {
        GitSettings gitSettings = this.gitSettings;
        if (gitSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitSettings");
        }
        return gitSettings;
    }

    public final void setGitSettings(@NotNull GitSettings gitSettings) {
        Intrinsics.checkParameterIsNotNull((Object)gitSettings, (String)"<set-?>");
        this.gitSettings = gitSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void doAction() {
        File file = this.getProject().file((Object)"gradle.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(GradlePrope\u2026anager.DEFAULT_FILE_NAME)");
        GradlePropertyVersionManager gradlePropertyVersionManager = new GradlePropertyVersionManager(file);
        gradlePropertyVersionManager.incrementPatchVersion();
        String nextVersion = gradlePropertyVersionManager.appendSnapshotToVersion();
        File changelogFile = this.getProject().file((Object)"CHANGELOG.md");
        if (changelogFile.exists()) {
            File file2 = changelogFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"changelogFile");
            new ChangelogManager(file2).appendNextVersionDescriptionMarkers();
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file3 = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.rootDir");
        GitSettings gitSettings = this.gitSettings;
        if (gitSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gitSettings");
        }
        Closeable closeable = new GitManager(file3, gitSettings);
        boolean bl = false;
        Throwable throwable = null;
        try {
            GitManager it = (GitManager)closeable;
            boolean bl2 = false;
            it.newVersionCommit(nextVersion);
            it.push();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

