/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter.example;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Calendar;
import java.util.Date;
import pl.rafman.scrollcalendar.CalendarProvider;
import pl.rafman.scrollcalendar.adapter.ScrollCalendarAdapter;
import pl.rafman.scrollcalendar.style.DayResProvider;
import pl.rafman.scrollcalendar.style.MonthResProvider;

public class DefaultDateScrollCalendarAdapter
extends ScrollCalendarAdapter {
    @Nullable
    private Calendar selected;
    protected CalendarProvider calendarProvider;

    public DefaultDateScrollCalendarAdapter(@NonNull MonthResProvider monthResProvider, @NonNull DayResProvider dayResProvider, CalendarProvider calendarProvider) {
        super(monthResProvider, dayResProvider, calendarProvider);
        this.calendarProvider = calendarProvider;
    }

    @Override
    protected void onCalendarDayClicked(int year, int month, int day) {
        Calendar calendar = this.calendarProvider.getCalendar();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (this.isInThePast(year, month, day)) {
            return;
        }
        this.selected = this.selected != null && this.selected.equals(calendar) ? null : calendar;
        super.onCalendarDayClicked(year, month, day);
    }

    @Override
    protected int getStateForDate(int year, int month, int day) {
        if (this.isSelected(this.selected, year, month, day)) {
            return 4;
        }
        if (this.isToday(year, month, day)) {
            return 2;
        }
        if (this.isInThePast(year, month, day)) {
            return 1;
        }
        return 0;
    }

    private boolean isInThePast(int year, int month, int day) {
        Calendar calendar = this.calendarProvider.getCalendar();
        calendar.set(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long now = calendar.getTimeInMillis();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long then = calendar.getTimeInMillis();
        return now > then;
    }

    @Override
    protected boolean isAllowedToAddPreviousMonth() {
        return false;
    }

    @Override
    protected boolean isAllowedToAddNextMonth() {
        return true;
    }

    private boolean isSelected(Calendar selected, int year, int month, int day) {
        if (selected == null) {
            return false;
        }
        Calendar calendar = this.calendarProvider.getCalendar();
        calendar.set(1, selected.get(1));
        calendar.set(2, selected.get(2));
        calendar.set(5, selected.get(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long millis2 = calendar.getTimeInMillis();
        return millis == millis2;
    }

    private boolean isToday(int year, int month, int day) {
        Calendar calendar = this.calendarProvider.getCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long today = calendar.getTime().getTime();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        long calendarMillis = calendar.getTime().getTime();
        return today == calendarMillis;
    }

    @Nullable
    public Date getSelectedDate() {
        return this.selected != null ? this.selected.getTime() : null;
    }
}

