/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.style;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import java.util.Arrays;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.style.MonthResProvider;

public class MonthResProviderImpl
implements MonthResProvider {
    private static final int[] attrs = new int[]{16842904, 16842901, 16842927, 16843660, 16842903, 0x1010113};
    @ColorInt
    private int textColor;
    private int textSize;
    private int gravity;
    private int textStyle;
    private boolean textAllCaps;
    private boolean showYearAlways;
    private int spaceBetweenMonths;

    public MonthResProviderImpl(Context context, ResProvider resProvider) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(resProvider.getMonthTitleStyle(), attrs);
        block8: for (int i = 0; i < attrs.length; ++i) {
            switch (attrs[i]) {
                case 16842904: {
                    this.textColor = typedArray.getColor(i, ContextCompat.getColor((Context)context, (int)17170444));
                    continue block8;
                }
                case 16842901: {
                    this.textSize = typedArray.getDimensionPixelSize(i, 12);
                    continue block8;
                }
                case 16842927: {
                    this.gravity = typedArray.getInt(i, 0x800003);
                    continue block8;
                }
                case 16843660: {
                    this.textAllCaps = typedArray.getBoolean(i, false);
                    continue block8;
                }
                case 16842903: {
                    this.textStyle = typedArray.getInt(i, 0);
                    continue block8;
                }
                case 0x1010113: {
                    this.spaceBetweenMonths = typedArray.getDimensionPixelSize(i, 20);
                }
            }
        }
        typedArray.recycle();
        this.showYearAlways = resProvider.showYearAlways();
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public float getTextSize() {
        return this.textSize;
    }

    @Override
    public int getGravity() {
        return this.gravity;
    }

    @Override
    public boolean getTextAllCaps() {
        return this.textAllCaps;
    }

    @Override
    public boolean showYearAlways() {
        return this.showYearAlways;
    }

    @Override
    public int getTextStyle() {
        return this.textStyle;
    }

    @Override
    public int getSpaceBetweenMonths() {
        return this.spaceBetweenMonths;
    }

    static {
        Arrays.sort(attrs);
    }
}

