/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Calendar;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.WeekHolder;
import pl.rafman.scrollcalendar.contract.ClickCallback;
import pl.rafman.scrollcalendar.data.CalendarDay;
import pl.rafman.scrollcalendar.data.CalendarMonth;
import pl.rafman.scrollcalendar.style.DayResProvider;
import pl.rafman.scrollcalendar.style.MonthResProvider;

public class MonthViewHolder
extends RecyclerView.ViewHolder {
    @Nullable
    private final TextView title;
    private final View space;
    private MonthResProvider monthResProvider;
    private final WeekHolder[] weeks = new WeekHolder[7];
    private boolean textAllCaps;

    public MonthViewHolder(@NonNull View rootView, @NonNull ClickCallback calendarCallback, @NonNull MonthResProvider monthResProvider, @NonNull DayResProvider dayResProvider) {
        super(rootView);
        this.monthResProvider = monthResProvider;
        LinearLayout monthContainer = (LinearLayout)rootView.findViewById(R.id.monthContainer);
        this.title = (TextView)rootView.findViewById(R.id.title);
        this.setupTitleAppearance(monthResProvider);
        this.space = rootView.findViewById(R.id.spaceBetweenMonths);
        this.setupSpaceBetweenMonths(this.space, monthResProvider);
        for (int i = 0; i < this.weeks.length; ++i) {
            WeekHolder holder;
            this.weeks[i] = holder = this.createWeekHolder(calendarCallback, dayResProvider);
            monthContainer.addView(holder.layout(monthContainer));
        }
    }

    private void setupSpaceBetweenMonths(View space, MonthResProvider resProvider) {
        if (space == null) {
            return;
        }
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)space.getLayoutParams();
        params.height = resProvider.getSpaceBetweenMonths();
        space.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected WeekHolder createWeekHolder(@NonNull ClickCallback calendarCallback, @NonNull DayResProvider resProvider) {
        return new WeekHolder(calendarCallback, resProvider);
    }

    private void setupTitleAppearance(@NonNull MonthResProvider resProvider) {
        if (this.title == null) {
            return;
        }
        this.title.setTextColor(resProvider.getTextColor());
        this.title.setTextSize(0, resProvider.getTextSize());
        this.title.setGravity(resProvider.getGravity());
        this.title.setTypeface(this.title.getTypeface(), resProvider.getTextStyle());
        this.textAllCaps = resProvider.getTextAllCaps();
    }

    MonthViewHolder(View rootView) {
        super(rootView);
        this.title = null;
        this.space = null;
    }

    public static MonthViewHolder create(@NonNull ViewGroup parent, @NonNull ClickCallback calendarCallback, @NonNull MonthResProvider resProvider, @NonNull DayResProvider dayResProvider) {
        return new MonthViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_month, parent, false), calendarCallback, resProvider, dayResProvider);
    }

    void bind(CalendarMonth month) {
        if (this.title != null) {
            String txt = this.monthResProvider.showYearAlways() ? month.getMonthNameWithYear() : month.getReadableMonthName();
            this.title.setText((CharSequence)this.applyCase(txt));
        }
        for (int i = 0; i <= this.weeks.length - 1; ++i) {
            this.weeks[i].display(i, month, this.filterWeekDays(i, month));
        }
    }

    private String applyCase(@NonNull String string) {
        return this.textAllCaps ? string.toUpperCase() : string;
    }

    CalendarDay[] filterWeekDays(int weekOfMonth, CalendarMonth calendarMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendarMonth.getYear());
        calendar.set(2, calendarMonth.getMonth());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ArrayList<CalendarDay> days = new ArrayList<CalendarDay>();
        for (CalendarDay calendarDay : calendarMonth.getDays()) {
            calendar.set(5, calendarDay.getDay());
            if (calendar.get(4) != weekOfMonth) continue;
            days.add(calendarDay);
        }
        return days.toArray(new CalendarDay[days.size()]);
    }
}

