/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.contract.ClickCallback;
import pl.rafman.scrollcalendar.data.CalendarDay;
import pl.rafman.scrollcalendar.data.CalendarMonth;
import pl.rafman.scrollcalendar.style.DayResProvider;
import pl.rafman.scrollcalendar.widgets.SquareTextView;

class DayHolder
implements View.OnClickListener {
    private final DayResProvider resProvider;
    @NonNull
    private final ClickCallback calendarCallback;
    @Nullable
    private SquareTextView textView;
    @Nullable
    private CalendarMonth calendarMonth;
    @Nullable
    private CalendarDay currentDay;

    DayHolder(@NonNull ClickCallback calendarCallback, @NonNull DayResProvider resProvider) {
        this.calendarCallback = calendarCallback;
        this.resProvider = resProvider;
    }

    public View layout(LinearLayout parent) {
        if (this.textView == null) {
            this.textView = (SquareTextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_day, (ViewGroup)parent, false);
            this.textView.setOnClickListener(this);
        }
        return this.textView;
    }

    void display(@Nullable CalendarMonth calendarMonth, @Nullable CalendarDay currentDay, @Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        this.calendarMonth = calendarMonth;
        this.currentDay = currentDay;
        this.setupVisibility(currentDay);
        this.setupStyles(currentDay, previousDay, nextDay);
    }

    private void setupVisibility(@Nullable CalendarDay calendarDay) {
        if (this.textView == null) {
            return;
        }
        if (calendarDay == null) {
            this.textView.setVisibility(4);
        } else {
            this.textView.setVisibility(0);
            this.textView.setText(String.valueOf(calendarDay.getDay()));
        }
    }

    private void setupStyles(@Nullable CalendarDay currentDay, @Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        if (currentDay != null) {
            switch (currentDay.getState()) {
                case 5: {
                    this.setupForFirstSelectedDate();
                    break;
                }
                case 7: {
                    this.setupForOnlySelectedDate();
                    break;
                }
                case 6: {
                    this.setupForLastSelectedDate();
                    break;
                }
                case 4: {
                    this.setupForSelectedDate(previousDay, nextDay);
                    break;
                }
                case 3: {
                    this.setupForUnavailableDate();
                    break;
                }
                case 1: {
                    this.setupForDisabledDate();
                    break;
                }
                case 2: {
                    this.setupForTodayDate();
                    break;
                }
                default: {
                    this.setupForDefaultDate();
                }
            }
        }
    }

    private void setupForOnlySelectedDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getSelectedDayTextColor());
        this.textView.setBackgroundResource(this.resProvider.getSelectedDayBackground());
    }

    private void setupForDefaultDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getDayTextColor());
        this.textView.setBackgroundColor(this.resProvider.getDayBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForTodayDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getCurrentDayTextColor());
        this.textView.setBackgroundResource(this.resProvider.getCurrentDayBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForDisabledDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getDisabledTextColor());
        this.textView.setBackgroundColor(this.resProvider.getDisabledBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForUnavailableDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getUnavailableTextColor());
        this.textView.setBackgroundResource(this.resProvider.getUnavailableBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForFirstSelectedDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getSelectedBeginningDayTextColor());
        this.textView.setBackgroundResource(this.resProvider.getSelectedBeginningDayBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForLastSelectedDate() {
        if (this.textView == null) {
            return;
        }
        this.textView.setTextColor(this.resProvider.getSelectedEndDayTextColor());
        this.textView.setBackgroundResource(this.resProvider.getSelectedEndDayBackground());
        this.setFont(this.resProvider.getCustomFont());
    }

    private void setupForSelectedDate(@Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        if (this.textView == null) {
            return;
        }
        if (!this.resProvider.softLineBreaks()) {
            this.textView.setTextColor(this.resProvider.getSelectedMiddleDayTextColor());
            this.textView.setBackgroundResource(this.resProvider.getSelectedMiddleDayBackground());
            return;
        }
        if (this.hasNoNeighbours(previousDay, nextDay)) {
            this.textView.setTextColor(this.resProvider.getSelectedDayTextColor());
            this.textView.setBackgroundResource(this.resProvider.getSelectedDayBackground());
        } else if (this.isBeginning(previousDay)) {
            if (this.resProvider.softLineBreaks()) {
                this.textView.setTextColor(this.resProvider.getSelectedBeginningDayTextColor());
                this.textView.setBackgroundResource(this.resProvider.getSelectedBeginningDayBackground());
            } else {
                this.textView.setTextColor(this.resProvider.getSelectedMiddleDayTextColor());
                this.textView.setBackgroundResource(this.resProvider.getSelectedMiddleDayBackground());
            }
        } else if (this.isMiddle(previousDay, nextDay)) {
            this.textView.setTextColor(this.resProvider.getSelectedMiddleDayTextColor());
            this.textView.setBackgroundResource(this.resProvider.getSelectedMiddleDayBackground());
        } else if (this.isEnd(nextDay)) {
            if (this.resProvider.softLineBreaks()) {
                this.textView.setTextColor(this.resProvider.getSelectedEndDayTextColor());
                this.textView.setBackgroundResource(this.resProvider.getSelectedEndDayBackground());
            } else {
                this.textView.setTextColor(this.resProvider.getSelectedMiddleDayTextColor());
                this.textView.setBackgroundResource(this.resProvider.getSelectedMiddleDayBackground());
            }
        }
        this.setFont(this.resProvider.getCustomFont());
    }

    private boolean isBeginning(@Nullable CalendarDay previousDay) {
        return !this.isSelected(previousDay);
    }

    private boolean isEnd(CalendarDay nextDay) {
        return !this.isSelected(nextDay);
    }

    private boolean isMiddle(CalendarDay previousDay, CalendarDay nextDay) {
        return this.isSelected(previousDay) && this.isSelected(nextDay);
    }

    private boolean hasNoNeighbours(@Nullable CalendarDay previousDay, @Nullable CalendarDay nextDay) {
        return !this.isSelected(previousDay) && !this.isSelected(nextDay);
    }

    private boolean isSelected(@Nullable CalendarDay previousDay) {
        return previousDay != null && this.equalsAny(previousDay.getState(), CalendarDay.SELECTED_STATES);
    }

    private boolean equalsAny(int state, int[] ints) {
        for (int anInt : ints) {
            if (anInt != state) continue;
            return true;
        }
        return false;
    }

    private void setFont(Typeface customFont) {
        if (this.textView == null) {
            return;
        }
        if (customFont != null) {
            this.textView.setTypeface(customFont);
        }
    }

    public void onClick(View view) {
        if (this.calendarMonth != null && this.currentDay != null) {
            this.calendarCallback.onCalendarDayClicked(this.calendarMonth, this.currentDay);
        }
    }
}

