/*
 * Decompiled with CFR 0.152.
 */
package pl.rafman.scrollcalendar.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import pl.rafman.scrollcalendar.R;
import pl.rafman.scrollcalendar.adapter.DayHolder;
import pl.rafman.scrollcalendar.adapter.ResProvider;
import pl.rafman.scrollcalendar.contract.ClickCallback;
import pl.rafman.scrollcalendar.data.CalendarDay;
import pl.rafman.scrollcalendar.data.CalendarMonth;

class WeekHolder {
    private final DayHolder[] days = new DayHolder[7];
    @Nullable
    private LinearLayout container;

    WeekHolder(@NonNull ClickCallback calendarCallback, @NonNull ResProvider resProvider) {
        for (int i = 0; i < this.days.length; ++i) {
            this.days[i] = new DayHolder(calendarCallback, resProvider);
        }
    }

    @Nullable
    public View layout(LinearLayout parent) {
        if (this.container == null) {
            this.container = (LinearLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_week, (ViewGroup)parent, false);
            if (this.container != null) {
                for (DayHolder day : this.days) {
                    this.container.addView(day.layout(this.container));
                }
            }
        }
        return this.container;
    }

    void display(int week, CalendarMonth month, CalendarDay[] daysOfWeek) {
        if (this.container != null) {
            this.container.setVisibility(daysOfWeek.length == 0 ? 8 : 0);
        }
        for (int i = 0; i < this.days.length; ++i) {
            this.days[i].display(month, this.dayOrNull(i, week, daysOfWeek));
        }
    }

    private CalendarDay dayOrNull(int position, int week, CalendarDay[] calendarDays) {
        if (this.isRightAligned(week)) {
            return this.takeRightAligned(position, calendarDays);
        }
        return this.takeLeftAligned(position, calendarDays);
    }

    @Nullable
    private CalendarDay takeLeftAligned(int position, CalendarDay[] calendarDays) {
        if (position < calendarDays.length) {
            return calendarDays[position];
        }
        return null;
    }

    @Nullable
    private CalendarDay takeRightAligned(int position, CalendarDay[] calendarDays) {
        int offset = this.days.length - calendarDays.length;
        if (position < offset) {
            return null;
        }
        return calendarDays[position - offset];
    }

    private boolean isRightAligned(int week) {
        return week == 1;
    }
}

