/*
 * Decompiled with CFR 0.152.
 */
package pl.rafalmanka.scrollcalendar.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import pl.rafalmanka.scrollcalendar.R;
import pl.rafalmanka.scrollcalendar.SquareTextView;
import pl.rafalmanka.scrollcalendar.adapter.ResProvider;
import pl.rafalmanka.scrollcalendar.contract.ClickCallback;
import pl.rafalmanka.scrollcalendar.data.CalendarDay;
import pl.rafalmanka.scrollcalendar.data.CalendarMonth;

class DayHolder
implements View.OnClickListener {
    @NonNull
    private final ClickCallback calendarCallback;
    @Nullable
    private SquareTextView textView;
    private final ResProvider resProvider;
    @Nullable
    private CalendarMonth calendarMonth;
    @Nullable
    private CalendarDay calendarDay;

    DayHolder(@NonNull ClickCallback calendarCallback, @NonNull ResProvider resProvider) {
        this.calendarCallback = calendarCallback;
        this.resProvider = resProvider;
    }

    public View layout(LinearLayout parent) {
        if (this.textView == null) {
            this.textView = (SquareTextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.scrollcalendar_day, (ViewGroup)parent, false);
            this.textView.setOnClickListener(this);
            this.textView.setTextSize(0, this.resProvider.fontSize());
        }
        return this.textView;
    }

    void display(@Nullable CalendarMonth calendarMonth, @Nullable CalendarDay calendarDay) {
        this.refreshValue(calendarMonth, calendarDay);
        this.refreshAppearance(calendarDay);
        this.refreshStyle(calendarDay);
    }

    private void refreshValue(@Nullable CalendarMonth calendarMonth, @Nullable CalendarDay calendarDay) {
        this.calendarMonth = calendarMonth;
        this.calendarDay = calendarDay;
    }

    private void refreshAppearance(@Nullable CalendarDay calendarDay) {
        if (this.textView == null) {
            return;
        }
        if (calendarDay == null) {
            this.textView.setVisibility(4);
        } else {
            this.textView.setVisibility(0);
            this.textView.setText(String.valueOf(calendarDay.getDay()));
        }
    }

    private void refreshStyle(@Nullable CalendarDay calendarDay) {
        if (this.textView == null) {
            return;
        }
        if (calendarDay != null) {
            switch (calendarDay.getState()) {
                case 4: {
                    this.textView.setTextColor(this.resProvider.selectedTextColor());
                    this.textView.setBackgroundResource(this.resProvider.selectedBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 3: {
                    this.textView.setTextColor(this.resProvider.unavailableTextColor());
                    this.textView.setBackgroundResource(this.resProvider.unavailableBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 1: {
                    this.textView.setTextColor(this.resProvider.disabledTextColor());
                    this.textView.setBackgroundColor(this.resProvider.disabledBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                case 2: {
                    this.textView.setTextColor(this.resProvider.todayTextColor());
                    this.textView.setBackgroundResource(this.resProvider.todayBackground());
                    this.setFont(this.resProvider.getCustomFont());
                    break;
                }
                default: {
                    this.textView.setTextColor(this.resProvider.defaultFontColor());
                    this.textView.setBackgroundColor(this.resProvider.defaultBackgroundColor());
                    this.setFont(this.resProvider.getCustomFont());
                }
            }
        }
    }

    private void setFont(Typeface customFont) {
        if (this.textView == null) {
            return;
        }
        if (customFont != null) {
            this.textView.setTypeface(customFont);
        }
    }

    public void onClick(View view) {
        if (this.calendarMonth != null && this.calendarDay != null) {
            this.calendarCallback.onCalendarDayClicked(this.calendarMonth, this.calendarDay);
        }
    }
}

