/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.stups.swagger.codegen.language;

import com.google.common.collect.Lists;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.zalando.stups.swagger.codegen.ConfigurableCodegenConfig;

public class AbstractSpringInterfaces
extends JavaClientCodegen
implements CodegenConfig,
ConfigurableCodegenConfig {
    protected String sourceFolder = "";
    private boolean skipApiGeneration = false;
    private boolean skipModelGeneration = false;
    private final List<String> methodsWithoutRequestBody = Lists.newArrayList((Object[])new String[]{"GET", "DELETE"});

    public void skipApiGeneration() {
        this.skipApiGeneration = true;
    }

    public void skipModelGeneration() {
        this.skipModelGeneration = true;
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "springinterfaces";
    }

    public void preprocessSwagger(Swagger swagger) {
        this.vendorExtensions.put("basePath", swagger.getBasePath());
        super.preprocessSwagger(swagger);
    }

    public String getHelp() {
        return "Generates Spring-Interfaces.";
    }

    public AbstractSpringInterfaces() {
        this.templateDir = "SpringInterfaces";
        this.embeddedTemplateDir = "SpringInterfaces";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
    }

    public List<SupportingFile> supportingFiles() {
        this.supportingFiles.clear();
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
        return this.supportingFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String modelPackage() {
        if (this.skipModelGeneration) {
            return "MODEL_SKIPPED";
        }
        if (this.modelPackage == null || this.modelPackage.trim().isEmpty()) {
            throw new RuntimeException("'modelPackage' should not be null or empty");
        }
        return this.modelPackage;
    }

    public String apiPackage() {
        if (this.skipApiGeneration) {
            return "API_SKIPPED";
        }
        if (this.apiPackage == null || this.apiPackage.trim().isEmpty()) {
            throw new RuntimeException("'apiPackage' should not be null or empty");
        }
        return this.apiPackage;
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    public void processOpts() {
        super.processOpts();
        this.importMapping.remove("SerializedName");
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("SerializedName");
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                if (this.methodsWithoutRequestBody.contains(operation.httpMethod)) {
                    operation.vendorExtensions.put("consumesExpected", false);
                } else {
                    operation.vendorExtensions.put("consumesExpected", true);
                }
                List responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                System.out.println(operation.operationId);
                Json.prettyPrint((Object)operation);
                if (operation.returnType == null) {
                    operation.returnType = this.getVoidReturnType();
                    operation.hasProduces = Boolean.FALSE;
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    int end2 = rt.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    int end3 = rt.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    protected String getVoidReturnType() {
        return "void";
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public boolean is303Supported() {
        return false;
    }

    public void enable303() {
    }

    public boolean isBuilderSupported() {
        return false;
    }

    public void enableBuilderSupport() {
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return AbstractSpringInterfaces.camelize((String)name) + "Api";
    }
}

