/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.gradle.jruby.internal.core;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.List;
import org.apache.groovy.nio.extensions.NioExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMultiply;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.gradle.jruby.api.gems.GemInfo;
import org.ysb33r.gradle.jruby.api.gems.GemNotFoundException;
import org.ysb33r.gradle.jruby.api.gems.GemVersion;
import org.ysb33r.gradle.jruby.api.resolver.ApiException;
import org.ysb33r.gradle.jruby.api.resolver.IvyXmlFactory;
import org.ysb33r.gradle.jruby.api.resolver.RubyGemQueryRestApi;
import org.ysb33r.gradle.jruby.internal.core.DefaultRubyGemRestApi;
import org.ysb33r.gradle.jruby.internal.core.IvyUtils;
import org.ysb33r.gradle.jruby.internal.gems.GemRepositoryConfiguration;
import org.ysb33r.gradle.jruby.internal.gems.GemToIvy;
import org.ysb33r.grolifant.api.core.ExclusiveFileAccess;

public class DefaultIvyXmlFactory
implements IvyXmlFactory,
GroovyObject {
    private static final long EXPIRY_PERIOD_MILLIS;
    private final boolean refreshDependencies;
    private final String group;
    private final RubyGemQueryRestApi api;
    private final GemRepositoryConfiguration configuration;
    private final File localCachePath;
    private final GemToIvy gemToIvy;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DefaultIvyXmlFactory(File localCachePath, String group, URI serverUri, boolean refreshDependencies, GemRepositoryConfiguration grc) {
        GemToIvy gemToIvy;
        File file;
        GemRepositoryConfiguration gemRepositoryConfiguration;
        boolean bl;
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.group = string = group;
        this.refreshDependencies = bl = refreshDependencies;
        DefaultRubyGemRestApi defaultRubyGemRestApi = new DefaultRubyGemRestApi(serverUri);
        this.api = defaultRubyGemRestApi;
        this.configuration = gemRepositoryConfiguration = grc;
        this.localCachePath = file = localCachePath;
        this.gemToIvy = gemToIvy = new GemToIvy(serverUri);
    }

    @Override
    public Path ivyXmlPath(String grp, String name, String version) throws GemNotFoundException {
        if (this.inGroups(grp)) {
            Object v3;
            Object v2;
            Object v0;
            String revision = this.getGemQueryRevisionFromIvy(name, version);
            Path ivyXml = this.ivyFile(name, revision);
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.group, name, version, revision}, new String[]{"Requested ", ":", ":", " translated to GEM with version ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            if (this.refreshDependencies || this.expired(ivyXml)) {
                try {
                    this.createIvyXml(ivyXml, name, revision);
                }
                catch (ApiException e) {
                    Object v1;
                    if (log.isDebugEnabled()) {
                        log.debug(e.getMessage(), (Throwable)e);
                        v1 = null;
                    } else {
                        v1 = null;
                    }
                    throw (Throwable)new GemNotFoundException();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toAbsolutePath()}, new String[]{"Cached file is ", ""})));
                v2 = null;
            } else {
                v2 = null;
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{NioExtensions.getText((Path)ivyXml)}, new String[]{"Cached file contains ", ""})));
                v3 = null;
            } else {
                v3 = null;
            }
            return ivyXml;
        }
        throw (Throwable)new GemNotFoundException();
    }

    @Override
    public Path ivyXmlSha1(String grp, String name, String version) throws GemNotFoundException {
        if (this.inGroups(grp)) {
            Path ivyXml = this.ivyXmlPath(grp, name, version);
            return ivyXml.resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toFile().getName()}, new String[]{"", ".sha1"})));
        }
        throw (Throwable)new GemNotFoundException();
    }

    @Override
    public String directoryListing(String grp, String name) throws GemNotFoundException {
        if (this.inGroups(grp)) {
            Object v1;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{grp, name}, new String[]{"Request to find all versions for ", ":", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            List<String> versions = this.api.allVersions(name, this.configuration.isPrerelease());
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(versions, (String)", ")}, new String[]{"Got versions ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            return IvyUtils.revisionsAsHtmlDirectoryListing(versions);
        }
        throw (Throwable)new GemNotFoundException();
    }

    private Path ivyFile(String name, String revision) {
        return new File(this.localCachePath, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, revision}, new String[]{"", "/", "/ivy.xml"}))).toPath();
    }

    private String getGemQueryRevisionFromIvy(String gemName, String revisionPattern) {
        GemVersion version = GemVersion.gemVersionFromGradleIvyRequirement(revisionPattern);
        return version.isHighOpenEnded() ? this.api.latestVersion(gemName, this.configuration.isPrerelease()) : version.getHigh();
    }

    /*
     * WARNING - void declaration
     */
    private void createIvyXml(Path ivyXml, String name, String revision) {
        void var3_3;
        void var2_2;
        Reference ivyXml2 = new Reference((Object)ivyXml);
        Reference name2 = new Reference((Object)var2_2);
        Reference revision2 = new Reference((Object)var3_3);
        ExclusiveFileAccess efa = new ExclusiveFileAccess(120000, 20);
        public final class _createIvyXml_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference revision;
            private /* synthetic */ Reference ivyXml;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createIvyXml_closure1(Object _outerInstance, Object _thisObject, Reference name, Reference revision, Reference ivyXml) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.name = reference3 = name;
                this.revision = reference2 = revision;
                this.ivyXml = reference = ivyXml;
            }

            public File doCall(Object it) {
                Reference gemInfo = new Reference((Object)((DefaultIvyXmlFactory)this.getThisObject()).api.metadata(ShortTypeHandling.castToString((Object)this.name.get()), ShortTypeHandling.castToString((Object)this.revision.get())));
                ((Path)this.ivyXml.get()).getParent().toFile().mkdirs();
                Path tmp = ((Path)this.ivyXml.get()).resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Path)this.ivyXml.get()).toFile().getName()}, new String[]{"", ".tmp"})));
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference gemInfo;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference gemInfo) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.gemInfo = reference = gemInfo;
                    }

                    public Writer doCall(Object writer) {
                        return ((DefaultIvyXmlFactory)this.getThisObject()).gemToIvy.writeTo((Writer)ScriptBytecodeAdapter.castToType((Object)writer, Writer.class), (GemInfo)ScriptBytecodeAdapter.castToType((Object)this.gemInfo.get(), GemInfo.class));
                    }

                    @Generated
                    public GemInfo getGemInfo() {
                        return (GemInfo)ScriptBytecodeAdapter.castToType((Object)this.gemInfo.get(), GemInfo.class);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                NioExtensions.withWriter((Path)tmp, (Closure)new _closure2((Object)this, this.getThisObject(), gemInfo));
                Files.move(tmp, (Path)ScriptBytecodeAdapter.castToType((Object)this.ivyXml.get(), Path.class), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return ((DefaultIvyXmlFactory)this.getThisObject()).gemToIvy.writeSha1(((Path)this.ivyXml.get()).toFile());
            }

            @Generated
            public String getName() {
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            @Generated
            public String getRevision() {
                return ShortTypeHandling.castToString((Object)this.revision.get());
            }

            @Generated
            public Path getIvyXml() {
                return (Path)ScriptBytecodeAdapter.castToType((Object)this.ivyXml.get(), Path.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public File doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createIvyXml_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        efa.access(((Path)ivyXml2.get()).toFile(), (Closure)new _createIvyXml_closure1(this, this, name2, revision2, ivyXml2));
    }

    private boolean inGroups(String grp) {
        return ScriptBytecodeAdapter.compareEqual((Object)grp, (Object)this.group);
    }

    protected boolean expired(Path ivyXml) {
        System.currentTimeMillis();
        Path ivyXmlSha1 = ivyXml.resolveSibling(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ivyXml.toFile().getName()}, new String[]{"", ".sha1"})));
        return Files.notExists(ivyXml, new LinkOption[0]) || Files.notExists(ivyXmlSha1, new LinkOption[0]) || Files.getLastModifiedTime(ivyXml, new LinkOption[0]).toMillis() + EXPIRY_PERIOD_MILLIS < Instant.now().toEpochMilli();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultIvyXmlFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        int n = DefaultTypeTransformation.intUnbox((Object)NumberNumberMultiply.multiply((Number)StringGroovyMethods.toInteger((CharSequence)System.getProperty("org.ysb33r.gradle.jruby.cache-expiry-days", "15")), (Number)24)) * 3600 * 1000;
        EXPIRY_PERIOD_MILLIS = n;
        log = logger = LoggerFactory.getLogger((String)"org.ysb33r.gradle.jruby.internal.core.DefaultIvyXmlFactory");
    }
}

