/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util;

import java.util.Iterator;

public class UnionIterator<T>
implements Iterator<T> {
    private final Iterator<T> first;
    private final Iterator<T> second;

    public UnionIterator(Iterator<T> first, Iterator<T> second) {
        if (first == null) {
            throw new NullPointerException("first iterator must not be null.");
        }
        if (second == null) {
            throw new NullPointerException("second iterator must not be null.");
        }
        if (first == second) {
            throw new NullPointerException("first and second iterators must not be the same.");
        }
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean hasNext() {
        return this.first.hasNext() || this.second.hasNext();
    }

    @Override
    public T next() {
        return this.first.hasNext() ? this.first.next() : this.second.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

