/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.Scope;

public class ScopeSessionListener
implements SessionListener {
    private final Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers;
    private final Map<String, List<Consumer<HttpScopeNotification>>> registeredListeners = new HashMap<String, List<Consumer<HttpScopeNotification>>>();

    private ScopeSessionListener(Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers) {
        this.scopeResolvers = scopeResolvers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String sessionId, Consumer<HttpScopeNotification> notificationConsumer) {
        ScopeSessionListener scopeSessionListener = this;
        synchronized (scopeSessionListener) {
            List<Object> consumersForSession;
            if (this.registeredListeners.containsKey(sessionId)) {
                consumersForSession = this.registeredListeners.get(sessionId);
            } else {
                consumersForSession = new ArrayList();
                this.registeredListeners.put(sessionId, consumersForSession);
            }
            consumersForSession.add(notificationConsumer);
        }
    }

    public synchronized void sessionIdChanged(Session session, String oldSessionId) {
        if (this.registeredListeners.containsKey(oldSessionId)) {
            List<Consumer<HttpScopeNotification>> consumersForSession = this.registeredListeners.remove(oldSessionId);
            this.registeredListeners.put(session.getId(), consumersForSession);
        }
    }

    public synchronized void sessionDestroyed(final Session session, final HttpServerExchange exchange, final SessionListener.SessionDestroyedReason reason) {
        List<Consumer<HttpScopeNotification>> consumersForSession = this.registeredListeners.remove(session.getId());
        if (consumersForSession == null) {
            return;
        }
        consumersForSession.forEach(c -> c.accept(new HttpScopeNotification(){

            public boolean isOfType(Enum ... notification) {
                for (Enum type : notification) {
                    if (HttpScopeNotification.SessionNotificationType.INVALIDATED.equals((Object)type) && SessionListener.SessionDestroyedReason.INVALIDATED.equals((Object)reason)) {
                        return true;
                    }
                    if (HttpScopeNotification.SessionNotificationType.TIMEOUT.equals((Object)type) && SessionListener.SessionDestroyedReason.TIMEOUT.equals((Object)reason)) {
                        return true;
                    }
                    if (!HttpScopeNotification.SessionNotificationType.UNDEPLOY.equals((Object)type) || !SessionListener.SessionDestroyedReason.UNDEPLOY.equals((Object)reason)) continue;
                    return true;
                }
                return false;
            }

            public HttpScope getScope(Scope scope) {
                if (ScopeSessionListener.this.scopeResolvers.containsKey(scope)) {
                    return (HttpScope)((Function)ScopeSessionListener.this.scopeResolvers.get(scope)).apply(exchange);
                }
                if (scope == Scope.SESSION) {
                    return new HttpScope(){

                        public boolean exists() {
                            return true;
                        }

                        public boolean create() {
                            return false;
                        }

                        public boolean supportsAttachments() {
                            return true;
                        }

                        public boolean supportsInvalidation() {
                            return false;
                        }

                        public void setAttachment(String key, Object value) {
                            session.setAttribute(key, value);
                        }

                        public Object getAttachment(String key) {
                            return session.getAttribute(key);
                        }
                    };
                }
                return null;
            }

            public Collection<String> getScopeIds(Scope scope) {
                return null;
            }

            public HttpScope getScope(Scope scope, String id) {
                return null;
            }
        }));
    }

    public static Builder builder() {
        return new Builder();
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }

    public static class Builder {
        private Map<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers = new HashMap<Scope, Function<HttpServerExchange, HttpScope>>();

        private Builder() {
        }

        public Builder addScopeResolver(Scope scope, Function<HttpServerExchange, HttpScope> scopeResolver) {
            this.scopeResolvers.put(scope, scopeResolver);
            return this;
        }

        public ScopeSessionListener build() {
            return new ScopeSessionListener(this.scopeResolvers);
        }
    }
}

