/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.registry;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Sample;
import org.terracotta.statistics.SampledStatistic;
import org.terracotta.statistics.SampledStatisticAdapter;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.SuppliedValueStatistic;
import org.terracotta.statistics.Table;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.registry.OperationStatisticDescriptor;
import org.terracotta.statistics.registry.Statistic;
import org.terracotta.statistics.registry.ValueStatisticDescriptor;

public class StatisticRegistry {
    private final Object contextObject;
    private final Supplier<Long> timeSource;
    private final Map<String, SampledStatistic<? extends Serializable>> statistics = new HashMap<String, SampledStatistic<? extends Serializable>>();

    public StatisticRegistry(Object contextObject) {
        this(contextObject, Time::absoluteTime);
    }

    public StatisticRegistry(Object contextObject, Supplier<Long> timeSource) {
        this.contextObject = contextObject;
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    public Map<String, SampledStatistic<? extends Serializable>> getStatistics() {
        return this.statistics;
    }

    public <T extends Serializable> Optional<Statistic<T>> queryStatistic(String fullStatisticName) {
        return this.queryStatistic(fullStatisticName, 0L);
    }

    public <T extends Serializable> Optional<Statistic<T>> queryStatistic(String fullStatisticName, long sinceMillis) {
        return Optional.ofNullable(this.statistics.get(fullStatisticName)).map(statistic -> new Statistic(statistic.type(), this.filter(statistic.type(), statistic.history(sinceMillis))));
    }

    public Map<String, Statistic<? extends Serializable>> queryStatistics() {
        return this.queryStatistics(0L);
    }

    public Map<String, Statistic<? extends Serializable>> queryStatistics(long sinceMillis) {
        HashMap<String, Statistic<? extends Serializable>> stats = new HashMap<String, Statistic<? extends Serializable>>(this.statistics.size());
        this.statistics.forEach((name, stat) -> stats.put((String)name, new Statistic(stat.type(), this.filter(stat.type(), stat.history(sinceMillis)))));
        return stats;
    }

    public <T extends Serializable> void registerStatistic(String fullStatName, StatisticType type, Supplier<T> accessor) {
        this.registerStatistic(fullStatName, SuppliedValueStatistic.supply(type, accessor));
    }

    public <T extends Serializable> void registerStatistic(String fullStatName, ValueStatistic<T> accessor) {
        this.registerSampledStatistic(fullStatName, SampledStatisticAdapter.sample(accessor, this.timeSource));
    }

    public <T extends Serializable> void registerSampledStatistic(String fullStatName, SampledStatistic<T> accessor) {
        if (this.statistics.put(fullStatName, accessor) != null) {
            throw new IllegalArgumentException("Found duplicate statistic " + fullStatName);
        }
    }

    public void registerTable(String fullStatName, Supplier<Table> accessor) {
        this.registerStatistic(fullStatName, SuppliedValueStatistic.table(accessor));
    }

    public void registerGauge(String fullStatName, Supplier<Number> accessor) {
        this.registerStatistic(fullStatName, SuppliedValueStatistic.gauge(accessor));
    }

    public void registerCounter(String fullStatName, Supplier<Number> accessor) {
        this.registerStatistic(fullStatName, SuppliedValueStatistic.counter(accessor));
    }

    public <T extends Serializable> boolean registerStatistic(String statNameSuffix, ValueStatisticDescriptor descriptor) {
        if (this.contextObject == null) {
            return false;
        }
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return false;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(ValueStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                ValueStatistic statistic = (ValueStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, statistic);
            }
            return true;
        }
        return false;
    }

    public <T extends Enum<T>> boolean registerStatistic(String statNameSuffix, OperationStatisticDescriptor<T> descriptor, EnumSet<T> outcomes) {
        if (this.contextObject == null) {
            return false;
        }
        TreeNode treeNode = ContextManager.nodeFor(this.contextObject);
        if (treeNode == null) {
            return false;
        }
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", descriptor.getType()), Matchers.hasAttribute("name", descriptor.getObserverName()), this.hasTags(descriptor.getTags()))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build().execute(Collections.singleton(treeNode));
        if (!result.isEmpty()) {
            for (TreeNode node : result) {
                String discriminator = null;
                Map properties = (Map)node.getContext().attributes().get("properties");
                if (properties != null && properties.containsKey("discriminator")) {
                    discriminator = properties.get("discriminator").toString();
                }
                String fullStatName = (discriminator == null ? "" : discriminator + ":") + statNameSuffix;
                OperationStatistic statistic = (OperationStatistic)node.getContext().attributes().get("this");
                this.registerStatistic(fullStatName, statistic.statistic(outcomes));
            }
            return true;
        }
        return false;
    }

    private Matcher<Map<String, Object>> hasTags(final Collection<String> tags) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Collection<String>>(){

            @Override
            protected boolean matchesSafely(Collection<String> object) {
                return object.containsAll(tags);
            }
        });
    }

    private <T extends Serializable> List<Sample<T>> filter(StatisticType type, List<Sample<T>> history) {
        return history.stream().filter(s -> s.getSample() != null).collect(Collectors.toList());
    }
}

