/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes log softmax activations.
 * <p>
 * For each batch `i` and class `j` we have
 * <p>
 *     logsoftmax[i, j] = logits[i, j] - log(sum(exp(logits[i])))
 * 
 * @param <T> data type for {@code logsoftmax()} output
 */
@Operator
public final class LogSoftmax<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new LogSoftmax operation to the graph.
   * 
   * @param scope current graph scope
   * @param logits 2-D with shape `[batch_size, num_classes]`.
   * @return a new instance of LogSoftmax
   */
  public static <T extends Number> LogSoftmax<T> create(Scope scope, Operand<T> logits) {
    OperationBuilder opBuilder = scope.graph().opBuilder("LogSoftmax", scope.makeOpName("LogSoftmax"));
    opBuilder.addInput(logits.asOutput());
    return new LogSoftmax<T>(opBuilder.build());
  }
  
  /**
   * Same shape as `logits`.
   */
  public Output<T> logsoftmax() {
    return logsoftmax;
  }
  
  @Override
  public Output<T> asOutput() {
    return logsoftmax;
  }
  
  private Output<T> logsoftmax;
  
  private LogSoftmax(Operation operation) {
    super(operation);
    int outputIdx = 0;
    logsoftmax = operation.output(outputIdx++);
  }
}
