/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Elementwise computes the bitwise XOR of `x` and `y`.
 * <p>
 * The result will have those bits set, that are different in `x` and `y`. The
 * computation is performed on the underlying representations of `x` and `y`.
 * 
 * @param <T> data type for {@code z()} output
 */
@Operator
public final class BitwiseXor<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new BitwiseXor operation to the graph.
   * 
   * @param scope current graph scope
   * @param x 
   * @param y 
   * @return a new instance of BitwiseXor
   */
  public static <T extends Number> BitwiseXor<T> create(Scope scope, Operand<T> x, Operand<T> y) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BitwiseXor", scope.makeOpName("BitwiseXor"));
    opBuilder.addInput(x.asOutput());
    opBuilder.addInput(y.asOutput());
    return new BitwiseXor<T>(opBuilder.build());
  }
  
  /**
   */
  public Output<T> z() {
    return z;
  }
  
  @Override
  public Output<T> asOutput() {
    return z;
  }
  
  private Output<T> z;
  
  private BitwiseXor(Operation operation) {
    super(operation);
    int outputIdx = 0;
    z = operation.output(outputIdx++);
  }
}
