/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;

public class VDBKey
implements Serializable,
Comparable<VDBKey> {
    private static final long serialVersionUID = -7249750823144856081L;
    private String name;
    private Integer[] versionParts = new Integer[3];
    private String version;
    private int hashCode;
    private boolean atMost;
    public static Pattern NAME_PATTERN = Pattern.compile("(?:(0|(?:[1-9]\\d{0,8})))(?:\\.(0|(?:[1-9]\\d{0,8})))?(?:\\.(0|(?:[1-9]\\d{0,8})))?(\\.)?$");

    public VDBKey(String name, Object version) {
        int index;
        this.name = name;
        if (version == null) {
            index = name.indexOf(".");
            if (index > 0 && index < name.length() - 1) {
                this.name = name.substring(0, index);
                this.version = name.substring(index + 1);
            } else {
                this.atMost = true;
            }
        } else {
            String possibleVersion;
            Matcher m;
            this.version = version.toString();
            index = name.indexOf(".");
            if (index > 0 && index < name.length() - 1 && (m = NAME_PATTERN.matcher(possibleVersion = name.substring(index + 1))).matches()) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID31191, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31191, new Object[]{this.name}));
            }
        }
        if (this.version != null) {
            Matcher m = NAME_PATTERN.matcher(this.version);
            if (!m.matches()) {
                if (version != null) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID31190, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31190, new Object[]{this.version}));
                }
                this.name = name;
                this.version = null;
                this.atMost = true;
            } else {
                this.getPart(m, 0);
                this.getPart(m, 1);
                this.getPart(m, 2);
                this.atMost = this.version.endsWith(".");
            }
        }
        if (this.versionParts[1] != null) {
            this.version = this.getSemanticVersion();
        } else if (this.versionParts[0] != null) {
            this.version = this.versionParts[0].toString();
        }
    }

    private void getPart(Matcher m, int part) {
        String val = m.group(part + 1);
        if (val != null) {
            this.versionParts[part] = Integer.parseInt(val);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCodeUtil.hashCode((int)HashCodeUtil.expHashCode((CharSequence)this.name.toLowerCase(), (boolean)false), (Object[])new Object[]{this.getSemanticVersion()});
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VDBKey)) {
            return false;
        }
        VDBKey other = (VDBKey)obj;
        return other.atMost == this.atMost && this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(".");
        if (this.version != null) {
            sb.append(this.version);
            if (this.atMost) {
                sb.append(".");
            }
        } else {
            sb.append("latest");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(VDBKey o) {
        int compare = String.CASE_INSENSITIVE_ORDER.compare(this.name, o.name);
        if (compare != 0) {
            return compare;
        }
        for (int i = 0; i < this.versionParts.length; ++i) {
            compare = Integer.compare(this.versionParts[i] == null ? 0 : this.versionParts[i], o.versionParts[i] == null ? 0 : o.versionParts[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public boolean isAtMost() {
        return this.atMost;
    }

    public boolean acceptsVerion(VDBKey key) {
        if (!key.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        for (int i = 0; i < this.versionParts.length && this.versionParts[i] != null; ++i) {
            if (this.versionParts[i] == (key.versionParts[i] == null ? 0 : key.versionParts[i])) continue;
            return false;
        }
        return true;
    }

    public String getSemanticVersion() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.versionParts.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            if (this.versionParts[i] == null) {
                sb.append(0);
                continue;
            }
            sb.append(this.versionParts[i]);
        }
        return sb.toString();
    }
}

