/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class AbstractValidationVisitor
extends LanguageVisitor {
    private TeiidComponentException exception;
    private LanguageObject exceptionObject;
    protected ValidatorReport report;
    private QueryMetadataInterface metadata;
    protected Command currentCommand;
    protected Stack<LanguageObject> stack = new Stack();

    public AbstractValidationVisitor() {
        this.report = new ValidatorReport();
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    protected QueryMetadataInterface getMetadata() {
        return this.metadata;
    }

    public void reset() {
        this.currentCommand = null;
        this.stack.clear();
    }

    protected void handleValidationError(String message) {
        this.report.addItem(new ValidatorFailure(message));
    }

    protected void handleValidationError(String message, LanguageObject invalidObj) {
        this.report.addItem(new ValidatorFailure(message, invalidObj));
    }

    protected void handleValidationError(String message, Collection invalidObjs) {
        this.report.addItem(new ValidatorFailure(message, invalidObjs));
    }

    protected void handleException(TeiidException e) {
        this.handleException(e, null);
    }

    protected void handleException(TeiidException e, LanguageObject obj) {
        this.exceptionObject = obj;
        this.exception = e instanceof TeiidComponentException ? (TeiidComponentException)((Object)e) : new TeiidComponentException((Throwable)e);
        this.setAbort(true);
    }

    public TeiidComponentException getException() {
        return this.exception;
    }

    public LanguageObject getExceptionObject() {
        return this.exceptionObject;
    }

    public ValidatorReport getReport() {
        return this.report;
    }

    protected Collection<ElementSymbol> validateElementsSupport(Collection<ElementSymbol> elements, int supportsFlag) {
        ArrayList<ElementSymbol> dontSupport = null;
        ElementSymbol symbol2 = null;
        try {
            for (ElementSymbol symbol2 : elements) {
                if (this.getMetadata().elementSupports(symbol2.getMetadataID(), supportsFlag)) continue;
                if (dontSupport == null) {
                    dontSupport = new ArrayList<ElementSymbol>();
                }
                dontSupport.add(symbol2);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e), symbol2);
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), symbol2);
        }
        return dontSupport;
    }
}

