/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.language.WindowFrame;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class WindowFrame
implements LanguageObject {
    private WindowFrame.FrameMode mode;
    private FrameBound start;
    private FrameBound end;

    public WindowFrame(WindowFrame.FrameMode mode) {
        this.mode = mode;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public FrameBound getEnd() {
        return this.end;
    }

    public void setStart(FrameBound lowerBound) {
        this.start = lowerBound;
    }

    public void setEnd(FrameBound upperBound) {
        this.end = upperBound;
    }

    public WindowFrame.FrameMode getMode() {
        return this.mode;
    }

    public void setMode(WindowFrame.FrameMode mode) {
        this.mode = mode;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.mode.hashCode(), (Object[])new Object[]{this.start, this.end});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WindowFrame)) {
            return false;
        }
        WindowFrame other = (WindowFrame)obj;
        return EquivalenceUtil.areEqual((Object)this.mode, (Object)other.mode) && EquivalenceUtil.areEqual((Object)this.start, (Object)other.start) && EquivalenceUtil.areEqual((Object)this.end, (Object)other.end);
    }

    @Override
    public WindowFrame clone() {
        WindowFrame clone = new WindowFrame(this.mode);
        if (this.start != null) {
            clone.setStart(this.start.clone());
        }
        if (this.end != null) {
            clone.setEnd(this.end.clone());
        }
        return clone;
    }

    public static class FrameBound {
        private WindowFrame.BoundMode boundMode;
        private Integer bound;

        public FrameBound(WindowFrame.BoundMode mode) {
            this.boundMode = mode;
        }

        public Integer getBound() {
            return this.bound;
        }

        public WindowFrame.BoundMode getBoundMode() {
            return this.boundMode;
        }

        public FrameBound bound(Integer i) {
            this.bound = i;
            return this;
        }

        public void setBound(Integer bound) {
            this.bound = bound;
        }

        public void setBoundMode(WindowFrame.BoundMode boundMode) {
            this.boundMode = boundMode;
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.bound, this.boundMode});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FrameBound)) {
                return false;
            }
            FrameBound other = (FrameBound)obj;
            return EquivalenceUtil.areEqual((Object)this.boundMode, (Object)other.boundMode) && EquivalenceUtil.areEqual((Object)this.bound, (Object)other.bound);
        }

        public FrameBound clone() {
            FrameBound clone = new FrameBound(this.boundMode);
            clone.bound = this.bound;
            return clone;
        }
    }
}

