/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.Expression;

public class JsonTable
extends TableFunctionReference {
    private Expression json;
    private List<JsonColumn> columns = new ArrayList<JsonColumn>();
    private String rowPath;
    private Boolean nullLeaf;

    public Boolean getNullLeaf() {
        return this.nullLeaf;
    }

    public void setNullLeaf(Boolean nullLeaf) {
        this.nullLeaf = nullLeaf;
    }

    public List<JsonColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<JsonColumn> columns) {
        this.columns = columns;
    }

    public Expression getJson() {
        return this.json;
    }

    public void setJson(Expression json) {
        this.json = json;
    }

    public String getRowPath() {
        return this.rowPath;
    }

    public void setRowPath(String jsonQuery) {
        this.rowPath = jsonQuery;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected JsonTable cloneDirect() {
        JsonTable clone = new JsonTable();
        this.copy(clone);
        clone.setJson((Expression)this.json.clone());
        clone.rowPath = this.rowPath;
        clone.nullLeaf = this.nullLeaf;
        for (JsonColumn column : this.columns) {
            clone.getColumns().add(column.clone());
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof JsonTable)) {
            return false;
        }
        JsonTable other = (JsonTable)obj;
        return this.columns.equals(other.columns) && EquivalenceUtil.areEqual((Object)this.json, (Object)other.json) && EquivalenceUtil.areEqual((Object)this.nullLeaf, (Object)other.nullLeaf) && EquivalenceUtil.areEqual((Object)this.rowPath, (Object)other.rowPath);
    }

    public static class JsonColumn
    extends TableFunctionReference.ProjectedColumn {
        private boolean ordinal;
        private String path;

        public JsonColumn(String name) {
            super(name, "integer");
            this.ordinal = true;
        }

        public JsonColumn(String name, String type, String path) {
            super(name, type);
            this.path = path;
        }

        protected JsonColumn() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(boolean ordinal) {
            this.ordinal = ordinal;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof JsonColumn)) {
                return false;
            }
            JsonColumn other = (JsonColumn)obj;
            return this.ordinal == other.ordinal && EquivalenceUtil.areEqual((Object)this.path, (Object)other.path);
        }

        public JsonColumn clone() {
            JsonColumn clone = new JsonColumn();
            super.copyTo(clone);
            clone.ordinal = this.ordinal;
            clone.path = this.path;
            return clone;
        }
    }
}

