/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePushNonJoinCriteria;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCopyCriteria
implements OptimizerRule {
    static boolean COPY_ALL = false;

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        List<PlanNode> critNodes = NodeEditor.findAllNodes(plan, 20);
        boolean shouldRun = false;
        for (PlanNode critNode : critNodes) {
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) continue;
            shouldRun = true;
            break;
        }
        if (!shouldRun) {
            return plan;
        }
        if (this.tryToCopy(plan, new Set[2], metadata, false)) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.RAISE_ACCESS);
            rules.push(new RulePushNonJoinCriteria(false));
        }
        for (PlanNode critNode : critNodes) {
            critNode.setProperty(NodeConstants.Info.IS_COPIED, Boolean.TRUE);
        }
        return plan;
    }

    private Integer copyCriteria(Criteria crit, Map<Expression, Expression> tgtMap, List<Criteria> joinCriteria, Set<Criteria> combinedCriteria, boolean checkForGroupReduction, QueryMetadataInterface metadata, boolean underAccess) {
        int startGroups = GroupsUsedByElementsVisitor.getGroups(crit).size();
        Criteria tgtCrit = (Criteria)crit.clone();
        try {
            tgtCrit = FrameUtil.convertCriteria(tgtCrit, tgtMap, metadata, true);
        }
        catch (QueryPlannerException err) {
            LogManager.logDetail((String)"org.teiid.PLANNER", (Object)((Object)err), (Object)"Could not remap target criteria in RuleCopyCriteria");
            return null;
        }
        if (tgtCrit instanceof IsNullCriteria && ((IsNullCriteria)tgtCrit).isNegated()) {
            return null;
        }
        int endGroups = GroupsUsedByElementsVisitor.getGroups(tgtCrit).size();
        if (checkForGroupReduction ? endGroups >= startGroups : endGroups > startGroups) {
            return null;
        }
        boolean isNew = combinedCriteria.add(tgtCrit);
        if (underAccess) {
            if (!isNew || checkForGroupReduction || endGroups > 1) {
                return null;
            }
            if (!COPY_ALL) {
                boolean use = false;
                Collection<ElementSymbol> cols = ElementCollectorVisitor.getElements((LanguageObject)tgtCrit, true);
                for (Criteria existing : combinedCriteria) {
                    Collection<ElementSymbol> elements;
                    if (existing.equals(tgtCrit) || GroupsUsedByElementsVisitor.getGroups(elements = ElementCollectorVisitor.getElements((LanguageObject)existing, true)).size() > 1 || !elements.containsAll(cols)) continue;
                    use = true;
                    break;
                }
                if (!use) {
                    return null;
                }
            }
        }
        if (isNew) {
            CompareCriteria cc;
            joinCriteria.add(tgtCrit);
            if (tgtCrit instanceof CompareCriteria && !EvaluatableVisitor.willBecomeConstant((cc = (CompareCriteria)tgtCrit).getRightExpression()) && !EvaluatableVisitor.willBecomeConstant(cc.getRightExpression())) {
                ((CompareCriteria)tgtCrit).setOptional(true);
            }
            return endGroups;
        }
        if (checkForGroupReduction && endGroups < 2) {
            return endGroups;
        }
        return null;
    }

    private boolean tryToCopy(PlanNode node, Set<Criteria>[] criteriaInfo, QueryMetadataInterface metadata, boolean underAccess) {
        boolean changedTree = false;
        if (node == null) {
            return false;
        }
        if (node.getType() == 4) {
            JoinType jt = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (jt == JoinType.JOIN_FULL_OUTER) {
                return this.visitChildern(node, criteriaInfo, changedTree, metadata, underAccess);
            }
            Set[] leftChildCriteria = new Set[2];
            Set[] rightChildCriteria = new Set[2];
            changedTree |= this.tryToCopy(node.getFirstChild(), leftChildCriteria, metadata, underAccess);
            changedTree |= this.tryToCopy(node.getLastChild(), rightChildCriteria, metadata, underAccess);
            List joinCrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            LinkedHashSet<Criteria> combinedCriteria = null;
            if (joinCrits != null) {
                combinedCriteria = new LinkedHashSet<Criteria>(joinCrits);
                combinedCriteria.addAll(leftChildCriteria[1]);
                combinedCriteria.addAll(rightChildCriteria[1]);
            }
            leftChildCriteria[0].addAll(rightChildCriteria[0]);
            leftChildCriteria[1].addAll(rightChildCriteria[1]);
            criteriaInfo[0] = leftChildCriteria[0];
            criteriaInfo[1] = leftChildCriteria[1];
            if (jt == JoinType.JOIN_CROSS) {
                return changedTree;
            }
            Set<Criteria> toCopy = criteriaInfo[0];
            Set<Criteria> allCriteria = criteriaInfo[1];
            if (joinCrits != null && !joinCrits.isEmpty()) {
                LinkedList<Criteria> newJoinCrits = new LinkedList<Criteria>();
                Map<Expression, Expression> srcToTgt = this.buildElementMap(joinCrits, node.hasBooleanProperty(NodeConstants.Info.IS_COPIED) ? null : newJoinCrits, combinedCriteria, metadata, underAccess);
                changedTree |= !newJoinCrits.isEmpty();
                if (!toCopy.isEmpty()) {
                    changedTree |= this.createCriteria(false, toCopy, combinedCriteria, srcToTgt, newJoinCrits, metadata, underAccess, node);
                    srcToTgt = this.buildElementMap(allCriteria, null, null, metadata, underAccess);
                    changedTree |= this.createCriteria(true, joinCrits, combinedCriteria, srcToTgt, newJoinCrits, metadata, underAccess, node);
                }
                joinCrits.addAll(newJoinCrits);
            }
            if (jt == JoinType.JOIN_RIGHT_OUTER || jt == JoinType.JOIN_ANTI_SEMI || jt == JoinType.JOIN_SEMI || jt == JoinType.JOIN_UNION) {
                throw new AssertionError((Object)"Unexpected join type");
            }
            if (jt == JoinType.JOIN_LEFT_OUTER) {
                criteriaInfo[0].removeAll(rightChildCriteria[0]);
                criteriaInfo[1].removeAll(rightChildCriteria[1]);
            } else if (node.getSubqueryContainers().isEmpty()) {
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) {
                    toCopy.addAll(combinedCriteria);
                }
                allCriteria.addAll(joinCrits);
            }
            return changedTree;
        }
        changedTree = this.visitChildern(node, criteriaInfo, changedTree, metadata, underAccess);
        switch (node.getType()) {
            case 16: {
                if (criteriaInfo[0] == null) break;
                this.visitSelectNode(node, criteriaInfo[0], criteriaInfo[1]);
                break;
            }
            case 8: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                if (criteriaInfo[0] == null) {
                    criteriaInfo[0] = new LinkedHashSet<Criteria>();
                    criteriaInfo[1] = new LinkedHashSet<Criteria>();
                    break;
                }
                criteriaInfo[0].clear();
                criteriaInfo[1].clear();
            }
        }
        return changedTree;
    }

    private boolean createCriteria(boolean copyingJoinCriteria, Collection<Criteria> toCopy, Set<Criteria> combinedCriteria, Map<Expression, Expression> srcToTgt, List<Criteria> newJoinCrits, QueryMetadataInterface metadata, boolean underAccess, PlanNode node) {
        boolean changedTree = false;
        if (srcToTgt.size() == 0) {
            return changedTree;
        }
        Iterator<Criteria> i = toCopy.iterator();
        while (i.hasNext()) {
            SetCriteria sc;
            CompareCriteria cc;
            Criteria crit = i.next();
            Integer endGroups = this.copyCriteria(crit, srcToTgt, newJoinCrits, combinedCriteria, copyingJoinCriteria, metadata, underAccess);
            if (endGroups == null) continue;
            changedTree = true;
            if (endGroups >= 2) continue;
            if (copyingJoinCriteria) {
                if (crit instanceof CompareCriteria) {
                    cc = (CompareCriteria)crit;
                    cc.setOptional(null);
                    continue;
                }
                i.remove();
                continue;
            }
            if (!(crit instanceof CompareCriteria) ? !(crit instanceof SetCriteria) || (sc = (SetCriteria)crit).isNegated() : (cc = (CompareCriteria)crit).getOperator() != 1) continue;
            PlanNode childNode = FrameUtil.findJoinSourceNode(node.getFirstChild());
            if (childNode != null && !childNode.hasProperty(NodeConstants.Info.MAKE_DEP) && !childNode.hasProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                childNode.setProperty(NodeConstants.Info.MAKE_NOT_DEP, true);
            }
            if ((childNode = FrameUtil.findJoinSourceNode(node.getLastChild())) == null || childNode.hasProperty(NodeConstants.Info.MAKE_DEP) || childNode.hasProperty(NodeConstants.Info.ACCESS_PATTERNS)) continue;
            childNode.setProperty(NodeConstants.Info.MAKE_NOT_DEP, true);
        }
        return changedTree;
    }

    private void visitSelectNode(PlanNode node, Set<Criteria> toCopy, Set<Criteria> allCriteria) {
        Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (node.getGroups().size() == 1) {
            List<Criteria> crits = Criteria.separateCriteriaByAnd(crit);
            if (!node.hasBooleanProperty(NodeConstants.Info.IS_HAVING) && node.getSubqueryContainers().isEmpty()) {
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) {
                    toCopy.addAll(crits);
                }
                allCriteria.addAll(crits);
            }
        }
    }

    private boolean visitChildern(PlanNode node, Set<Criteria>[] criteriaInfo, boolean changedTree, QueryMetadataInterface metadata, boolean underAccess) {
        if (node.getChildCount() > 0) {
            underAccess |= node.getType() == 1;
            List<PlanNode> children = node.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PlanNode childNode = children.get(i);
                changedTree |= this.tryToCopy(childNode, i == 0 ? criteriaInfo : new Set[2], metadata, underAccess);
            }
        }
        return changedTree;
    }

    Map<Expression, Expression> buildElementMap(Collection<Criteria> crits, List<Criteria> newJoinCrits, Set<Criteria> allCriteria, QueryMetadataInterface metadata, boolean underAccess) {
        HashMap<Expression, Expression> srcToTgt = null;
        Iterator<Criteria> iter = crits.iterator();
        while (iter.hasNext()) {
            CompareCriteria crit;
            Criteria theCrit = iter.next();
            if (theCrit instanceof IsNullCriteria) {
                IsNullCriteria isNull = (IsNullCriteria)theCrit;
                if (isNull.isNegated() || !(isNull.getExpression() instanceof ElementSymbol)) continue;
                if (srcToTgt == null) {
                    srcToTgt = new HashMap<Expression, Expression>();
                }
                srcToTgt.put(isNull.getExpression(), new Constant(null, isNull.getExpression().getType()));
                continue;
            }
            if (!(theCrit instanceof CompareCriteria) || (crit = (CompareCriteria)theCrit).getOperator() != 1) continue;
            if (srcToTgt == null) {
                srcToTgt = new HashMap();
            }
            Expression oldValue = srcToTgt.put(crit.getLeftExpression(), crit.getRightExpression());
            boolean removed = false;
            if (this.checkWithinJoin(crit, newJoinCrits, allCriteria, oldValue, crit.getRightExpression(), metadata, underAccess)) {
                iter.remove();
                removed = true;
            }
            if (!this.checkWithinJoin(crit, newJoinCrits, allCriteria, oldValue = srcToTgt.put(crit.getRightExpression(), crit.getLeftExpression()), crit.getLeftExpression(), metadata, underAccess) || removed) continue;
            iter.remove();
        }
        if (srcToTgt == null) {
            return Collections.emptyMap();
        }
        return srcToTgt;
    }

    private boolean checkWithinJoin(CompareCriteria crit, List<Criteria> newJoinCrits, Set<Criteria> allCriteria, Expression oldValue, Expression left, QueryMetadataInterface metadata, boolean underAccess) {
        if (newJoinCrits == null || oldValue == null) {
            return false;
        }
        if (oldValue.equals(left)) {
            return true;
        }
        Criteria newCrit = new CompareCriteria((Expression)left.clone(), 1, (Expression)oldValue.clone());
        try {
            newCrit = QueryRewriter.rewriteCriteria(newCrit, null, metadata);
        }
        catch (TeiidException e) {
            LogManager.logDetail((String)"org.teiid.PLANNER", (Object)((Object)e), (Object)"Could not remap target criteria in RuleCopyCriteria");
            return false;
        }
        if (allCriteria.add(newCrit)) {
            if (underAccess && GroupsUsedByElementsVisitor.getGroups(newCrit).size() > 1) {
                return false;
            }
            if (newCrit instanceof CompareCriteria) {
                ((CompareCriteria)newCrit).setOptional(true);
            }
            newJoinCrits.add(newCrit);
        }
        if (!GroupsUsedByElementsVisitor.getGroups(crit.getLeftExpression()).isEmpty() && !GroupsUsedByElementsVisitor.getGroups(crit.getRightExpression()).isEmpty() && (GroupsUsedByElementsVisitor.getGroups(left).isEmpty() || GroupsUsedByElementsVisitor.getGroups(oldValue).isEmpty())) {
            crit.setOptional(null);
        }
        return false;
    }

    public String toString() {
        return "CopyCriteria";
    }
}

