/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.teiid.metadata.VDBResource;
import org.teiid.query.metadata.VirtualFile;

public class VDBResources {
    public static final String DEPLOYMENT_FILE = "vdb.xml";
    public static final String INDEX_EXT = ".INDEX";
    private LinkedHashMap<String, Resource> vdbEntries;

    public VDBResources(VirtualFile root) throws IOException {
        int length = root.getPathName().length();
        boolean correctNames = length > 1 || !root.getPathName().equals("/");
        LinkedHashMap<String, Resource> visibilityMap = new LinkedHashMap<String, Resource>();
        for (VirtualFile f : root.getFileChildrenRecursively()) {
            String path = f.getPathName();
            if (correctNames && !(path = path.substring(length)).startsWith("/")) {
                path = "/" + path;
            }
            visibilityMap.put(path, new Resource(f));
        }
        this.vdbEntries = visibilityMap;
    }

    public LinkedHashMap<String, Resource> getEntriesPlusVisibilities() {
        return this.vdbEntries;
    }

    public static class Resource
    implements VDBResource {
        VirtualFile file;

        public Resource(VirtualFile file) {
            this.file = file;
        }

        public InputStream openStream() throws IOException {
            return this.file.openStream();
        }

        public long getSize() {
            return this.file.getSize();
        }

        public String getName() {
            return this.file.getName();
        }
    }
}

