/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class UDFMetadataRepository
implements MetadataRepository {
    public void loadMetadata(MetadataFactory factory, ExecutionFactory executionFactory, Object connectionFactory, String text) throws TranslatorException {
        String className = factory.getModelProperties().getProperty("importer.schemaName");
        String methodNames = factory.getModelProperties().getProperty("importer.methodNames");
        ClassLoader classLoader = factory.getVDBClassLoader();
        HashSet<String> allowed = null;
        if (methodNames != null) {
            allowed = new HashSet<String>(Arrays.asList(methodNames.split(",")));
        }
        try {
            Class<?> clazz = classLoader.loadClass(className);
            if (UserDefinedAggregate.class.isAssignableFrom(clazz)) {
                factory.addFunction(clazz.getSimpleName(), clazz.getMethod("getResult", CommandContext.class));
            } else {
                Method[] methods;
                for (Method m : methods = clazz.getMethods()) {
                    if (!Modifier.isStatic(m.getModifiers()) || m.getReturnType() == Void.TYPE || allowed != null && !allowed.contains(m.getName())) continue;
                    factory.addFunction(m.getName(), m);
                }
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new TranslatorException((Throwable)e);
        }
    }
}

