/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Permission;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;

public class DatabaseUtil {
    public static Database convert(VDBMetaData vdb, MetadataStore metadataStore) {
        Database db = new Database(vdb.getName(), vdb.getVersion());
        db.setProperties(vdb.getPropertiesMap());
        if (vdb.getDescription() != null) {
            db.setAnnotation(vdb.getDescription());
        }
        if (VDB.ConnectionType.BY_VERSION != vdb.getConnectionType()) {
            db.setProperty("connection-type", vdb.getConnectionType().name());
        }
        db.getMetadataStore().addDataTypes((Map)metadataStore.getDatatypes());
        List translators = vdb.getOverrideTranslators();
        for (Translator t : translators) {
            DataWrapper dw;
            if (db.getDataWrapper(t.getType()) == null) {
                dw = new DataWrapper(t.getType());
                db.addDataWrapper(dw);
            }
            if (db.getDataWrapper(t.getName()) != null) continue;
            dw = new DataWrapper(t.getName());
            dw.setType(t.getType());
            for (String key : t.getProperties().stringPropertyNames()) {
                dw.setProperty(key, t.getPropertyValue(key));
            }
            if (t.getDescription() != null) {
                dw.setAnnotation(t.getDescription());
            }
            db.addDataWrapper(dw);
        }
        Collection models = vdb.getModelMetaDatas().values();
        for (ModelMetaData m : models) {
            Schema schema = metadataStore.getSchema(m.getName());
            if (m.isSource()) {
                Collection sources = m.getSourceMappings();
                for (SourceMappingMetadata s : sources) {
                    if (db.getDataWrapper(s.getTranslatorName()) == null) {
                        DataWrapper dw = new DataWrapper(s.getTranslatorName());
                        db.addDataWrapper(dw);
                    }
                    Server server = new Server(s.getName());
                    server.setResourceName(s.getConnectionJndiName());
                    server.setDataWrapper(s.getTranslatorName());
                    if (db.getServer(s.getName()) != null) continue;
                    db.addServer(server);
                    schema.addServer(server);
                }
            }
            db.addSchema(schema);
        }
        for (String key : vdb.getDataPolicyMap().keySet()) {
            Permission permission;
            DataPolicyMetadata dpm = (DataPolicyMetadata)vdb.getDataPolicyMap().get(key);
            Role role = new Role(dpm.getName());
            if (dpm.getMappedRoleNames() != null && !dpm.getMappedRoleNames().isEmpty()) {
                role.setMappedRoles(dpm.getMappedRoleNames());
            }
            if (dpm.isAnyAuthenticated()) {
                role.setAnyAuthenticated(true);
            }
            if (dpm.isGrantAll()) {
                permission = new Permission();
                permission.setAllowAllPrivileges(Boolean.valueOf(true));
                permission.setResourceType(Database.ResourceType.DATABASE);
                role.addGrant(permission);
            }
            if (dpm.isAllowCreateTemporaryTables() != null && dpm.isAllowCreateTemporaryTables().booleanValue()) {
                permission = new Permission();
                permission.setAllowTemporyTables(Boolean.valueOf(true));
                permission.setResourceType(Database.ResourceType.DATABASE);
                role.addGrant(permission);
            }
            for (DataPolicy.DataPermission dp : dpm.getPermissions()) {
                Permission permission2 = DatabaseUtil.convert(dp, metadataStore);
                role.addGrant(permission2);
            }
            db.addRole(role);
        }
        return db;
    }

    private static Permission convert(DataPolicy.DataPermission dp, MetadataStore store) {
        Permission p = new Permission();
        p.setAllowAlter(dp.getAllowAlter());
        p.setAllowDelete(dp.getAllowDelete());
        p.setAllowExecute(dp.getAllowExecute());
        p.setAllowInsert(dp.getAllowCreate());
        p.setAllowSelect(dp.getAllowRead());
        p.setAllowUpdate(dp.getAllowUpdate());
        p.setResourceName(dp.getResourceName());
        if (dp.getAllowLanguage() != null) {
            p.setAllowUsage(Boolean.valueOf(true));
            p.setResourceType(Database.ResourceType.LANGUAGE);
        } else if (dp.getResourceType() != null) {
            p.setResourceType(Database.ResourceType.valueOf((String)dp.getResourceType().name()));
        } else {
            List parts = StringUtil.split((String)dp.getResourceName(), (String)".");
            if (parts.size() == 1) {
                p.setResourceType(Database.ResourceType.SCHEMA);
            } else {
                Schema s;
                if (dp.getMask() != null && parts.size() > 2) {
                    p.setResourceType(Database.ResourceType.COLUMN);
                }
                if ((s = store.getSchema((String)parts.get(0))) != null) {
                    if (parts.size() > 2) {
                        Database.ResourceType fullType = DatabaseUtil.getType(s, StringUtil.join(parts.subList(1, parts.size()), (String)"."));
                        Database.ResourceType type = DatabaseUtil.getType(s, StringUtil.join(parts.subList(1, parts.size() - 1), (String)"."));
                        if (fullType != null && type == null) {
                            p.setResourceType(fullType);
                        } else if (type != null && fullType == null && type == Database.ResourceType.TABLE) {
                            p.setResourceType(Database.ResourceType.COLUMN);
                        }
                    } else {
                        String name = (String)parts.get(1);
                        Database.ResourceType type = DatabaseUtil.getType(s, name);
                        if (type != null) {
                            p.setResourceType(type);
                        }
                    }
                }
            }
        }
        if (dp.getMask() != null) {
            p.setMask(dp.getMask());
            p.setMaskOrder(dp.getOrder());
        }
        if (dp.getCondition() != null) {
            p.setCondition(dp.getCondition(), dp.getConstraint());
        }
        return p;
    }

    private static Database.ResourceType getType(Schema s, String name) {
        Table t = s.getTable(name);
        Procedure proc = s.getProcedure(name);
        boolean hasFunction = s.getFunctions().values().stream().anyMatch(f -> name.equalsIgnoreCase(f.getName()));
        if (t != null && proc == null && !hasFunction) {
            return Database.ResourceType.TABLE;
        }
        if (proc != null && t == null && !hasFunction) {
            return Database.ResourceType.PROCEDURE;
        }
        if (hasFunction && t == null && proc == null) {
            return Database.ResourceType.FUNCTION;
        }
        return null;
    }

    public static VDBMetaData convert(Database database) {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName(database.getName());
        vdb.setVersion(database.getVersion());
        vdb.setDescription(database.getAnnotation());
        if (database.getProperty("connection-type", false) != null) {
            vdb.setConnectionType(VDB.ConnectionType.valueOf((String)database.getProperty("connection-type", false)));
        }
        vdb.getPropertiesMap().putAll(database.getProperties());
        String domainDDLString = DDLStringVisitor.getDomainDDLString(database);
        if (!domainDDLString.isEmpty()) {
            vdb.addProperty("domain-ddl", domainDDLString);
        }
        for (DataWrapper dw : database.getDataWrappers()) {
            if (dw.getType() == null) continue;
            VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
            translator.setName(dw.getName());
            translator.setType(dw.getType());
            translator.setDescription(dw.getAnnotation());
            translator.getPropertiesMap().putAll(dw.getProperties());
            vdb.addOverideTranslator(translator);
        }
        for (Schema schema : database.getSchemas()) {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName(schema.getName());
            mmd.setDescription(schema.getAnnotation());
            mmd.setVisible(Boolean.valueOf(schema.isVisible()).booleanValue());
            mmd.getPropertiesMap().putAll(schema.getProperties());
            if (schema.isPhysical()) {
                mmd.setModelType(Model.Type.PHYSICAL);
                for (Server server : schema.getServers()) {
                    String connectionName = server.getResourceName();
                    if (connectionName == null) {
                        connectionName = server.getName();
                    }
                    mmd.addSourceMapping(server.getName(), server.getDataWrapper(), connectionName);
                }
            } else {
                mmd.setModelType(Model.Type.VIRTUAL);
            }
            vdb.addModel(mmd);
        }
        DatabaseUtil.copyDatabaseGrantsAndRoles(database, vdb);
        return vdb;
    }

    public static void copyDatabaseGrantsAndRoles(Database database, VDBMetaData vdb) {
        for (Role role : database.getRoles()) {
            DataPolicyMetadata dpm = DatabaseUtil.convert(role, null);
            vdb.addDataPolicy(dpm);
        }
    }

    public static DataPolicyMetadata.PermissionMetaData convert(Permission from) {
        DataPolicyMetadata.PermissionMetaData pmd = new DataPolicyMetadata.PermissionMetaData();
        pmd.setResourceName(from.getResourceName());
        pmd.setResourceType(DataPolicy.ResourceType.valueOf((String)from.getResourceType().name()));
        pmd.setAllowAlter(from.hasPrivilege(Permission.Privilege.ALTER));
        pmd.setAllowCreate(from.hasPrivilege(Permission.Privilege.INSERT));
        pmd.setAllowDelete(from.hasPrivilege(Permission.Privilege.DELETE));
        pmd.setAllowExecute(from.hasPrivilege(Permission.Privilege.EXECUTE));
        pmd.setAllowRead(from.hasPrivilege(Permission.Privilege.SELECT));
        pmd.setAllowUpdate(from.hasPrivilege(Permission.Privilege.UPDATE));
        pmd.setAllowLanguage(from.hasPrivilege(Permission.Privilege.USAGE));
        pmd.setCondition(from.getCondition());
        pmd.setConstraint(from.isConditionAConstraint());
        pmd.setMask(from.getMask());
        pmd.setOrder(from.getMaskOrder());
        return pmd;
    }

    public static DataPolicyMetadata convert(Role role, DataPolicyMetadata dpm) {
        if (dpm == null) {
            dpm = new DataPolicyMetadata();
            dpm.setName(role.getName());
            dpm.setDescription(role.getAnnotation());
            if (role.getMappedRoles() != null && !role.getMappedRoles().isEmpty()) {
                dpm.setMappedRoleNames(role.getMappedRoles());
            }
        }
        if (role.isAnyAuthenticated()) {
            dpm.setAnyAuthenticated(true);
        }
        for (Permission grant : role.getGrants().values()) {
            if (Boolean.TRUE.equals(grant.hasPrivilege(Permission.Privilege.ALL_PRIVILEGES))) {
                dpm.setGrantAll(true);
                continue;
            }
            if (Boolean.TRUE.equals(grant.hasPrivilege(Permission.Privilege.TEMPORARY_TABLE))) {
                dpm.setAllowCreateTemporaryTables(Boolean.valueOf(true));
                continue;
            }
            DataPolicyMetadata.PermissionMetaData pmd = DatabaseUtil.convert(grant);
            dpm.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd});
        }
        dpm.addPolicies(role.getPolicies());
        return dpm;
    }
}

