/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.BaseExtractionTable;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.CachingTupleSource;
import org.teiid.dqp.internal.process.ChildRecordExtractionTable;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.FunctionSystemTable;
import org.teiid.dqp.internal.process.FutureWork;
import org.teiid.dqp.internal.process.ProcedureSystemTable;
import org.teiid.dqp.internal.process.RecordExtractionTable;
import org.teiid.dqp.internal.process.RecordTable;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SchemaRecordTable;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TableSystemTable;
import org.teiid.dqp.internal.process.TupleSourceCache;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.NamespaceContainer;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.DdlPlan;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.tempdata.BaseIndexInfo;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class DataTierManagerImpl
implements ProcessorDataManager {
    private static final int MAX_VALUE_LENGTH = 0x200000;
    private static final TreeMap<String, Integer> levelMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    DQPCore requestMgr;
    private BufferManager bufferManager;
    private EventDistributor eventDistributor;
    private boolean detectChangeEvents;
    private Map<SystemTables, BaseExtractionTable<?>> systemTables = new HashMap();
    private Map<SystemAdminTables, BaseExtractionTable<?>> systemAdminTables = new HashMap();
    private static TreeMap<String, List<String>> PREFIX_MAP;

    public static int getLevel(String level) throws TeiidProcessingException {
        Integer intLevel = levelMap.get(level);
        if (intLevel == null) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30546, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30546, new Object[]{level, levelMap.keySet()}));
        }
        return intLevel;
    }

    public DataTierManagerImpl(DQPCore requestMgr, BufferManager bufferMgr, boolean detectChangeEvents) {
        this.requestMgr = requestMgr;
        this.bufferManager = bufferMgr;
        this.detectChangeEvents = detectChangeEvents;
        MetadataStore ms = SystemMetadata.getInstance().getSystemStore();
        TransformationMetadata tm = new TransformationMetadata(null, new CompositeMetadataStore(ms), null, null, null);
        String name = SystemTables.SCHEMAS.name();
        List<ElementSymbol> columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.SCHEMAS, new RecordExtractionTable<Schema>((RecordTable)new SchemaRecordTable(1, columns), columns){

            @Override
            public void fillRow(List<Object> row, Schema model, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Schema> iter) {
                row.add(vdb.getName());
                row.add(model.getName());
                row.add(model.isPhysical());
                row.add(model.getUUID());
                row.add(model.getAnnotation());
                row.add(model.getPrimaryMetamodelUri());
            }
        });
        name = SystemTables.TABLES.name();
        columns = this.getColumns(tm, "SYS." + name);
        this.systemTables.put(SystemTables.TABLES, new RecordExtractionTable<Table>((RecordTable)new TableSystemTable(1, 2, columns), columns){

            @Override
            public void fillRow(List<Object> row, Table table, VDBMetaData v, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Table> iter) {
                row.add(v.getName());
                row.add(((Schema)table.getParent()).getName());
                row.add(table.getName());
                row.add(table.getTableType().toString());
                row.add(table.getNameInSource());
                row.add(table.isPhysical());
                row.add(table.supportsUpdate());
                row.add(table.getUUID());
                row.add(table.getCardinality());
                row.add(table.getAnnotation());
                row.add(table.isSystem());
                row.add(table.isMaterialized());
                row.add(((Schema)table.getParent()).getUUID());
            }
        });
        name = SystemAdminTables.MATVIEWS.name();
        columns = this.getColumns(tm, name);
        this.systemAdminTables.put(SystemAdminTables.MATVIEWS, new RecordExtractionTable<Table>((RecordTable)new TableSystemTable(1, 2, columns){

            @Override
            protected boolean isValid(Table s, VDBMetaData vdb, List<Object> rowBuffer, Criteria condition, CommandContext cc) throws TeiidProcessingException, TeiidComponentException {
                if (s == null || !s.isMaterialized()) {
                    return false;
                }
                return super.isValid(s, vdb, rowBuffer, condition, cc);
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, Table table, VDBMetaData v, TransformationMetadata m, CommandContext cc, RecordTable.SimpleIterator<Table> iter) {
                String targetSchema = null;
                String matTableName = null;
                String state = null;
                Timestamp updated = null;
                Integer cardinaltity = null;
                Boolean valid = null;
                if (table.getMaterializedTable() == null) {
                    GlobalTableStore globalStore = cc.getGlobalTableStore();
                    matTableName = "#MAT_" + table.getFullName().toUpperCase();
                    TempMetadataID id = globalStore.getGlobalTempTableMetadataId(matTableName);
                    GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
                    valid = info.isValid();
                    state = info.getState().name();
                    Timestamp timestamp = updated = info.getUpdateTime() == -1L ? null : new Timestamp(info.getUpdateTime());
                    if (id != null) {
                        cardinaltity = (int)Math.min(Integer.MAX_VALUE, id.getCardinality());
                    }
                } else {
                    Table t = table.getMaterializedTable();
                    matTableName = t.getName();
                    targetSchema = ((Schema)t.getParent()).getName();
                }
                row.add(v.getName());
                row.add(((Schema)table.getParent()).getName());
                row.add(table.getName());
                row.add(targetSchema);
                row.add(matTableName);
                row.add(valid);
                row.add(state);
                row.add(updated);
                row.add(cardinaltity);
            }
        });
        name = SystemAdminTables.VDBRESOURCES.name();
        columns = this.getColumns(tm, name);
        this.systemAdminTables.put(SystemAdminTables.VDBRESOURCES, new BaseExtractionTable<String>(columns){

            @Override
            public RecordTable.SimpleIterator<String> createIterator(VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
                String[] vals = metadata.getVDBResourcePaths();
                return new RecordTable.SimpleIteratorWrapper<String>(Arrays.asList(vals).iterator());
            }

            @Override
            public void fillRow(List<Object> row, String filePath, VDBMetaData v, TransformationMetadata m, CommandContext cc, RecordTable.SimpleIterator<String> iter) {
                row.add(filePath);
                row.add(new BlobType((Blob)m.getVDBResourceAsBlob(filePath)));
            }
        });
        name = SystemTables.PROCEDURES.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.PROCEDURES, new RecordExtractionTable<Procedure>((RecordTable)new ProcedureSystemTable(1, 2, columns), columns){

            @Override
            public void fillRow(List<Object> row, Procedure proc, VDBMetaData v, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Procedure> iter) {
                row.add(v.getName());
                row.add(proc.getParent().getName());
                row.add(proc.getName());
                row.add(proc.getNameInSource());
                row.add(proc.getResultSet() != null);
                row.add(proc.getUUID());
                row.add(proc.getAnnotation());
                row.add(proc.getParent().getUUID());
            }
        });
        name = SystemTables.FUNCTIONS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.FUNCTIONS, new RecordExtractionTable<FunctionMethod>((RecordTable)new FunctionSystemTable(1, 4, columns), columns){

            @Override
            public void fillRow(List<Object> row, FunctionMethod proc, VDBMetaData v, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<FunctionMethod> iter) {
                row.add(v.getName());
                if (proc.getParent() != null) {
                    row.add(proc.getParent().getName());
                } else {
                    row.add("SYS");
                }
                row.add(proc.getName());
                row.add(proc.getNameInSource());
                row.add(proc.getUUID());
                row.add(proc.getAnnotation());
                row.add(proc.isVarArgs());
                if (proc.getParent() != null) {
                    row.add(proc.getParent().getUUID());
                } else {
                    String systemUid = null;
                    try {
                        systemUid = metadata.getModelID("SYS").getUUID();
                    }
                    catch (TeiidComponentException teiidComponentException) {
                        // empty catch block
                    }
                    row.add(systemUid);
                }
            }
        });
        name = SystemTables.DATATYPES.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.DATATYPES, new RecordExtractionTable<Datatype>((RecordTable)new RecordTable<Datatype>(new int[]{0}, columns.subList(0, 1)){

            @Override
            public RecordTable.SimpleIterator<Datatype> processQuery(VDBMetaData vdb, CompositeMetadataStore metadataStore, BaseIndexInfo<?> ii, TransformationMetadata metadata, CommandContext commandContext) {
                return this.processQuery(vdb, metadataStore.getDatatypesExcludingAliases(), ii, commandContext);
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, Datatype datatype, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Datatype> iter) {
                row.add(datatype.getName());
                row.add(datatype.isBuiltin());
                row.add(datatype.getType().name());
                row.add(datatype.getName());
                row.add(datatype.getJavaClassName());
                row.add(datatype.getScale());
                row.add(datatype.getLength());
                row.add(datatype.getNullType().toString());
                row.add(datatype.isSigned());
                row.add(datatype.isAutoIncrement());
                row.add(datatype.isCaseSensitive());
                Integer precision = datatype.getPrecision();
                if (datatype.isBuiltin() && !Number.class.isAssignableFrom(DataTypeManager.getDataTypeClass((String)datatype.getRuntimeTypeName()))) {
                    precision = JDBCSQLTypeInfo.getDefaultPrecision((String)datatype.getName());
                } else if (precision != null && precision == 0) {
                    precision = JDBCSQLTypeInfo.getDefaultPrecision((String)datatype.getRuntimeTypeName());
                }
                row.add(precision);
                row.add(datatype.getRadix());
                row.add(datatype.getSearchType().toString());
                row.add(datatype.getUUID());
                row.add(datatype.getRuntimeTypeName());
                row.add(datatype.getBasetypeName());
                row.add(datatype.getAnnotation());
                row.add(JDBCSQLTypeInfo.getSQLType((String)datatype.getRuntimeTypeName()));
                List prefix = (List)PREFIX_MAP.get(datatype.getRuntimeTypeName());
                if (prefix != null) {
                    row.add(prefix.get(0));
                    row.add(prefix.get(1));
                } else {
                    row.add(null);
                    row.add(null);
                }
            }
        });
        name = SystemTables.VIRTUALDATABASES.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.VIRTUALDATABASES, new BaseExtractionTable<VDBMetaData>(columns){

            @Override
            public RecordTable.SimpleIterator<VDBMetaData> createIterator(VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
                return new RecordTable.SimpleIteratorWrapper<VDBMetaData>(Arrays.asList(vdb).iterator());
            }

            @Override
            public void fillRow(List<Object> row, VDBMetaData record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<VDBMetaData> iter) {
                VDBKey key = new VDBKey(record.getName(), 0);
                row.add(key.getName());
                row.add(record.getVersion());
                row.add(record.getDescription());
                row.add(record.getStatusTimestamp(VDB.Status.LOADING));
                row.add(record.getStatusTimestamp(VDB.Status.ACTIVE));
            }
        });
        name = SystemTables.PROCEDUREPARAMS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.PROCEDUREPARAMS, new ChildRecordExtractionTable<Procedure, BaseColumn>((RecordTable)new ProcedureSystemTable(1, 2, columns), columns){

            @Override
            public void fillRow(List<Object> row, BaseColumn param, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<BaseColumn> iter) {
                Datatype dt = param.getDatatype();
                row.add(vdb.getName());
                String type = "ResultSet";
                AbstractMetadataRecord proc = param.getParent();
                boolean isOptional = false;
                int pos = param.getPosition();
                if (param instanceof ProcedureParameter) {
                    ProcedureParameter pp = (ProcedureParameter)param;
                    type = pp.getType().name();
                    isOptional = pp.isOptional();
                    if (((ProcedureParameter)((Procedure)proc).getParameters().get(0)).getType() == ProcedureParameter.Type.ReturnValue) {
                        --pos;
                    }
                } else {
                    Column pp = (Column)param;
                    proc = param.getParent().getParent();
                }
                row.add(proc.getParent().getName());
                row.add(proc.getName());
                row.add(proc.getUUID());
                row.add(param.getName());
                row.add(param.getRuntimeType());
                row.add(pos);
                row.add(type);
                row.add(isOptional);
                row.add(param.getPrecision());
                row.add(param.getLength());
                row.add(param.getScale());
                row.add(param.getRadix());
                row.add(param.getNullType().toString());
                row.add(param.getUUID());
                row.add(param.getAnnotation());
                DataTierManagerImpl.this.addTypeInfo(row, param, dt);
                row.add(param.getDefaultValue());
            }

            @Override
            protected Collection<? extends BaseColumn> getChildren(Procedure parent, CommandContext cc) {
                List params = parent.getParameters();
                if (parent.getResultSet() == null) {
                    return params;
                }
                List rsColumns = parent.getResultSet().getColumns();
                ArrayList result = new ArrayList(params.size() + rsColumns.size());
                result.addAll(params);
                result.addAll(rsColumns);
                return result;
            }
        });
        name = SystemTables.FUNCTIONPARAMS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.FUNCTIONPARAMS, new ChildRecordExtractionTable<FunctionMethod, FunctionParameter>((RecordTable)new FunctionSystemTable(1, 3, columns), columns){

            @Override
            public void fillRow(List<Object> row, FunctionParameter param, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<FunctionParameter> iter) {
                row.add(vdb.getName());
                FunctionMethod parent = (FunctionMethod)((RecordTable.ExpandingSimpleIterator)iter).getCurrentParent();
                if (parent.getParent() == null) {
                    row.add("SYS");
                } else {
                    row.add(parent.getParent().getName());
                }
                row.add(parent.getName());
                row.add(parent.getUUID());
                row.add(param.getName());
                row.add(param.getRuntimeType());
                row.add(param.getPosition());
                row.add(param.getPosition() == 0 ? "ReturnValue" : "In");
                row.add(param.getPrecision());
                row.add(param.getLength());
                row.add(param.getScale());
                row.add(param.getRadix());
                row.add(param.getNullType().toString());
                row.add(param.getUUID());
                row.add(param.getAnnotation());
                DataTierManagerImpl.this.addTypeInfo(row, (BaseColumn)param, param.getDatatype());
            }

            @Override
            protected Collection<? extends FunctionParameter> getChildren(FunctionMethod parent, CommandContext cc) {
                ArrayList<FunctionParameter> result = new ArrayList<FunctionParameter>(parent.getInputParameters().size() + 1);
                result.addAll(parent.getInputParameters());
                result.add(parent.getOutputParameter());
                return result;
            }
        });
        name = SystemTables.PROPERTIES.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.PROPERTIES, new ChildRecordExtractionTable<AbstractMetadataRecord, Map.Entry<String, String>>((RecordTable)new RecordTable<AbstractMetadataRecord>(new int[]{0}, columns.subList(2, 3)){

            @Override
            protected void fillRow(AbstractMetadataRecord s, List<Object> rowBuffer) {
                rowBuffer.add(s.getUUID());
            }

            @Override
            public RecordTable.SimpleIterator<AbstractMetadataRecord> processQuery(VDBMetaData vdb, CompositeMetadataStore metadataStore, BaseIndexInfo<?> ii, TransformationMetadata metadata, CommandContext commandContext) {
                return this.processQuery(vdb, metadataStore.getOids(), ii, commandContext);
            }

            @Override
            protected AbstractMetadataRecord extractRecord(Object val) {
                if (val != null) {
                    return ((CompositeMetadataStore.RecordHolder)val).getRecord();
                }
                return null;
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, Map.Entry<String, String> entry, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Map.Entry<String, String>> iter) {
                String value = entry.getValue();
                ClobType clobValue = null;
                if (value != null) {
                    clobValue = new ClobType((Clob)new ClobImpl(value));
                }
                row.add(entry.getKey());
                row.add(entry.getValue());
                row.add(((AbstractMetadataRecord)((RecordTable.ExpandingSimpleIterator)iter).getCurrentParent()).getUUID());
                row.add(clobValue);
            }

            @Override
            protected Collection<Map.Entry<String, String>> getChildren(AbstractMetadataRecord parent, CommandContext cc) {
                Map props = parent.getProperties();
                return props.entrySet().stream().flatMap(e -> {
                    String key = (String)e.getKey();
                    String legacyKey = NamespaceContainer.getLegacyKey((String)key);
                    if (legacyKey != null && !props.containsKey(legacyKey)) {
                        return Stream.of(e, new AbstractMap.SimpleEntry<String, String>(legacyKey, (String)e.getValue()));
                    }
                    return Stream.of(e);
                }).collect(Collectors.toList());
            }
        });
        name = SystemAdminTables.TRIGGERS.name();
        columns = this.getColumns(tm, name);
        this.systemAdminTables.put(SystemAdminTables.TRIGGERS, new ChildRecordExtractionTable<Table, Trigger>((RecordTable)new TableSystemTable(1, 2, columns), columns){

            @Override
            protected void fillRow(List<Object> row, Trigger record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Trigger> iter) {
                ClobType clobValue = null;
                if (record.body != null) {
                    clobValue = new ClobType((Clob)new ClobImpl(record.body));
                }
                AbstractMetadataRecord table = (AbstractMetadataRecord)((RecordTable.ExpandingSimpleIterator)iter).getCurrentParent();
                row.add(vdb.getName());
                row.add(table.getParent().getName());
                row.add(table.getName());
                row.add(record.name);
                row.add(record.triggerType);
                row.add(record.triggerEvent);
                row.add(record.status);
                row.add(clobValue);
                row.add(table.getUUID());
            }

            @Override
            protected Collection<Trigger> getChildren(Table table, CommandContext cc) {
                ArrayList<Trigger> cols = new ArrayList<Trigger>();
                if (table.isVirtual()) {
                    if (table.getInsertPlan() != null) {
                        cols.add(new Trigger("it", Table.TriggerEvent.INSERT.name(), table.isInsertPlanEnabled(), null, table.getInsertPlan()));
                    }
                    if (table.getUpdatePlan() != null) {
                        cols.add(new Trigger("ut", Table.TriggerEvent.UPDATE.name(), table.isUpdatePlanEnabled(), null, table.getUpdatePlan()));
                    }
                    if (table.getDeletePlan() != null) {
                        cols.add(new Trigger("dt", Table.TriggerEvent.DELETE.name(), table.isDeletePlanEnabled(), null, table.getDeletePlan()));
                    }
                } else {
                    for (org.teiid.metadata.Trigger trigger : table.getTriggers().values()) {
                        cols.add(new Trigger(trigger.getName(), trigger.getEvent().name(), true, "AFTER", trigger.getPlan()));
                    }
                }
                return cols;
            }
        });
        name = SystemAdminTables.VIEWS.name();
        columns = this.getColumns(tm, "SYSADMIN." + name);
        this.systemAdminTables.put(SystemAdminTables.VIEWS, new RecordExtractionTable<Table>((RecordTable)new TableSystemTable(1, 2, columns){

            @Override
            protected boolean isValid(Table s, VDBMetaData vdb, List<Object> rowBuffer, Criteria condition, CommandContext cc) throws TeiidProcessingException, TeiidComponentException {
                if (s == null || !s.isVirtual()) {
                    return false;
                }
                return super.isValid(s, vdb, rowBuffer, condition, cc);
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, Table table, VDBMetaData v, TransformationMetadata m, CommandContext cc, RecordTable.SimpleIterator<Table> iter) {
                row.add(v.getName());
                row.add(((Schema)table.getParent()).getName());
                row.add(table.getName());
                row.add(new ClobType((Clob)new ClobImpl(table.getSelectTransformation())));
                row.add(table.getUUID());
            }
        });
        this.addSessionsTable(tm);
        this.addRequestsTable(tm);
        this.addTransactionsTable(tm);
        name = SystemAdminTables.STOREDPROCEDURES.name();
        columns = this.getColumns(tm, name);
        this.systemAdminTables.put(SystemAdminTables.STOREDPROCEDURES, new RecordExtractionTable<Procedure>((RecordTable)new ProcedureSystemTable(1, 2, columns){

            @Override
            protected boolean isValid(Procedure s, VDBMetaData vdb, List<Object> rowBuffer, Criteria condition, CommandContext cc) throws TeiidProcessingException, TeiidComponentException {
                if (s == null || !s.isVirtual()) {
                    return false;
                }
                return super.isValid(s, vdb, rowBuffer, condition, cc);
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, Procedure proc, VDBMetaData v, TransformationMetadata m, CommandContext cc, RecordTable.SimpleIterator<Procedure> iter) {
                row.add(v.getName());
                row.add(proc.getParent().getName());
                row.add(proc.getName());
                row.add(new ClobType((Clob)new ClobImpl(proc.getQueryPlan())));
                row.add(proc.getUUID());
            }
        });
        name = SystemTables.COLUMNS.name();
        columns = this.getColumns(tm, "SYS." + name);
        this.systemTables.put(SystemTables.COLUMNS, new ChildRecordExtractionTable<Table, Column>((RecordTable)new TableSystemTable(1, 2, columns), columns){

            @Override
            protected void fillRow(List<Object> row, Column column, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Column> iter) {
                Datatype dt = column.getDatatype();
                row.add(vdb.getName());
                row.add(column.getParent().getParent().getName());
                row.add(column.getParent().getName());
                row.add(column.getName());
                row.add(column.getPosition());
                row.add(column.getNameInSource());
                row.add(column.getRuntimeType());
                row.add(column.getScale());
                row.add(column.getLength());
                row.add(column.isFixedLength());
                row.add(column.isSelectable());
                row.add(column.isUpdatable());
                row.add(column.isCaseSensitive());
                row.add(column.isSigned());
                row.add(column.isCurrency());
                row.add(column.isAutoIncremented());
                row.add(column.getNullType().toString());
                row.add(column.getMinimumValue());
                row.add(column.getMaximumValue());
                row.add(column.getDistinctValues());
                row.add(column.getNullValues());
                row.add(column.getSearchType().toString());
                row.add(column.getFormat());
                row.add(column.getDefaultValue());
                row.add(column.getJavaType().getName());
                row.add(column.getPrecision());
                row.add(column.getCharOctetLength());
                row.add(column.getRadix());
                row.add(column.getUUID());
                row.add(column.getAnnotation());
                row.add(column.getParent().getUUID());
                DataTierManagerImpl.this.addTypeInfo(row, (BaseColumn)column, dt);
            }

            @Override
            protected Collection<Column> getChildren(Table parent, CommandContext cc) {
                return parent.getColumns();
            }
        });
        name = SystemTables.KEYS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.KEYS, new ChildRecordExtractionTable<Table, KeyRecord>((RecordTable)new TableSystemTable(1, 2, columns), columns){

            @Override
            protected void fillRow(List<Object> row, KeyRecord key, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<KeyRecord> iter) {
                KeyRecord ref;
                row.add(vdb.getName());
                row.add(((Schema)((Table)key.getParent()).getParent()).getName());
                row.add(((Table)key.getParent()).getName());
                row.add(key.getName());
                row.add(key.getAnnotation());
                row.add(key.getNameInSource());
                row.add(key.getType().toString());
                row.add(false);
                row.add(key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null);
                row.add(key.getUUID());
                row.add(((Table)key.getParent()).getUUID());
                row.add(((Schema)((Table)key.getParent()).getParent()).getUUID());
                row.add(null);
                row.add(null);
                if (key instanceof ForeignKey && (ref = ((ForeignKey)key).getReferenceKey()) != null) {
                    row.set(row.size() - 2, ((Table)ref.getParent()).getUUID());
                    row.set(row.size() - 1, ((Schema)((Table)ref.getParent()).getParent()).getUUID());
                }
                List columns2 = key.getColumns();
                Short[] pos = new Short[columns2.size()];
                String[] names = new String[columns2.size()];
                for (int i = 0; i < pos.length; ++i) {
                    pos[i] = (short)((Column)columns2.get(i)).getPosition();
                    names[i] = ((Column)columns2.get(i)).getName();
                }
                row.add(new ArrayImpl((Object[])pos));
                row.add(new ArrayImpl((Object[])names));
            }

            @Override
            protected Collection<KeyRecord> getChildren(Table parent, CommandContext cc) {
                return parent.getAllKeys();
            }

            @Override
            protected boolean isValid(KeyRecord result, CommandContext cc) {
                if (!super.isValid(result, cc)) {
                    return false;
                }
                return DataTierManagerImpl.this.isKeyVisible(result, cc);
            }
        });
        name = SystemTables.KEYCOLUMNS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.KEYCOLUMNS, new ChildRecordExtractionTable<Table, List<?>>(new TableSystemTable(1, 2, columns), columns){

            @Override
            protected void fillRow(List<Object> row, List<?> record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<List<?>> iter) {
                row.add(vdb.getName());
                KeyRecord key = (KeyRecord)record.get(0);
                Column column = (Column)record.get(1);
                Integer pos = (Integer)record.get(2);
                row.add(((Schema)((Table)key.getParent()).getParent()).getName());
                row.add(((Table)key.getParent()).getName());
                row.add(column.getName());
                row.add(key.getName());
                row.add(key.getType().toString());
                row.add(key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null);
                row.add(key.getUUID());
                row.add(pos);
                row.add(((Table)key.getParent()).getUUID());
            }

            @Override
            protected Collection<List<?>> getChildren(Table parent, CommandContext cc) {
                ArrayList cols = new ArrayList();
                for (KeyRecord record : parent.getAllKeys()) {
                    if (!cc.getDQPWorkContext().isAdmin() && !DataTierManagerImpl.this.isKeyVisible(record, cc)) continue;
                    int i = 1;
                    for (Column col : record.getColumns()) {
                        cols.add(Arrays.asList(record, col, i++));
                    }
                }
                return cols;
            }
        });
        name = SystemTables.REFERENCEKEYCOLUMNS.name();
        columns = this.getColumns(tm, name);
        this.systemTables.put(SystemTables.REFERENCEKEYCOLUMNS, new ChildRecordExtractionTable<Table, List<?>>(new TableSystemTable(5, 6, columns), columns){

            @Override
            protected void fillRow(List<Object> row, List<?> record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<List<?>> iter) {
                row.add(vdb.getName());
                ForeignKey key = (ForeignKey)record.get(0);
                Table pkTable = (Table)key.getReferenceKey().getParent();
                Column column = (Column)record.get(1);
                Short pos = (Short)record.get(2);
                row.add(((Schema)pkTable.getParent()).getName());
                row.add(pkTable.getName());
                row.add(((Column)key.getReferenceKey().getColumns().get(pos - 1)).getName());
                row.add(vdb.getName());
                row.add(((Schema)((Table)key.getParent()).getParent()).getName());
                row.add(((Table)key.getParent()).getName());
                row.add(column.getName());
                row.add(pos);
                row.add(3);
                row.add(3);
                row.add(key.getName());
                row.add(key.getReferenceKey().getName());
                row.add(5);
                row.add(key.getUUID());
            }

            @Override
            protected Collection<List<?>> getChildren(Table parent, CommandContext cc) {
                ArrayList cols = new ArrayList();
                for (KeyRecord record : parent.getForeignKeys()) {
                    if (!cc.getDQPWorkContext().isAdmin() && !DataTierManagerImpl.this.isKeyVisible(record, cc)) continue;
                    short i = 1;
                    for (Column col : record.getColumns()) {
                        Serializable[] serializableArray = new Serializable[3];
                        serializableArray[0] = record;
                        serializableArray[1] = col;
                        short s = i;
                        i = (short)(i + 1);
                        serializableArray[2] = Short.valueOf(s);
                        cols.add(Arrays.asList(serializableArray));
                    }
                }
                return cols;
            }
        });
        name = SystemAdminTables.USAGE.name();
        columns = this.getColumns(tm, name);
        this.systemAdminTables.put(SystemAdminTables.USAGE, new ChildRecordExtractionTable<AbstractMetadataRecord, AbstractMetadataRecord>((RecordTable)new RecordTable<AbstractMetadataRecord>(new int[]{0}, columns.subList(1, 2)){

            @Override
            protected void fillRow(AbstractMetadataRecord s, List<Object> rowBuffer) {
                rowBuffer.add(s.getUUID());
            }

            @Override
            public RecordTable.SimpleIterator<AbstractMetadataRecord> processQuery(VDBMetaData vdb, CompositeMetadataStore metadataStore, BaseIndexInfo<?> ii, TransformationMetadata metadata, CommandContext commandContext) {
                return this.processQuery(vdb, metadataStore.getOids(), ii, commandContext);
            }

            @Override
            protected AbstractMetadataRecord extractRecord(Object val) {
                if (val != null) {
                    return ((CompositeMetadataStore.RecordHolder)val).getRecord();
                }
                return null;
            }
        }, columns){

            @Override
            public void fillRow(List<Object> row, AbstractMetadataRecord entry, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<AbstractMetadataRecord> iter) {
                AbstractMetadataRecord currentParent = (AbstractMetadataRecord)((RecordTable.ExpandingSimpleIterator)iter).getCurrentParent();
                row.add(vdb.getName());
                row.add(currentParent.getUUID());
                row.add(this.getType(currentParent));
                this.addNames(row, currentParent);
                row.add(entry.getUUID());
                row.add(this.getType(entry));
                this.addNames(row, entry);
            }

            private void addNames(List<Object> row, AbstractMetadataRecord record) {
                if (record instanceof Column) {
                    if (record.getParent().getParent() instanceof Procedure) {
                        row.add(record.getParent().getParent().getParent().getName());
                        row.add(record.getParent().getParent().getName());
                    } else {
                        row.add(record.getParent().getParent().getName());
                        row.add(record.getParent().getName());
                    }
                    row.add(record.getName());
                } else {
                    row.add(record.getParent().getName());
                    row.add(record.getName());
                    row.add(null);
                }
            }

            private String getType(AbstractMetadataRecord record) {
                if (record instanceof Table) {
                    Table t = (Table)record;
                    if (t.getTableType() == Table.Type.Table && t.isVirtual()) {
                        return "View";
                    }
                    return t.getTableType().name();
                }
                if (record instanceof Procedure) {
                    Procedure p = (Procedure)record;
                    if (p.isFunction()) {
                        return p.getType().name();
                    }
                    if (p.isVirtual()) {
                        return "StoredProcedure";
                    }
                    return "ForeignProcedure";
                }
                return record.getClass().getSimpleName();
            }

            @Override
            protected Collection<AbstractMetadataRecord> getChildren(AbstractMetadataRecord parent, CommandContext cc) {
                return parent.getIncomingObjects();
            }
        });
    }

    private void addSessionsTable(TransformationMetadata tm) {
        String name = SystemAdminTables.SESSIONS.name();
        List<ElementSymbol> columns = this.getColumns(tm, "SYSADMIN." + name);
        this.systemAdminTables.put(SystemAdminTables.SESSIONS, new BaseExtractionTable<Session>(columns){

            @Override
            public RecordTable.SimpleIterator<Session> createIterator(final VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc) throws QueryMetadataException, TeiidComponentException {
                return new RecordTable.SimpleIteratorWrapper<Session>(cc.getWorkItem().getDqpCore().getSessionService().getActiveSessions().iterator()){

                    @Override
                    protected boolean isValid(Session result) {
                        return result.getVDBName().equals(vdb.getName()) && result.getVDBVersion().equals(vdb.getVersion());
                    }
                };
            }

            @Override
            protected void fillRow(List<Object> row, Session record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Session> iter) {
                row.add(vdb.getName());
                row.add(record.getSessionId());
                row.add(record.getUserName());
                row.add(new Timestamp(record.getCreatedTime()));
                row.add(record.getApplicationName());
                row.add(record.getIPAddress());
            }
        });
    }

    private void addRequestsTable(TransformationMetadata tm) {
        String name = SystemAdminTables.REQUESTS.name();
        List<ElementSymbol> columns = this.getColumns(tm, "SYSADMIN." + name);
        this.systemAdminTables.put(SystemAdminTables.REQUESTS, new BaseExtractionTable<Request>(columns){

            @Override
            public RecordTable.SimpleIterator<Request> createIterator(final VDBMetaData vdb, TransformationMetadata metadata, final CommandContext cc) throws QueryMetadataException, TeiidComponentException {
                return new RecordTable.ExpandingSimpleIterator<Session, Request>((RecordTable.SimpleIterator)new RecordTable.SimpleIteratorWrapper<Session>(cc.getWorkItem().getDqpCore().getSessionService().getActiveSessions().iterator()){

                    @Override
                    protected boolean isValid(Session result) {
                        return result.getVDBName().equals(vdb.getName()) && result.getVDBVersion().equals(vdb.getVersion());
                    }
                }){

                    @Override
                    protected RecordTable.SimpleIterator<Request> getChildIterator(Session parent) {
                        return new RecordTable.SimpleIteratorWrapper<RequestMetadata>(cc.getWorkItem().getDqpCore().getRequestsForSession(parent.getSessionId()).iterator());
                    }
                };
            }

            @Override
            protected void fillRow(List<Object> row, Request record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Request> iter) {
                row.add(vdb.getName());
                row.add(record.getSessionId());
                row.add(record.getExecutionId());
                row.add(new ClobType((Clob)new ClobImpl(record.getCommand())));
                row.add(new Timestamp(record.getStartTime()));
                row.add(record.getTransactionId());
                row.add(record.getState().name());
                row.add(record.getThreadState().name());
                row.add(record.isSourceRequest());
            }
        });
    }

    private void addTransactionsTable(TransformationMetadata tm) {
        String name = SystemAdminTables.TRANSACTIONS.name();
        List<ElementSymbol> columns = this.getColumns(tm, "SYSADMIN." + name);
        this.systemAdminTables.put(SystemAdminTables.TRANSACTIONS, new BaseExtractionTable<Transaction>(columns){

            @Override
            public RecordTable.SimpleIterator<Transaction> createIterator(final VDBMetaData vdb, TransformationMetadata metadata, final CommandContext cc) throws QueryMetadataException, TeiidComponentException {
                return new RecordTable.SimpleIteratorWrapper<Transaction>(cc.getWorkItem().getDqpCore().getTransactions().iterator()){

                    @Override
                    protected boolean isValid(Transaction result) {
                        if (result.getAssociatedSession() == null) {
                            return true;
                        }
                        SessionMetadata s = cc.getWorkItem().getDqpCore().getSessionService().getActiveSession(result.getAssociatedSession());
                        if (s == null) {
                            return false;
                        }
                        return s.getVDBName().equals(vdb.getName()) && s.getVDBVersion().equals(vdb.getVersion());
                    }
                };
            }

            @Override
            protected void fillRow(List<Object> row, Transaction record, VDBMetaData vdb, TransformationMetadata metadata, CommandContext cc, RecordTable.SimpleIterator<Transaction> iter) {
                row.add(record.getId());
                row.add(record.getAssociatedSession());
                row.add(new Timestamp(record.getCreatedTime()));
                row.add(record.getScope());
            }
        });
    }

    private boolean isKeyVisible(KeyRecord record, CommandContext cc) {
        if (record instanceof ForeignKey && !cc.getAuthorizationValidator().isAccessible((AbstractMetadataRecord)((ForeignKey)record).getReferenceKey(), cc)) {
            return false;
        }
        for (Column c : record.getColumns()) {
            if (cc.getAuthorizationValidator().isAccessible((AbstractMetadataRecord)c, cc)) continue;
            return false;
        }
        return true;
    }

    private void addTypeInfo(List<Object> row, BaseColumn column, Datatype dt) {
        String typeName = column.getRuntimeType();
        if (dt != null) {
            typeName = dt.isBuiltin() || dt.getType() == Datatype.Type.Domain ? dt.getName() : dt.getRuntimeTypeName();
            int arrayDimensions = column.getArrayDimensions();
            while (arrayDimensions-- > 0) {
                typeName = typeName + "[]";
            }
        }
        row.add(typeName);
        row.add(JDBCSQLTypeInfo.getSQLType((String)column.getRuntimeType()));
        Integer columnSize = null;
        if (column.getArrayDimensions() == 0) {
            columnSize = column.getPrecision();
            if (columnSize == 0) {
                columnSize = column.getLength();
            }
            if (typeName != null) {
                Class dataTypeClass = DataTypeManager.getDataTypeClass((String)typeName);
                if (!Number.class.isAssignableFrom(dataTypeClass)) {
                    columnSize = Date.class.isAssignableFrom(dataTypeClass) || column.getLength() <= 0 ? JDBCSQLTypeInfo.getDefaultPrecision((String)column.getRuntimeType()) : Integer.valueOf(column.getLength());
                } else if (column.getPrecision() <= 0) {
                    columnSize = JDBCSQLTypeInfo.getDefaultPrecision((String)column.getRuntimeType());
                }
            }
        }
        row.add(columnSize);
    }

    private List<ElementSymbol> getColumns(TransformationMetadata tm, String name) {
        GroupSymbol gs = new GroupSymbol(name);
        try {
            ResolverUtil.resolveGroup(gs, tm);
            List<ElementSymbol> columns = ResolverUtil.resolveElementsInGroup(gs, tm);
            return columns;
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public boolean detectChangeEvents() {
        return this.detectChangeEvents;
    }

    public void setEventDistributor(EventDistributor eventDistributor) {
        this.eventDistributor = eventDistributor;
    }

    @Override
    public EventDistributor getEventDistributor() {
        return this.eventDistributor;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException, TeiidProcessingException {
        DataTierTupleSource dtts;
        ConnectorWork work;
        ConnectorManagerRepository cmr;
        ConnectorManager connectorManager;
        RequestWorkItem workItem = context.getWorkItem();
        Assertion.isNotNull((Object)workItem);
        if ("SYS".equals(modelName) || "SYSADMIN".equals(modelName)) {
            return this.processSystemQuery(context, command, workItem.getDqpWorkContext());
        }
        AtomicRequestMessage aqr = this.createRequest(workItem, command, modelName, parameterObject.connectorBindingId, parameterObject.nodeID);
        aqr.setCommandContext(context);
        if (parameterObject.fetchSize > 0) {
            aqr.setFetchSize(2 * parameterObject.fetchSize);
        }
        if (parameterObject.limit > 0) {
            aqr.setFetchSize(Math.min(parameterObject.limit, aqr.getFetchSize()));
        }
        aqr.setCopyStreamingLobs(parameterObject.copyStreamingLobs);
        Collection<GroupSymbol> accessedGroups = null;
        if (context.getDataObjects() != null) {
            QueryMetadataInterface metadata = context.getMetadata();
            accessedGroups = GroupCollectorVisitor.getGroupsIgnoreInlineViews(command, false);
            boolean usedModel = false;
            for (GroupSymbol gs : accessedGroups) {
                String specificProp;
                TempMetadataID tid;
                context.accessedDataObject(gs.getMetadataID());
                Object mid = gs.getMetadataID();
                if (mid instanceof TempMetadataID && (tid = (TempMetadataID)mid).getOriginalMetadataID() != null) {
                    mid = tid.getOriginalMetadataID();
                }
                if ((specificProp = metadata.getExtensionProperty(mid, "teiid_rel:DETERMINISM", false)) == null) {
                    Object modelId;
                    String prop;
                    if (usedModel || (prop = metadata.getExtensionProperty(modelId = metadata.getModelID(mid), "teiid_rel:DETERMINISM", false)) == null) continue;
                    usedModel = true;
                    context.setDeterminismLevel(FunctionMethod.Determinism.valueOf((String)prop.toUpperCase()));
                    continue;
                }
                context.setDeterminismLevel(FunctionMethod.Determinism.valueOf((String)specificProp.toUpperCase()));
            }
        }
        if ((connectorManager = (cmr = (ConnectorManagerRepository)workItem.getDqpWorkContext().getVDB().getAttachment(ConnectorManagerRepository.class)).getConnectorManager(aqr.getConnectorName())) == null) {
            if (RelationalNodeUtil.hasOutputParams(command)) {
                throw new AssertionError((Object)"A source is required to execute a procedure returning parameters");
            }
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"source", (Object)aqr.getConnectorName(), (Object)"no longer exists, returning dummy results");
            return CollectionTupleSource.createNullTupleSource();
        }
        try {
            work = connectorManager.registerRequest(aqr);
        }
        catch (TranslatorException te) {
            throw new TeiidProcessingException((Throwable)te);
        }
        if (!work.isForkable()) {
            aqr.setSerial(true);
        }
        SessionAwareCache.CacheID cid = null;
        CacheDirective cd = null;
        if (workItem.getRsCache() != null && command.areResultsCachable()) {
            TupleSourceCache.CachableVisitor cv = new TupleSourceCache.CachableVisitor();
            PreOrPostOrderNavigator.doVisit(command, cv, true, true);
            if (cv.cacheable) {
                try {
                    cd = work.getCacheDirective();
                }
                catch (TranslatorException e) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30504, (Throwable)e, aqr.getConnectorName() + ": " + e.getMessage());
                }
                if (cd != null) {
                    if (cd.getScope() == CacheDirective.Scope.NONE) {
                        parameterObject.doNotCache = true;
                    } else {
                        String cmdString = command.toString();
                        if (cmdString.length() < 100000) {
                            cid = new SessionAwareCache.CacheID(workItem.getDqpWorkContext(), ParseInfo.DEFAULT_INSTANCE, cmdString);
                            cid.setParameters(cv.parameters);
                            if (cd.getInvalidation() == null || cd.getInvalidation() == CacheDirective.Invalidation.NONE) {
                                CachedResults cr = workItem.getRsCache().get(cid);
                                if (cr != null && (cr.getRowLimit() == 0 || parameterObject.limit > 0 && cr.getRowLimit() >= parameterObject.limit)) {
                                    parameterObject.doNotCache = true;
                                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Using cache entry for", (Object)cid);
                                    work.close();
                                    return cr.getResults().createIndexedTupleSource();
                                }
                            } else if (cd.getInvalidation() == CacheDirective.Invalidation.IMMEDIATE) {
                                workItem.getRsCache().remove(cid, CachingTupleSource.getDeterminismLevel(cd.getScope()));
                            }
                        }
                    }
                } else {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)aqr.getAtomicRequestID(), (Object)"no cache directive");
                }
            } else {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)aqr.getAtomicRequestID(), (Object)"command not cachable");
            }
        }
        TupleSource result = dtts = new DataTierTupleSource(aqr, workItem, work, this, parameterObject.limit);
        TupleBuffer tb = null;
        if (cid != null) {
            tb = this.getBufferManager().createTupleBuffer(aqr.getCommand().getProjectedSymbols(), aqr.getCommandContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
            result = new CachingTupleSource(this, tb, (DataTierTupleSource)result, cid, parameterObject, cd, accessedGroups, workItem);
        }
        if (work.isThreadBound()) {
            result = this.handleThreadBound(workItem, aqr, work, cid, result, dtts, tb);
        } else if (!aqr.isSerial()) {
            dtts.addWork();
        }
        return result;
    }

    private TupleSource handleThreadBound(RequestWorkItem workItem, AtomicRequestMessage aqr, ConnectorWork work, SessionAwareCache.CacheID cid, TupleSource result, DataTierTupleSource dtts, TupleBuffer tb) throws AssertionError, TeiidComponentException, TeiidProcessingException {
        if (workItem.useCallingThread) {
            aqr.setSerial(true);
            return result;
        }
        if (tb == null) {
            tb = this.getBufferManager().createTupleBuffer(aqr.getCommand().getProjectedSymbols(), aqr.getCommandContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
        }
        final TupleBuffer.TupleBufferTupleSource ts = tb.createIndexedTupleSource(cid == null);
        if (cid == null) {
            result = new TupleSourceCache.CopyOnReadTupleSource(tb, result){

                @Override
                public void closeSource() {
                    this.ts.closeSource();
                }
            };
        }
        final ThreadBoundTask callable = new ThreadBoundTask(workItem, result, dtts);
        if (aqr.isSerial()) {
            return new TupleSource(){
                boolean processed = false;

                @Override
                public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
                    if (!this.processed) {
                        callable.call();
                        callable.onCompletion((FutureWork<Void>)null);
                        this.processed = true;
                    }
                    return ts.nextTuple();
                }

                @Override
                public void closeSource() {
                    if (!this.processed) {
                        callable.onCompletion((FutureWork<Void>)null);
                        this.processed = true;
                    }
                    ts.closeSource();
                }
            };
        }
        aqr.setSerial(true);
        final FutureWork<Void> future = workItem.addWork(callable, callable, 100);
        final TupleBuffer buffer = tb;
        return new TupleSource(){
            boolean checkedDone;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
                if (!this.checkedDone && future.isDone()) {
                    this.checkedDone = true;
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        throw new TeiidComponentException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof TeiidComponentException) {
                            throw (TeiidComponentException)e.getCause();
                        }
                        if (e.getCause() instanceof TeiidProcessingException) {
                            throw (TeiidProcessingException)e.getCause();
                        }
                        throw new TeiidComponentException((Throwable)e);
                    }
                }
                TupleBuffer tupleBuffer = buffer;
                synchronized (tupleBuffer) {
                    return ts.nextTuple();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSource() {
                TupleBuffer tupleBuffer = buffer;
                synchronized (tupleBuffer) {
                    ts.closeSource();
                }
                callable.done.set(true);
            }
        };
    }

    private TupleSource processSystemQuery(CommandContext context, Command command, DQPWorkContext workContext) throws TeiidComponentException, TeiidProcessingException {
        String vdbName = workContext.getVdbName();
        String vdbVersion = workContext.getVdbVersion();
        VDBMetaData vdb = workContext.getVDB();
        TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        CompositeMetadataStore metadata = indexMetadata.getMetadataStore();
        if (command instanceof Query) {
            Query query = (Query)command;
            UnaryFromClause ufc = (UnaryFromClause)query.getFrom().getClauses().get(0);
            GroupSymbol group = ufc.getGroup();
            if (StringUtil.startsWithIgnoreCase((String)group.getNonCorrelationName(), (String)"SYSADMIN")) {
                SystemAdminTables sysTable = SystemAdminTables.valueOf(group.getNonCorrelationName().substring("SYSADMIN".length() + 1).toUpperCase());
                BaseExtractionTable<?> et = this.systemAdminTables.get((Object)sysTable);
                return et.processQuery(query, vdb, indexMetadata, context);
            }
            SystemTables sysTable = SystemTables.valueOf(group.getNonCorrelationName().substring("SYS".length() + 1).toUpperCase());
            BaseExtractionTable<?> et = this.systemTables.get((Object)sysTable);
            return et.processQuery(query, vdb, indexMetadata, context);
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        StoredProcedure proc = (StoredProcedure)command;
        for (SPParameter param : proc.getInputParameters()) {
            ProcedurePlan.checkNotNull(param.getParameterSymbol(), ((Constant)param.getExpression()).getValue(), context.getMetadata());
        }
        if (StringUtil.startsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)"SYSADMIN")) {
            SystemAdminProcs sysProc = SystemAdminProcs.valueOf(proc.getProcedureCallableName().substring("SYSADMIN".length() + 1).toUpperCase());
            switch (sysProc) {
                case TERMINATESESSION: {
                    String session = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                    boolean terminated = context.getWorkItem().getDqpCore().getSessionService().terminateSession(session, context.getSession().getSessionId());
                    rows.add(Arrays.asList(terminated));
                    return new CollectionTupleSource(rows.iterator());
                }
                case TERMINATETRANSACTION: {
                    String transactionId = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    try {
                        context.getWorkItem().getDqpCore().terminateTransaction(transactionId);
                    }
                    catch (AdminException e) {
                        throw new TeiidProcessingException((Throwable)e);
                    }
                    return new CollectionTupleSource(rows.iterator());
                }
                case CANCELREQUEST: {
                    String session = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                    long executionId = (Long)((Constant)proc.getParameter(3).getExpression()).getValue();
                    boolean cancelled = context.getWorkItem().getDqpCore().cancelRequest(session, executionId);
                    rows.add(Arrays.asList(cancelled));
                    return new CollectionTupleSource(rows.iterator());
                }
                case LOGMSG: 
                case ISLOGGABLE: {
                    String level = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                    String logContext = (String)((Constant)proc.getParameter(3).getExpression()).getValue();
                    Object message = null;
                    if (sysProc == SystemAdminProcs.LOGMSG) {
                        message = ((Constant)proc.getParameter(4).getExpression()).getValue();
                    }
                    int msgLevel = DataTierManagerImpl.getLevel(level);
                    boolean logged = false;
                    if (LogManager.isMessageToBeRecorded((String)logContext, (int)msgLevel)) {
                        if (message == null) {
                            message = "null";
                        }
                        LogManager.log((int)msgLevel, (String)logContext, (Object)message);
                        logged = true;
                    }
                    if (proc.returnParameters()) {
                        rows.add(Arrays.asList(logged));
                    }
                    return new CollectionTupleSource(rows.iterator());
                }
                case SETPROPERTY: {
                    try {
                        AbstractMetadataRecord target;
                        String uuid = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                        String key = (String)((Constant)proc.getParameter(3).getExpression()).getValue();
                        Clob value = (Clob)((Constant)proc.getParameter(4).getExpression()).getValue();
                        key = MetadataFactory.resolvePropertyKey((String)key);
                        String strVal = null;
                        String result = null;
                        if (value != null) {
                            if (value.length() > 0x200000L) {
                                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30548, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30548, new Object[]{0x200000}));
                            }
                            strVal = ObjectConverterUtil.convertToString((Reader)value.getCharacterStream());
                        }
                        if ((target = DataTierManagerImpl.getByUuid(metadata, uuid)) == null) {
                            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30549, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30549, new Object[]{uuid}));
                        }
                        AbstractMetadataRecord schema = target;
                        while (!(schema instanceof Schema) && schema.getParent() != null) {
                            schema = schema.getParent();
                        }
                        if (schema instanceof Schema && vdb.getImportedModels().contains(((Schema)schema).getName())) {
                            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31098, QueryPlugin.Util.getString("ValidationVisitor.invalid_alter", new Object[]{uuid}));
                        }
                        result = new DdlPlan.SetPropertyProcessor(this.getMetadataRepository(target, vdb), this.eventDistributor).setProperty(vdb, target, key, strVal);
                        if (proc.returnParameters()) {
                            if (result == null) {
                                rows.add(Arrays.asList(new Clob[]{null}));
                            } else {
                                rows.add(Arrays.asList(new ClobType((Clob)new ClobImpl(result))));
                            }
                        }
                        return new CollectionTupleSource(rows.iterator());
                    }
                    catch (SQLException e) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30550, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30551, (Throwable)e);
                    }
                }
                case SCHEMASOURCES: {
                    String schemaName = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    ModelMetaData mmd = vdb.getModel(schemaName);
                    if (mmd != null && mmd.isSource()) {
                        for (SourceMappingMetadata smm : mmd.getSourceMappings()) {
                            rows.add(Arrays.asList(smm.getName(), smm.getConnectionJndiName()));
                        }
                    }
                    return new CollectionTupleSource(rows.iterator());
                }
            }
            Table table = indexMetadata.getGroupID((String)((Constant)proc.getParameter(1).getExpression()).getValue());
            MetadataRepository metadataRepository = this.getMetadataRepository((AbstractMetadataRecord)table, vdb);
            switch (sysProc) {
                case SETCOLUMNSTATS: {
                    String columnName = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                    Column c = null;
                    for (Column col : table.getColumns()) {
                        if (!col.getName().equalsIgnoreCase(columnName)) continue;
                        c = col;
                        break;
                    }
                    if (c == null) {
                        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30552, columnName + TransformationMetadata.NOT_EXISTS_MESSAGE);
                    }
                    Number distinctVals = (Number)((Constant)proc.getParameter(3).getExpression()).getValue();
                    Number nullVals = (Number)((Constant)proc.getParameter(4).getExpression()).getValue();
                    String max = (String)((Constant)proc.getParameter(5).getExpression()).getValue();
                    String min = (String)((Constant)proc.getParameter(6).getExpression()).getValue();
                    ColumnStats columnStats = new ColumnStats();
                    columnStats.setDistinctValues(distinctVals);
                    columnStats.setNullValues(nullVals);
                    columnStats.setMaximumValue(max);
                    columnStats.setMinimumValue(min);
                    if (metadataRepository != null) {
                        metadataRepository.setColumnStats(vdbName, vdbVersion, c, columnStats);
                    }
                    DdlPlan.setColumnStats(vdb, c, columnStats);
                    if (this.eventDistributor == null) break;
                    this.eventDistributor.setColumnStats(vdbName, vdbVersion, ((Schema)table.getParent()).getName(), table.getName(), columnName, columnStats);
                    break;
                }
                case SETTABLESTATS: {
                    Constant val = (Constant)proc.getParameter(2).getExpression();
                    Number cardinality = (Number)val.getValue();
                    TableStats tableStats = new TableStats();
                    tableStats.setCardinality(cardinality);
                    if (metadataRepository != null) {
                        metadataRepository.setTableStats(vdbName, vdbVersion, table, tableStats);
                    }
                    DdlPlan.setTableStats(vdb, table, tableStats);
                    if (this.eventDistributor == null) break;
                    this.eventDistributor.setTableStats(vdbName, vdbVersion, ((Schema)table.getParent()).getName(), table.getName(), tableStats);
                }
            }
            return new CollectionTupleSource(rows.iterator());
        }
        SystemProcs sysTable = SystemProcs.valueOf(proc.getProcedureCallableName().substring("SYS".length() + 1).toUpperCase());
        switch (sysTable) {
            case ARRAYITERATE: {
                Object[] vals;
                Object array = ((Constant)proc.getParameter(1).getExpression()).getValue();
                if (array == null) break;
                if (array instanceof Object[]) {
                    vals = (Object[])array;
                } else {
                    ArrayImpl arrayImpl = (ArrayImpl)array;
                    vals = arrayImpl.getValues();
                }
                return new CollectionTupleSource(new Iterator<List<?>>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < vals.length;
                    }

                    @Override
                    public List<?> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return Arrays.asList(vals[this.index++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        }
        return new CollectionTupleSource(rows.iterator());
    }

    public MetadataRepository getMetadataRepository(AbstractMetadataRecord target, VDBMetaData vdb) {
        ModelMetaData model;
        String modelName = null;
        while (target.getParent() != null) {
            target = target.getParent();
        }
        modelName = target.getName();
        if (modelName != null && (model = vdb.getModel(modelName)) != null) {
            return (MetadataRepository)model.getAttachment(MetadataRepository.class);
        }
        return null;
    }

    public static AbstractMetadataRecord getByUuid(CompositeMetadataStore metadata, String uuid) {
        CompositeMetadataStore.RecordHolder holder = metadata.getOids().get(uuid);
        if (holder != null && uuid.equals(holder.getRecord().getUUID())) {
            return holder.getRecord();
        }
        return null;
    }

    private AtomicRequestMessage createRequest(RequestWorkItem workItem, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException {
        RequestMessage request = workItem.requestMsg;
        AtomicRequestMessage aqr = new AtomicRequestMessage(request, workItem.getDqpWorkContext(), nodeID);
        aqr.setCommand(command);
        aqr.setModelName(modelName);
        aqr.setMaxResultRows(this.requestMgr.getMaxSourceRows());
        aqr.setExceptionOnMaxRows(this.requestMgr.isExceptionOnMaxSourceRows());
        aqr.setPartialResults(request.supportsPartialResults());
        aqr.setSerial(this.requestMgr.getUserRequestSourceConcurrency() == 1);
        aqr.setTransactionContext(workItem.getTransactionContext());
        aqr.setBufferManager(this.getBufferManager());
        if (connectorBindingId == null) {
            VDBMetaData vdb = workItem.getDqpWorkContext().getVDB();
            ModelMetaData model = vdb.getModel(modelName);
            List bindings = model.getSourceNames();
            if (bindings == null || bindings.size() != 1) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30554, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30554, new Object[]{modelName, workItem.getDqpWorkContext().getVdbName(), workItem.getDqpWorkContext().getVdbVersion()}));
            }
            connectorBindingId = (String)bindings.get(0);
            Assertion.isNotNull((Object)connectorBindingId, (String)"could not obtain connector id");
        }
        aqr.setConnectorName(connectorBindingId);
        return aqr;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        throw new UnsupportedOperationException();
    }

    BufferManager getBufferManager() {
        return this.bufferManager;
    }

    static {
        levelMap.put("OFF", 0);
        levelMap.put("FATAL", 1);
        levelMap.put("ERROR", 2);
        levelMap.put("WARN", 3);
        levelMap.put("INFO", 4);
        levelMap.put("DEBUG", 5);
        levelMap.put("TRACE", 6);
        PREFIX_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        PREFIX_MAP.put("string", Arrays.asList("'", "'"));
        PREFIX_MAP.put("char", Arrays.asList("'", "'"));
        PREFIX_MAP.put("varbinary", Arrays.asList("'X", "'"));
        PREFIX_MAP.put("date", Arrays.asList("{'d", "'}"));
        PREFIX_MAP.put("time", Arrays.asList("{'t", "'}"));
        PREFIX_MAP.put("timestamp", Arrays.asList("{'ts", "'}"));
        PREFIX_MAP.put("boolean", Arrays.asList("{'b", "'}"));
    }

    static class Trigger {
        String name;
        String triggerType = "INSTEAD OF";
        String triggerEvent;
        String status;
        String body;

        Trigger(String name, String event, boolean status, String triggerType, String body) {
            this.name = name;
            this.triggerEvent = event;
            this.status = status ? "ENABLED" : "DISABLED";
            this.body = body;
            if (triggerType != null) {
                this.triggerType = triggerType;
            }
        }
    }

    private static enum SystemProcs {
        ARRAYITERATE;

    }

    private static enum SystemAdminProcs {
        SETTABLESTATS,
        SETCOLUMNSTATS,
        SETPROPERTY,
        LOGMSG,
        ISLOGGABLE,
        CANCELREQUEST,
        TERMINATESESSION,
        TERMINATETRANSACTION,
        SCHEMASOURCES;

    }

    private static enum SystemAdminTables {
        MATVIEWS,
        VDBRESOURCES,
        TRIGGERS,
        VIEWS,
        STOREDPROCEDURES,
        USAGE,
        SESSIONS,
        REQUESTS,
        TRANSACTIONS;

    }

    private static enum SystemTables {
        VIRTUALDATABASES,
        SCHEMAS,
        TABLES,
        DATATYPES,
        COLUMNS,
        KEYS,
        PROCEDURES,
        KEYCOLUMNS,
        PROCEDUREPARAMS,
        REFERENCEKEYCOLUMNS,
        PROPERTIES,
        FUNCTIONS,
        FUNCTIONPARAMS;

    }

    private static final class ThreadBoundTask
    implements Callable<Void>,
    DQPCore.CompletionListener<Void> {
        private final RequestWorkItem workItem;
        private final TupleSource toRead;
        final AtomicBoolean done = new AtomicBoolean();
        private final DataTierTupleSource dtts;

        private ThreadBoundTask(RequestWorkItem workItem, TupleSource toRead, DataTierTupleSource dtts) {
            this.workItem = workItem;
            this.toRead = toRead;
            this.dtts = dtts;
        }

        @Override
        public Void call() throws TeiidProcessingException, TeiidComponentException {
            while (true) {
                try {
                    while (!this.done.get() && this.toRead.nextTuple() != null) {
                        this.signalMore();
                    }
                    break;
                }
                catch (BlockedException e) {
                    Future<Void> future = this.dtts.getScheduledFuture();
                    if (future == null) continue;
                    try {
                        future.get();
                    }
                    catch (Exception e1) {
                        throw new TeiidComponentException((Throwable)((Object)e));
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalMore() {
            if (!this.done.get()) {
                RequestWorkItem requestWorkItem = this.workItem;
                synchronized (requestWorkItem) {
                    if (this.workItem.getThreadState() != AbstractWorkItem.ThreadState.MORE_WORK) {
                        this.workItem.moreWork();
                    }
                }
            }
        }

        @Override
        public void onCompletion(FutureWork<Void> future) {
            if (future != null) {
                this.signalMore();
            }
            this.toRead.closeSource();
            this.dtts.fullyCloseSource();
        }
    }
}

