/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.tools.validator.Validator;

public class OptionParameterValidator
implements Validator {
    private static final Map<String, Set<Class<?>>> ALLOWED_OPTION_PARAMETERS = new HashMap();

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Set emitterClassesOfPartition = finder.findAnnotatedMethods(Emitter.class).stream().filter(m -> m.getDeclaringClass().isAnnotationPresent(PartitionMapper.class)).map(Method::getReturnType).collect(Collectors.toSet());
        return finder.findAnnotatedMethods(PostConstruct.class).stream().filter(m -> m.getParameterCount() != 0).filter(m -> emitterClassesOfPartition.contains(m.getDeclaringClass()) || m.getDeclaringClass().isAnnotationPresent(Emitter.class)).flatMap(m -> Stream.concat(Arrays.stream(m.getParameters()).filter(p -> !p.isAnnotationPresent(Option.class)).map(p -> "Parameter '" + p.getName() + "' should be either annotated with @Option or removed"), Stream.concat(Arrays.stream(m.getParameters()).filter(p -> p.isAnnotationPresent(Option.class)).filter(p -> !ALLOWED_OPTION_PARAMETERS.containsKey(p.getAnnotation(Option.class).value())).map(p -> "Option value on the parameter '" + p.getName() + "' is not acceptable. Acceptable values: " + OptionParameterValidator.acceptableOptionValues()), Arrays.stream(m.getParameters()).filter(p -> p.isAnnotationPresent(Option.class)).filter(p -> ALLOWED_OPTION_PARAMETERS.containsKey(p.getAnnotation(Option.class).value())).filter(p -> !ALLOWED_OPTION_PARAMETERS.get(p.getAnnotation(Option.class).value()).contains(p.getType())).map(p -> "The '" + p.getName() + "' parameter's type is not acceptable. Acceptable types: " + OptionParameterValidator.acceptableTypeValues(p.getAnnotation(Option.class).value()))))).sorted();
    }

    private static String acceptableOptionValues() {
        return ALLOWED_OPTION_PARAMETERS.keySet().stream().sorted().collect(Collectors.joining(",", "[", "]"));
    }

    private static String acceptableTypeValues(String optionValue) {
        return ALLOWED_OPTION_PARAMETERS.getOrDefault(optionValue, Collections.emptySet()).stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(",", "[", "]"));
    }

    static {
        ALLOWED_OPTION_PARAMETERS.put("maxDurationMs", new HashSet<Class>(Arrays.asList(Integer.TYPE, Integer.class, Long.TYPE, Long.class)));
        ALLOWED_OPTION_PARAMETERS.put("maxRecords", new HashSet<Class>(Arrays.asList(Integer.TYPE, Integer.class, Long.TYPE, Long.class)));
    }
}

