/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Suggestions;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.update.Update;
import org.talend.sdk.component.tools.ComponentHelper;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class InternationalizationValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public InternationalizationValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Stream<Object> allMissing;
        Stream<String> bundlesError = components.stream().map(this::validateComponentResourceBundle).filter(Objects::nonNull).sorted();
        List optionsFields = finder.findAnnotatedFields(Option.class);
        Stream missingDisplayName = optionsFields.stream().map(Field::getType).filter(Class::isEnum).distinct().flatMap(enumType -> Stream.of(enumType.getFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())).filter(f -> this.hasNoBundleEntry((Class<?>)enumType, (Field)f, "_displayName")).map(f -> "Missing key " + enumType.getSimpleName() + "." + f.getName() + "._displayName in " + enumType + " resource bundle")).sorted();
        List missingOptionTranslations = optionsFields.stream().distinct().filter(this::fieldIsWithoutKey).map(f -> " " + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "._displayName = <" + f.getName() + ">").sorted().distinct().collect(Collectors.toList());
        if (missingOptionTranslations != null && !missingOptionTranslations.isEmpty()) {
            String missingMsg = missingOptionTranslations.stream().collect(Collectors.joining("\n", "Missing resource bundle entries:\n", ""));
            allMissing = Stream.of(missingMsg);
        } else {
            allMissing = Stream.empty();
        }
        ArrayList<String> internationalizedErrors = new ArrayList<String>();
        for (Class i : finder.findAnnotatedClasses(Internationalized.class)) {
            ResourceBundle resourceBundle = this.helper.findResourceBundle(i);
            if (resourceBundle != null) {
                Collection keys = Stream.of(i.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).map(m -> Arrays.asList(i.getName() + "." + m.getName(), i.getSimpleName() + "." + m.getName())).collect(Collectors.toSet());
                keys.stream().filter(ks -> ks.stream().noneMatch(resourceBundle::containsKey)).map(k -> "Missing key " + (String)k.iterator().next() + " in " + i + " resource bundle").sorted().forEach(internationalizedErrors::add);
                resourceBundle.keySet().stream().filter(k -> (k.startsWith(i.getName() + ".") || k.startsWith(i.getSimpleName() + ".")) && keys.stream().noneMatch(ks -> ks.contains(k))).map(k -> "Key " + k + " from " + i + " is no more used").sorted().forEach(internationalizedErrors::add);
                continue;
            }
            internationalizedErrors.add("No resource bundle for " + i);
        }
        Stream<String> actionsErrors = this.missingActionComment(finder);
        return Stream.of(bundlesError, missingDisplayName, allMissing, internationalizedErrors.stream(), actionsErrors).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private Stream<String> missingActionComment(AnnotationFinder finder) {
        return this.getActionsStream().flatMap(action -> finder.findAnnotatedMethods(action).stream()).map(action -> {
            String key;
            Annotation actionAnnotation = Stream.of(action.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ActionType.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("No action annotation on " + action));
            try {
                Class<? extends Annotation> annotationType = actionAnnotation.annotationType();
                key = "${family}.actions." + annotationType.getAnnotation(ActionType.class).value() + "." + annotationType.getMethod("value", new Class[0]).invoke((Object)actionAnnotation, new Object[0]).toString() + "._displayName";
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
            return this.helper.validateFamilyI18nKey(action.getDeclaringClass(), key);
        }).filter(Objects::nonNull);
    }

    private Stream<Class<? extends Annotation>> getActionsStream() {
        return Stream.of(AsyncValidation.class, DynamicValues.class, HealthCheck.class, DiscoverSchema.class, Suggestions.class, Update.class);
    }

    private String validateComponentResourceBundle(Class<?> component) {
        String baseName = Optional.ofNullable(component.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.helper.findResourceBundle(component);
        if (bundle == null) {
            return "No resource bundle for " + component.getName() + ", you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        String prefix = this.findPrefix(component);
        Collection missingKeys = Stream.of("_displayName").map(n -> prefix + "." + n).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + String.join((CharSequence)"\n", missingKeys);
        }
        return null;
    }

    private String findPrefix(Class<?> component) {
        return ComponentHelper.components(component).map(c -> ComponentHelper.findFamily(c, component) + "." + c.name()).orElseThrow(() -> new IllegalStateException(component.getName()));
    }

    private boolean hasNoBundleEntry(Class<?> enumType, Field f, String keyName) {
        ResourceBundle bundle = this.findBundleFor(enumType, f);
        String key = enumType.getSimpleName() + "." + f.getName() + "." + keyName;
        return bundle == null || !bundle.containsKey(key);
    }

    private ResourceBundle findBundleFor(Class<?> enumType, Field f) {
        return Optional.ofNullable(this.helper.findResourceBundle(enumType)).orElseGet(() -> this.helper.findResourceBundle(f.getDeclaringClass()));
    }

    private boolean fieldIsWithoutKey(Field field) {
        ResourceBundle bundle = Optional.ofNullable(this.helper.findResourceBundle(field.getDeclaringClass())).orElseGet(() -> this.helper.findResourceBundle(field.getType()));
        String key = field.getDeclaringClass().getSimpleName() + "." + field.getName() + "._displayName";
        return bundle == null || !bundle.containsKey(key);
    }
}

