/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateChecker {
    private static final Logger logger = LoggerFactory.getLogger(DuplicateChecker.class);

    private DuplicateChecker() {
    }

    public static void checkDuplicate(Class<?> cls) {
        DuplicateChecker.checkDuplicate(cls.getName().replace('.', '/') + ".class");
    }

    public static void checkDuplicate(String path) {
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(path);
            HashSet<String> files = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String file;
                URL url = urls.nextElement();
                if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
                files.add(file);
            }
            if (files.size() > 1) {
                logger.error("Duplicate class " + path + " in " + files.size() + " jar " + files);
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

