/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.AnonymousAction;
import org.squirrelframework.foundation.fsm.ImmutableTimedState;
import org.squirrelframework.foundation.fsm.MutableTimedState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.StateImpl;

public class TimedStateImpl<T extends StateMachine<T, S, E, C>, S, E, C>
extends StateImpl<T, S, E, C>
implements ImmutableTimedState<T, S, E, C>,
MutableTimedState<T, S, E, C> {
    private long timeInterval;
    private long initialDelay;
    private E autoFireEvent;
    private C autoFireContext;
    private final ScheduledExecutorService scheduler = SquirrelConfiguration.getScheduler();
    private final transient Map<String, Future<?>> futures = Maps.newConcurrentMap();
    private Action<T, S, E, C> lastEntryAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S from, S to, E event, C context, T stateMachine) {
            Runnable scheduledTask = new Runnable((StateMachine)stateMachine){
                final /* synthetic */ StateMachine val$stateMachine;
                {
                    this.val$stateMachine = stateMachine;
                }

                @Override
                public void run() {
                    this.val$stateMachine.fire(TimedStateImpl.this.autoFireEvent, TimedStateImpl.this.autoFireContext);
                }
            };
            ScheduledFuture<?> future = TimedStateImpl.this.timeInterval <= 0L ? TimedStateImpl.this.scheduler.schedule(scheduledTask, TimedStateImpl.this.initialDelay, TimeUnit.MILLISECONDS) : TimedStateImpl.this.scheduler.scheduleAtFixedRate(scheduledTask, TimedStateImpl.this.initialDelay, TimedStateImpl.this.timeInterval, TimeUnit.MILLISECONDS);
            TimedStateImpl.this.futures.put(TimedStateImpl.this.getKey(stateMachine), future);
        }

        @Override
        public int weight() {
            return -2147483647;
        }

        @Override
        public String name() {
            return "__TIMED_STATE_ENTRY_ACTION";
        }
    };
    private Action<T, S, E, C> firstExitAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S from, S to, E event, C context, T stateMachine) {
            Future future = (Future)TimedStateImpl.this.futures.remove(TimedStateImpl.this.getKey(stateMachine));
            if (future != null) {
                future.cancel(false);
            }
        }

        @Override
        public int weight() {
            return 0x7FFFFFFE;
        }

        @Override
        public String name() {
            return "__TIMED_STATE_EXIT_ACTION";
        }
    };

    TimedStateImpl(S stateId) {
        super(stateId);
        this.entryActions.add(this.lastEntryAction);
        this.exitActions.add(this.firstExitAction);
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public E getAutoFireEvent() {
        return this.autoFireEvent;
    }

    @Override
    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    @Override
    public void setAutoFireEvent(E event) {
        this.autoFireEvent = event;
    }

    @Override
    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Override
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    public void setAutoFireContext(C context) {
        this.autoFireContext = context;
    }

    @Override
    public C getAutoFireContext() {
        return this.autoFireContext;
    }
}

