/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelPostProcessorProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public class SquirrelProvider
implements SquirrelSingleton {
    private static SquirrelProvider instance = new SquirrelProvider();
    private Map<Class<?>, Class<?>> implementationRegistry = new ConcurrentHashMap();

    public static SquirrelProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelProvider instance) {
        SquirrelProvider.instance = instance;
    }

    public <T> T newInstance(TypeReference<T> typeRef) {
        return this.newInstance(typeRef, null, null);
    }

    public <T> T newInstance(TypeReference<T> typeRef, Class<?>[] argTypes, Object[] args) {
        Class<T> clz = typeRef.getRawType();
        return clz.cast(this.newInstance(clz, argTypes, args));
    }

    public <T> T newInstance(Class<T> clz) {
        return this.newInstance(clz, null, null);
    }

    public <T> T newInstance(Class<T> clz, Class<?>[] argTypes, Object[] args) {
        Class<T> implementationClass = this.getImplementation(clz);
        if (args == null) {
            return this.postProcess(clz, ReflectUtils.newInstance(implementationClass));
        }
        Constructor<T> constructor = ReflectUtils.getConstructor(implementationClass, argTypes);
        return this.postProcess(clz, ReflectUtils.newInstance(constructor, args));
    }

    private <T> T postProcess(Class<T> clz, T component) {
        SquirrelPostProcessor<T> postProcessor = SquirrelPostProcessorProvider.getInstance().getPostProcessor(clz);
        if (postProcessor != null && component != null) {
            postProcessor.postProcess(component);
        }
        return component;
    }

    public void register(Class<?> clazz, Class<?> implementationClass) {
        this.implementationRegistry.put(clazz, implementationClass);
    }

    public void unregister(Class<?> clazz) {
        this.implementationRegistry.remove(clazz);
    }

    public void clearRegistry() {
        this.implementationRegistry.clear();
    }

    public <T> Class<T> getImplementation(Class<T> clz) {
        return this.resolveImplIfInterface(clz, new HashSet());
    }

    private <T> Class<T> resolveImplIfInterface(Class<T> clz, Set<Class<?>> visited) {
        if (!visited.add(clz)) {
            throw new IllegalStateException("Registration cycles: " + visited);
        }
        if (!clz.isInterface()) {
            Class<T> possibleImpl = this.fromRegistry(clz);
            if (possibleImpl != null && !possibleImpl.isInterface()) {
                clz = possibleImpl;
            }
            return clz;
        }
        Class<T> possibleImpl = this.fromRegistry(clz);
        if (possibleImpl == null) {
            possibleImpl = this.findImplementationClass(clz);
            this.register(clz, possibleImpl);
        }
        return this.resolveImplIfInterface(possibleImpl, visited);
    }

    private <T> Class<T> fromRegistry(Class<T> clz) {
        Class<?> impl = this.implementationRegistry.get(clz);
        return impl;
    }

    private <T> Class<T> findImplementationClass(Class<T> interfaceClass) {
        Class<?> implementationClass = null;
        String implClassName = interfaceClass.getName() + "Impl";
        try {
            implementationClass = Class.forName(implClassName);
        }
        catch (ClassNotFoundException e) {
            implClassName = ReflectUtils.getPackageName(interfaceClass.getName()) + ".impl." + interfaceClass.getSimpleName() + "Impl";
            implementationClass = ReflectUtils.getClass(implClassName);
        }
        return implementationClass;
    }
}

