/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface ApiVersionStrategy {
    default public Mono<String> resolveApiVersion(ServerWebExchange exchange2) {
        return Mono.justOrEmpty((Object)this.resolveVersion(exchange2));
    }

    @Deprecated(since="7.0.3", forRemoval=true)
    public @Nullable String resolveVersion(ServerWebExchange var1);

    public Comparable<?> parseVersion(String var1);

    public void validateVersion(@Nullable Comparable<?> var1, ServerWebExchange var2) throws MissingApiVersionException, InvalidApiVersionException;

    public @Nullable Comparable<?> getDefaultVersion();

    default public Mono<Comparable<?>> resolveParseAndValidateApiVersion(ServerWebExchange exchange2) {
        Mono result = this.resolveApiVersion(exchange2).map(value -> {
            Comparable<?> version;
            try {
                version = this.parseVersion((String)value);
            }
            catch (Exception ex) {
                throw new InvalidApiVersionException(value, null, ex);
            }
            this.validateVersion(version, exchange2);
            return version;
        });
        return result.switchIfEmpty(Mono.fromSupplier(() -> {
            Comparable<?> defaultVersion = this.getDefaultVersion();
            if (defaultVersion != null) {
                return defaultVersion;
            }
            this.validateVersion(null, exchange2);
            return null;
        }));
    }

    @Deprecated(since="7.0.3", forRemoval=true)
    default public @Nullable Comparable<?> resolveParseAndValidateVersion(ServerWebExchange exchange2) {
        Comparable<?> version;
        String value = this.resolveVersion(exchange2);
        if (value == null) {
            version = this.getDefaultVersion();
        } else {
            try {
                version = this.parseVersion(value);
            }
            catch (Exception ex) {
                throw new InvalidApiVersionException(value, null, ex);
            }
        }
        this.validateVersion(version, exchange2);
        return version;
    }

    public void handleDeprecations(Comparable<?> var1, Object var2, ServerWebExchange var3);
}

